/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.codegen.ui.sync;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.designer.languages.common.base.codesync.ChangeObject;
import org.eclipse.papyrus.designer.languages.common.codegen.ui.Activator;
import org.eclipse.papyrus.designer.languages.common.codegen.ui.sync.RecordEventsListener;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleEventListener;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleManager;

public class ManageChangeEvents {
    protected static Map<TransactionalEditingDomain, RecordEventsListener> registeredListeners = new HashMap<TransactionalEditingDomain, RecordEventsListener>();

    public static void startRecording(TransactionalEditingDomain domain) {
        if (!registeredListeners.containsKey(domain)) {
            RecordEventsListener recordEvents = new RecordEventsListener();
            registeredListeners.put(domain, recordEvents);
            domain.addResourceSetListener((ResourceSetListener)recordEvents);
            try {
                ServicesRegistry registry = ServiceUtilsForResourceSet.getInstance().getServiceRegistry(domain.getResourceSet());
                EditorLifecycleManager lifecycleManager = (EditorLifecycleManager)registry.getService(EditorLifecycleManager.class);
                lifecycleManager.addEditorLifecycleEventsListener((EditorLifecycleEventListener)new LifeCycleListener(domain));
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public static void stopRecording(TransactionalEditingDomain domain) {
        RecordEventsListener recordEvents = registeredListeners.get(domain);
        if (recordEvents != null) {
            domain.removeResourceSetListener((ResourceSetListener)recordEvents);
        }
        registeredListeners.remove(domain);
    }

    public static EList<ChangeObject> getChangeList(TransactionalEditingDomain domain) {
        RecordEventsListener recordEvents = registeredListeners.get(domain);
        if (recordEvents != null) {
            return recordEvents.getChangeList();
        }
        return null;
    }

    public static void initChangeList(TransactionalEditingDomain domain, boolean startAutomatically) {
        RecordEventsListener recordEvents = registeredListeners.get(domain);
        if (recordEvents != null) {
            recordEvents.initChangeList();
        } else if (startAutomatically) {
            ManageChangeEvents.startRecording(domain);
        }
    }

    protected static class LifeCycleListener
    implements EditorLifecycleEventListener {
        TransactionalEditingDomain domain;

        LifeCycleListener(TransactionalEditingDomain domain) {
            this.domain = domain;
        }

        public void postInit(IMultiDiagramEditor editor) {
        }

        public void postDisplay(IMultiDiagramEditor editor) {
        }

        public void beforeClose(IMultiDiagramEditor editor) {
            ManageChangeEvents.stopRecording(this.domain);
        }
    }
}

