/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.codegen;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class HideGeneratedFilter
extends ViewerFilter {
    private static final String GENERATED = "@generated";
    private static final String NOT = "NOT";

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IPackageFragment) {
            IPackageFragment pfrag = (IPackageFragment)element;
            try {
                return !this.allGenerated(pfrag);
            }
            catch (JavaModelException javaModelException) {
            }
        } else if (element instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)element;
            try {
                return !this.allGenerated(unit);
            }
            catch (JavaModelException javaModelException) {
            }
        } else if (element instanceof IType) {
            try {
                return !this.allGenerated((IType)element);
            }
            catch (JavaModelException unit) {
            }
        } else if (element instanceof IMember) {
            IMember member = (IMember)element;
            return !this.hasGeneratedTag(member);
        }
        return true;
    }

    private boolean allGenerated(IPackageFragment pfrag) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray = pfrag.getCompilationUnits();
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            if (!this.allGenerated(unit)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean allGenerated(ICompilationUnit unit) throws JavaModelException {
        IType[] iTypeArray = unit.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (!this.allGenerated(type)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean allGenerated(IType type) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (!this.hasGeneratedTag((IMember)field)) {
                return false;
            }
            ++n2;
        }
        iFieldArray = type.getMethods();
        n = iFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            IField method = iFieldArray[n2];
            if (!this.hasGeneratedTag((IMember)method)) {
                return false;
            }
            ++n2;
        }
        iFieldArray = type.getInitializers();
        n = iFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            IField initializer = iFieldArray[n2];
            if (!this.hasGeneratedTag((IMember)initializer)) {
                return false;
            }
            ++n2;
        }
        iFieldArray = type.getTypes();
        n = iFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            IField subtype = iFieldArray[n2];
            if (!this.allGenerated((IType)subtype)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean hasGeneratedTag(IMember member) {
        try {
            int pos;
            String source;
            String javadoc;
            ISourceRange range = member.getJavadocRange();
            if (range != null && (javadoc = (source = member.getCompilationUnit().getSource()).substring(range.getOffset(), range.getOffset() + range.getLength())) != null && (pos = javadoc.indexOf(GENERATED)) >= 0 && !(javadoc = javadoc.substring(pos + GENERATED.length()).trim()).startsWith(NOT)) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }
}

