/**
 * Copyright (c) 2013, 2020, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Michael Golubev (Montages) - initial API and implementation
 *   Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *   Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Bug 574258: [Toolsmiths] Improve GMF generation for manifest.MF and build.properties
 */
package xpt.plugin;

import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.papyrus.gmf.codegen.util.AbstractBuild;
import org.eclipse.xtend2.lib.StringConcatenation;

@Singleton
@SuppressWarnings("all")
public class build extends AbstractBuild {
  public CharSequence qualifiedClassName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("build.properties");
    return _builder;
  }

  public CharSequence fullPath(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence build(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    this.init(it.getID());
    _builder.newLineIfNotEmpty();
    CharSequence _license = this.license(it);
    _builder.append(_license);
    _builder.newLineIfNotEmpty();
    CharSequence _includes = this.includes(it);
    _builder.append(_includes);
    _builder.newLineIfNotEmpty();
    CharSequence _compileOrders = this.compileOrders(it);
    _builder.append(_compileOrders);
    _builder.newLineIfNotEmpty();
    CharSequence _declareSourceFolder = this.declareSourceFolder(it);
    _builder.append(_declareSourceFolder);
    _builder.newLineIfNotEmpty();
    CharSequence _declareOutputFolders = this.declareOutputFolders(it);
    _builder.append(_declareOutputFolders);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence declareOutputFolders(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("output.. = bin/");
    _builder.newLine();
    return _builder;
  }

  public CharSequence includes(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    String _buildBinaryIncludes = this.buildBinaryIncludes();
    _builder.append(_buildBinaryIncludes);
    _builder.newLineIfNotEmpty();
    String _buildSourceIncludes = this.buildSourceIncludes();
    _builder.append(_buildSourceIncludes);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence compileOrders(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("jars.compile.order = .");
    _builder.newLine();
    return _builder;
  }

  public CharSequence declareSourceFolder(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    String _buildSourceFolder = this.buildSourceFolder();
    _builder.append(_buildSourceFolder);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence license(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    String _buildLicense = this.buildLicense(it.getEditorGen().getCopyrightText());
    _builder.append(_buildLicense);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
