/*
 * Copyright (c) 2014, 2018 CEA and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   Kenn Hussey (CEA) - initial API and implementation
 *   Kenn Hussey (CEA) - 451350
 *   Kenn Hussey - 535301
 *
 */
package org.eclipse.uml2.uml.profile.standard.cdo;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.profile.standard.Derive;
import org.eclipse.uml2.uml.profile.standard.StandardPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Derive</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.profile.standard.cdo.DeriveImpl#getComputation <em>Computation</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.profile.standard.cdo.DeriveImpl#getBase_Abstraction <em>Base Abstraction</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DeriveImpl extends CDOObjectImpl implements Derive {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeriveImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return StandardPackage.Literals.DERIVE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected int eStaticFeatureCount() {
		return 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification getComputation() {
		return (ValueSpecification) eDynamicGet(StandardPackage.DERIVE__COMPUTATION,
				StandardPackage.Literals.DERIVE__COMPUTATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification basicGetComputation() {
		return (ValueSpecification) eDynamicGet(StandardPackage.DERIVE__COMPUTATION,
				StandardPackage.Literals.DERIVE__COMPUTATION, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetComputation(ValueSpecification newComputation, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject) newComputation, StandardPackage.DERIVE__COMPUTATION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setComputation(ValueSpecification newComputation) {
		eDynamicSet(StandardPackage.DERIVE__COMPUTATION, StandardPackage.Literals.DERIVE__COMPUTATION, newComputation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Abstraction getBase_Abstraction() {
		return (Abstraction) eDynamicGet(StandardPackage.DERIVE__BASE_ABSTRACTION,
				StandardPackage.Literals.DERIVE__BASE_ABSTRACTION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Abstraction basicGetBase_Abstraction() {
		return (Abstraction) eDynamicGet(StandardPackage.DERIVE__BASE_ABSTRACTION,
				StandardPackage.Literals.DERIVE__BASE_ABSTRACTION, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBase_Abstraction(Abstraction newBase_Abstraction) {
		eDynamicSet(StandardPackage.DERIVE__BASE_ABSTRACTION, StandardPackage.Literals.DERIVE__BASE_ABSTRACTION,
				newBase_Abstraction);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case StandardPackage.DERIVE__COMPUTATION:
			return basicSetComputation(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case StandardPackage.DERIVE__COMPUTATION:
			if (resolve)
				return getComputation();
			return basicGetComputation();
		case StandardPackage.DERIVE__BASE_ABSTRACTION:
			if (resolve)
				return getBase_Abstraction();
			return basicGetBase_Abstraction();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case StandardPackage.DERIVE__COMPUTATION:
			setComputation((ValueSpecification) newValue);
			return;
		case StandardPackage.DERIVE__BASE_ABSTRACTION:
			setBase_Abstraction((Abstraction) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case StandardPackage.DERIVE__COMPUTATION:
			setComputation((ValueSpecification) null);
			return;
		case StandardPackage.DERIVE__BASE_ABSTRACTION:
			setBase_Abstraction((Abstraction) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case StandardPackage.DERIVE__COMPUTATION:
			return basicGetComputation() != null;
		case StandardPackage.DERIVE__BASE_ABSTRACTION:
			return basicGetBase_Abstraction() != null;
		}
		return super.eIsSet(featureID);
	}

} //DeriveImpl
