/*
 * Copyright (c) 2018 CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Eike Stepper - initial API and implementation
 *
 */
package org.eclipse.uml2.uml.cdo.internal.util;

import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Element;

/**
 * @author Eike Stepper
 */
public abstract class CDOElementImpl
		extends org.eclipse.emf.cdo.ecore.impl.EModelElementImpl
		implements Element {

	protected CDOElementImpl() {
		super();
	}

	@Override
	public void cdoInternalPreAttach() {
		try {
			CacheAdapter cacheAdapter = getCacheAdapter();
			if (cacheAdapter != null) {
				eAdapters().remove(cacheAdapter);
			}
		} finally {
			super.cdoInternalPreAttach();
		}
	}

	protected abstract CacheAdapter getCacheAdapter();

	static {
		CacheAdapter cacheAdapter = CacheAdapter.getInstance();
		if (cacheAdapter.getClass() != CDOCacheAdapter.class) {
			if (!Boolean.getBoolean(
				"org.eclipse.uml2.uml.cdo.internal.impl.ElementImpl.noCDOCacheAdapter")) {
				CDOCacheAdapter.register(new CDOCacheAdapter());
			}
		}
	}

}
