/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey - 286329, 323181, 535301
 *   Kenn Hussey (CEA) - 327039, 351774, 418466, 451350, 485756
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;

import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ExceptionHandler;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.InvocationAction;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Invocation Action</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InvocationActionImpl#getInputs <em>Input</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InvocationActionImpl#getArguments <em>Argument</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.InvocationActionImpl#getOnPort <em>On Port</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class InvocationActionImpl
		extends ActionImpl
		implements InvocationAction {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvocationActionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.INVOCATION_ACTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<InputPin> getInputs() {
		CacheAdapter cache = getCacheAdapter();
		if (cache != null) {
			Resource eResource = eResource();
			@SuppressWarnings("unchecked")
			EList<InputPin> inputs = (EList<InputPin>) cache.get(eResource, this, UMLPackage.Literals.ACTION__INPUT);
			if (inputs == null) {
				cache.put(eResource, this, UMLPackage.Literals.ACTION__INPUT, inputs = new DerivedUnionEObjectEList<InputPin>(InputPin.class, this, UMLPackage.INVOCATION_ACTION__INPUT, INPUT_ESUBSETS));
			}
			return inputs;
		}
		return new DerivedUnionEObjectEList<InputPin>(InputPin.class, this, UMLPackage.INVOCATION_ACTION__INPUT, INPUT_ESUBSETS);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EList<InputPin> getArguments() {
		return (EList<InputPin>) eDynamicGet(UMLPackage.INVOCATION_ACTION__ARGUMENT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INVOCATION_ACTION__ARGUMENT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InputPin createArgument(String name, Type type, EClass eClass) {
		InputPin newArgument = (InputPin) create(eClass);
		getArguments().add(newArgument);
		if (name != null)
			newArgument.setName(name);
		if (type != null)
			newArgument.setType(type);
		return newArgument;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InputPin createArgument(String name, Type type) {
		return createArgument(name, type, UMLPackage.Literals.INPUT_PIN);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InputPin getArgument(String name, Type type) {
		return getArgument(name, type, false, null, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InputPin getArgument(String name, Type type, boolean ignoreCase,
			EClass eClass, boolean createOnDemand) {
		argumentLoop: for (InputPin argument : getArguments()) {
			if (eClass != null && !eClass.isInstance(argument))
				continue argumentLoop;
			if (name != null && !(ignoreCase ? name.equalsIgnoreCase(argument.getName()) : name.equals(argument.getName())))
				continue argumentLoop;
			if (type != null && !type.equals(argument.getType()))
				continue argumentLoop;
			return argument;
		}
		return createOnDemand && eClass != null ? createArgument(name, type, eClass) : null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Port getOnPort() {
		return (Port) eDynamicGet(UMLPackage.INVOCATION_ACTION__ON_PORT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INVOCATION_ACTION__ON_PORT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Port basicGetOnPort() {
		return (Port) eDynamicGet(UMLPackage.INVOCATION_ACTION__ON_PORT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INVOCATION_ACTION__ON_PORT, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOnPort(Port newOnPort) {
		eDynamicSet(UMLPackage.INVOCATION_ACTION__ON_PORT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INVOCATION_ACTION__ON_PORT, newOnPort);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.INVOCATION_ACTION__EANNOTATIONS:
			return ((InternalEList<?>) getEAnnotations()).basicRemove(otherEnd, msgs);
		case UMLPackage.INVOCATION_ACTION__OWNED_COMMENT:
			return ((InternalEList<?>) getOwnedComments()).basicRemove(otherEnd, msgs);
		case UMLPackage.INVOCATION_ACTION__NAME_EXPRESSION:
			return basicSetNameExpression(null, msgs);
		case UMLPackage.INVOCATION_ACTION__IN_INTERRUPTIBLE_REGION:
			return ((InternalEList<?>) getInInterruptibleRegions()).basicRemove(otherEnd, msgs);
		case UMLPackage.INVOCATION_ACTION__IN_STRUCTURED_NODE:
			return basicSetInStructuredNode(null, msgs);
		case UMLPackage.INVOCATION_ACTION__INCOMING:
			return ((InternalEList<?>) getIncomings()).basicRemove(otherEnd, msgs);
		case UMLPackage.INVOCATION_ACTION__OUTGOING:
			return ((InternalEList<?>) getOutgoings()).basicRemove(otherEnd, msgs);
		case UMLPackage.INVOCATION_ACTION__IN_PARTITION:
			return ((InternalEList<?>) getInPartitions()).basicRemove(otherEnd, msgs);
		case UMLPackage.INVOCATION_ACTION__HANDLER:
			return ((InternalEList<?>) getHandlers()).basicRemove(otherEnd, msgs);
		case UMLPackage.INVOCATION_ACTION__LOCAL_POSTCONDITION:
			return ((InternalEList<?>) getLocalPostconditions()).basicRemove(otherEnd, msgs);
		case UMLPackage.INVOCATION_ACTION__LOCAL_PRECONDITION:
			return ((InternalEList<?>) getLocalPreconditions()).basicRemove(otherEnd, msgs);
		case UMLPackage.INVOCATION_ACTION__ARGUMENT:
			return ((InternalEList<?>) getArguments()).basicRemove(otherEnd, msgs);
		}
		return eDynamicInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.INVOCATION_ACTION__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.INVOCATION_ACTION__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.INVOCATION_ACTION__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.INVOCATION_ACTION__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.INVOCATION_ACTION__CLIENT_DEPENDENCY:
			return getClientDependencies();
		case UMLPackage.INVOCATION_ACTION__NAME:
			return getName();
		case UMLPackage.INVOCATION_ACTION__NAME_EXPRESSION:
			if (resolve)
				return getNameExpression();
			return basicGetNameExpression();
		case UMLPackage.INVOCATION_ACTION__NAMESPACE:
			if (resolve)
				return getNamespace();
			return basicGetNamespace();
		case UMLPackage.INVOCATION_ACTION__QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.INVOCATION_ACTION__VISIBILITY:
			return getVisibility();
		case UMLPackage.INVOCATION_ACTION__IS_LEAF:
			return isLeaf();
		case UMLPackage.INVOCATION_ACTION__REDEFINED_ELEMENT:
			return getRedefinedElements();
		case UMLPackage.INVOCATION_ACTION__REDEFINITION_CONTEXT:
			return getRedefinitionContexts();
		case UMLPackage.INVOCATION_ACTION__ACTIVITY:
			if (resolve)
				return getActivity();
			return basicGetActivity();
		case UMLPackage.INVOCATION_ACTION__IN_GROUP:
			return getInGroups();
		case UMLPackage.INVOCATION_ACTION__IN_INTERRUPTIBLE_REGION:
			return getInInterruptibleRegions();
		case UMLPackage.INVOCATION_ACTION__IN_STRUCTURED_NODE:
			if (resolve)
				return getInStructuredNode();
			return basicGetInStructuredNode();
		case UMLPackage.INVOCATION_ACTION__INCOMING:
			return getIncomings();
		case UMLPackage.INVOCATION_ACTION__OUTGOING:
			return getOutgoings();
		case UMLPackage.INVOCATION_ACTION__REDEFINED_NODE:
			return getRedefinedNodes();
		case UMLPackage.INVOCATION_ACTION__IN_PARTITION:
			return getInPartitions();
		case UMLPackage.INVOCATION_ACTION__HANDLER:
			return getHandlers();
		case UMLPackage.INVOCATION_ACTION__CONTEXT:
			if (resolve)
				return getContext();
			return basicGetContext();
		case UMLPackage.INVOCATION_ACTION__INPUT:
			return getInputs();
		case UMLPackage.INVOCATION_ACTION__IS_LOCALLY_REENTRANT:
			return isLocallyReentrant();
		case UMLPackage.INVOCATION_ACTION__LOCAL_POSTCONDITION:
			return getLocalPostconditions();
		case UMLPackage.INVOCATION_ACTION__LOCAL_PRECONDITION:
			return getLocalPreconditions();
		case UMLPackage.INVOCATION_ACTION__OUTPUT:
			return getOutputs();
		case UMLPackage.INVOCATION_ACTION__ARGUMENT:
			return getArguments();
		case UMLPackage.INVOCATION_ACTION__ON_PORT:
			if (resolve)
				return getOnPort();
			return basicGetOnPort();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.INVOCATION_ACTION__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__NAME:
			setName((String) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__NAME_EXPRESSION:
			setNameExpression((StringExpression) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__VISIBILITY:
			setVisibility((VisibilityKind) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__IS_LEAF:
			setIsLeaf((Boolean) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__ACTIVITY:
			setActivity((Activity) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__IN_INTERRUPTIBLE_REGION:
			getInInterruptibleRegions().clear();
			getInInterruptibleRegions().addAll((Collection<? extends InterruptibleActivityRegion>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__IN_STRUCTURED_NODE:
			setInStructuredNode((StructuredActivityNode) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__INCOMING:
			getIncomings().clear();
			getIncomings().addAll((Collection<? extends ActivityEdge>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__OUTGOING:
			getOutgoings().clear();
			getOutgoings().addAll((Collection<? extends ActivityEdge>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__REDEFINED_NODE:
			getRedefinedNodes().clear();
			getRedefinedNodes().addAll((Collection<? extends ActivityNode>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__IN_PARTITION:
			getInPartitions().clear();
			getInPartitions().addAll((Collection<? extends ActivityPartition>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__HANDLER:
			getHandlers().clear();
			getHandlers().addAll((Collection<? extends ExceptionHandler>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__IS_LOCALLY_REENTRANT:
			setIsLocallyReentrant((Boolean) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__LOCAL_POSTCONDITION:
			getLocalPostconditions().clear();
			getLocalPostconditions().addAll((Collection<? extends Constraint>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__LOCAL_PRECONDITION:
			getLocalPreconditions().clear();
			getLocalPreconditions().addAll((Collection<? extends Constraint>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__ARGUMENT:
			getArguments().clear();
			getArguments().addAll((Collection<? extends InputPin>) newValue);
			return;
		case UMLPackage.INVOCATION_ACTION__ON_PORT:
			setOnPort((Port) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.INVOCATION_ACTION__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__NAME:
			unsetName();
			return;
		case UMLPackage.INVOCATION_ACTION__NAME_EXPRESSION:
			setNameExpression((StringExpression) null);
			return;
		case UMLPackage.INVOCATION_ACTION__VISIBILITY:
			unsetVisibility();
			return;
		case UMLPackage.INVOCATION_ACTION__IS_LEAF:
			setIsLeaf(IS_LEAF_EDEFAULT);
			return;
		case UMLPackage.INVOCATION_ACTION__ACTIVITY:
			setActivity((Activity) null);
			return;
		case UMLPackage.INVOCATION_ACTION__IN_INTERRUPTIBLE_REGION:
			getInInterruptibleRegions().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__IN_STRUCTURED_NODE:
			setInStructuredNode((StructuredActivityNode) null);
			return;
		case UMLPackage.INVOCATION_ACTION__INCOMING:
			getIncomings().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__OUTGOING:
			getOutgoings().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__REDEFINED_NODE:
			getRedefinedNodes().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__IN_PARTITION:
			getInPartitions().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__HANDLER:
			getHandlers().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__IS_LOCALLY_REENTRANT:
			setIsLocallyReentrant(IS_LOCALLY_REENTRANT_EDEFAULT);
			return;
		case UMLPackage.INVOCATION_ACTION__LOCAL_POSTCONDITION:
			getLocalPostconditions().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__LOCAL_PRECONDITION:
			getLocalPreconditions().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__ARGUMENT:
			getArguments().clear();
			return;
		case UMLPackage.INVOCATION_ACTION__ON_PORT:
			setOnPort((Port) null);
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.INVOCATION_ACTION__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.INVOCATION_ACTION__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.INVOCATION_ACTION__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.INVOCATION_ACTION__OWNER:
			return isSetOwner();
		case UMLPackage.INVOCATION_ACTION__CLIENT_DEPENDENCY:
			return !getClientDependencies().isEmpty();
		case UMLPackage.INVOCATION_ACTION__NAME:
			return isSetName();
		case UMLPackage.INVOCATION_ACTION__NAME_EXPRESSION:
			return basicGetNameExpression() != null;
		case UMLPackage.INVOCATION_ACTION__NAMESPACE:
			return isSetNamespace();
		case UMLPackage.INVOCATION_ACTION__QUALIFIED_NAME:
			return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
		case UMLPackage.INVOCATION_ACTION__VISIBILITY:
			return isSetVisibility();
		case UMLPackage.INVOCATION_ACTION__IS_LEAF:
			return isLeaf() != IS_LEAF_EDEFAULT;
		case UMLPackage.INVOCATION_ACTION__REDEFINED_ELEMENT:
			return isSetRedefinedElements();
		case UMLPackage.INVOCATION_ACTION__REDEFINITION_CONTEXT:
			return isSetRedefinitionContexts();
		case UMLPackage.INVOCATION_ACTION__ACTIVITY:
			return basicGetActivity() != null;
		case UMLPackage.INVOCATION_ACTION__IN_GROUP:
			return isSetInGroups();
		case UMLPackage.INVOCATION_ACTION__IN_INTERRUPTIBLE_REGION:
			return !getInInterruptibleRegions().isEmpty();
		case UMLPackage.INVOCATION_ACTION__IN_STRUCTURED_NODE:
			return basicGetInStructuredNode() != null;
		case UMLPackage.INVOCATION_ACTION__INCOMING:
			return !getIncomings().isEmpty();
		case UMLPackage.INVOCATION_ACTION__OUTGOING:
			return !getOutgoings().isEmpty();
		case UMLPackage.INVOCATION_ACTION__REDEFINED_NODE:
			return !getRedefinedNodes().isEmpty();
		case UMLPackage.INVOCATION_ACTION__IN_PARTITION:
			return !getInPartitions().isEmpty();
		case UMLPackage.INVOCATION_ACTION__HANDLER:
			return !getHandlers().isEmpty();
		case UMLPackage.INVOCATION_ACTION__CONTEXT:
			return basicGetContext() != null;
		case UMLPackage.INVOCATION_ACTION__INPUT:
			return isSetInputs();
		case UMLPackage.INVOCATION_ACTION__IS_LOCALLY_REENTRANT:
			return isLocallyReentrant() != IS_LOCALLY_REENTRANT_EDEFAULT;
		case UMLPackage.INVOCATION_ACTION__LOCAL_POSTCONDITION:
			return !getLocalPostconditions().isEmpty();
		case UMLPackage.INVOCATION_ACTION__LOCAL_PRECONDITION:
			return !getLocalPreconditions().isEmpty();
		case UMLPackage.INVOCATION_ACTION__OUTPUT:
			return isSetOutputs();
		case UMLPackage.INVOCATION_ACTION__ARGUMENT:
			return !getArguments().isEmpty();
		case UMLPackage.INVOCATION_ACTION__ON_PORT:
			return basicGetOnPort() != null;
		}
		return eDynamicIsSet(featureID);
	}

	/**
	 * The array of subset feature identifiers for the '{@link #getInputs() <em>Input</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputs()
	 * @generated
	 * @ordered
	 */
	protected static final int[] INPUT_ESUBSETS = new int[] { UMLPackage.INVOCATION_ACTION__ARGUMENT };

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetInputs() {
		return super.isSetInputs()
				|| eIsSet(UMLPackage.INVOCATION_ACTION__ARGUMENT);
	}

} //InvocationActionImpl
