/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (CEA) - 327039, 212765, 418466, 451350, 485756
 *   Kenn Hussey - 535301
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interval Constraint</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.IntervalConstraintImpl#getSpecification <em>Specification</em>}</li>
 * </ul>
 *
 * @generated
 */
public class IntervalConstraintImpl
		extends ConstraintImpl
		implements IntervalConstraint {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntervalConstraintImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.INTERVAL_CONSTRAINT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ValueSpecification getSpecification() {
		return (ValueSpecification) eDynamicGet(UMLPackage.INTERVAL_CONSTRAINT__SPECIFICATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.CONSTRAINT__SPECIFICATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ValueSpecification basicGetSpecification() {
		return (ValueSpecification) eDynamicGet(UMLPackage.INTERVAL_CONSTRAINT__SPECIFICATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.CONSTRAINT__SPECIFICATION, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain basicSetSpecification(
			ValueSpecification newSpecification, NotificationChain msgs) {
		if (newSpecification != null && !(newSpecification instanceof Interval)) {
			throw new IllegalArgumentException("newSpecification must be an instance of Interval"); //$NON-NLS-1$
		}
		msgs = eDynamicInverseAdd((InternalEObject) newSpecification, UMLPackage.INTERVAL_CONSTRAINT__SPECIFICATION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSpecification(ValueSpecification newSpecification) {
		if (newSpecification != null && !(newSpecification instanceof Interval)) {
			throw new IllegalArgumentException("newSpecification must be an instance of Interval"); //$NON-NLS-1$
		}
		eDynamicSet(UMLPackage.INTERVAL_CONSTRAINT__SPECIFICATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.CONSTRAINT__SPECIFICATION, newSpecification);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification createSpecification(String name, Type type,
			EClass eClass) {
		ValueSpecification newSpecification = (ValueSpecification) create(eClass);
		setSpecification(newSpecification);
		if (name != null)
			newSpecification.setName(name);
		if (type != null)
			newSpecification.setType(type);
		return newSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetSpecification() {
		return basicGetSpecification() != null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.INTERVAL_CONSTRAINT__EANNOTATIONS:
			return ((InternalEList<?>) getEAnnotations()).basicRemove(otherEnd, msgs);
		case UMLPackage.INTERVAL_CONSTRAINT__OWNED_COMMENT:
			return ((InternalEList<?>) getOwnedComments()).basicRemove(otherEnd, msgs);
		case UMLPackage.INTERVAL_CONSTRAINT__NAME_EXPRESSION:
			return basicSetNameExpression(null, msgs);
		case UMLPackage.INTERVAL_CONSTRAINT__OWNING_TEMPLATE_PARAMETER:
			return basicSetOwningTemplateParameter(null, msgs);
		case UMLPackage.INTERVAL_CONSTRAINT__TEMPLATE_PARAMETER:
			return basicSetTemplateParameter(null, msgs);
		case UMLPackage.INTERVAL_CONSTRAINT__CONTEXT:
			return basicSetContext(null, msgs);
		case UMLPackage.INTERVAL_CONSTRAINT__SPECIFICATION:
			return basicSetSpecification(null, msgs);
		}
		return eDynamicInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.INTERVAL_CONSTRAINT__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.INTERVAL_CONSTRAINT__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.INTERVAL_CONSTRAINT__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.INTERVAL_CONSTRAINT__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.INTERVAL_CONSTRAINT__CLIENT_DEPENDENCY:
			return getClientDependencies();
		case UMLPackage.INTERVAL_CONSTRAINT__NAME:
			return getName();
		case UMLPackage.INTERVAL_CONSTRAINT__NAME_EXPRESSION:
			if (resolve)
				return getNameExpression();
			return basicGetNameExpression();
		case UMLPackage.INTERVAL_CONSTRAINT__NAMESPACE:
			if (resolve)
				return getNamespace();
			return basicGetNamespace();
		case UMLPackage.INTERVAL_CONSTRAINT__QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.INTERVAL_CONSTRAINT__VISIBILITY:
			return getVisibility();
		case UMLPackage.INTERVAL_CONSTRAINT__OWNING_TEMPLATE_PARAMETER:
			if (resolve)
				return getOwningTemplateParameter();
			return basicGetOwningTemplateParameter();
		case UMLPackage.INTERVAL_CONSTRAINT__TEMPLATE_PARAMETER:
			if (resolve)
				return getTemplateParameter();
			return basicGetTemplateParameter();
		case UMLPackage.INTERVAL_CONSTRAINT__CONSTRAINED_ELEMENT:
			return getConstrainedElements();
		case UMLPackage.INTERVAL_CONSTRAINT__CONTEXT:
			if (resolve)
				return getContext();
			return basicGetContext();
		case UMLPackage.INTERVAL_CONSTRAINT__SPECIFICATION:
			if (resolve)
				return getSpecification();
			return basicGetSpecification();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.INTERVAL_CONSTRAINT__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__NAME:
			setName((String) newValue);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__NAME_EXPRESSION:
			setNameExpression((StringExpression) newValue);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__VISIBILITY:
			setVisibility((VisibilityKind) newValue);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__OWNING_TEMPLATE_PARAMETER:
			setOwningTemplateParameter((TemplateParameter) newValue);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__TEMPLATE_PARAMETER:
			setTemplateParameter((TemplateParameter) newValue);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__CONSTRAINED_ELEMENT:
			getConstrainedElements().clear();
			getConstrainedElements().addAll((Collection<? extends Element>) newValue);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__CONTEXT:
			setContext((Namespace) newValue);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__SPECIFICATION:
			setSpecification((ValueSpecification) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.INTERVAL_CONSTRAINT__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__NAME:
			unsetName();
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__NAME_EXPRESSION:
			setNameExpression((StringExpression) null);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__VISIBILITY:
			unsetVisibility();
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__OWNING_TEMPLATE_PARAMETER:
			setOwningTemplateParameter((TemplateParameter) null);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__TEMPLATE_PARAMETER:
			setTemplateParameter((TemplateParameter) null);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__CONSTRAINED_ELEMENT:
			getConstrainedElements().clear();
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__CONTEXT:
			setContext((Namespace) null);
			return;
		case UMLPackage.INTERVAL_CONSTRAINT__SPECIFICATION:
			setSpecification((ValueSpecification) null);
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.INTERVAL_CONSTRAINT__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.INTERVAL_CONSTRAINT__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.INTERVAL_CONSTRAINT__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.INTERVAL_CONSTRAINT__OWNER:
			return isSetOwner();
		case UMLPackage.INTERVAL_CONSTRAINT__CLIENT_DEPENDENCY:
			return !getClientDependencies().isEmpty();
		case UMLPackage.INTERVAL_CONSTRAINT__NAME:
			return isSetName();
		case UMLPackage.INTERVAL_CONSTRAINT__NAME_EXPRESSION:
			return basicGetNameExpression() != null;
		case UMLPackage.INTERVAL_CONSTRAINT__NAMESPACE:
			return isSetNamespace();
		case UMLPackage.INTERVAL_CONSTRAINT__QUALIFIED_NAME:
			return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
		case UMLPackage.INTERVAL_CONSTRAINT__VISIBILITY:
			return isSetVisibility();
		case UMLPackage.INTERVAL_CONSTRAINT__OWNING_TEMPLATE_PARAMETER:
			return basicGetOwningTemplateParameter() != null;
		case UMLPackage.INTERVAL_CONSTRAINT__TEMPLATE_PARAMETER:
			return basicGetTemplateParameter() != null;
		case UMLPackage.INTERVAL_CONSTRAINT__CONSTRAINED_ELEMENT:
			return !getConstrainedElements().isEmpty();
		case UMLPackage.INTERVAL_CONSTRAINT__CONTEXT:
			return basicGetContext() != null;
		case UMLPackage.INTERVAL_CONSTRAINT__SPECIFICATION:
			return isSetSpecification();
		}
		return eDynamicIsSet(featureID);
	}

} //IntervalConstraintImpl
