/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (CEA) - 327039, 351774, 418466, 451350, 485756
 *   Kenn Hussey - 535301
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;

import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExceptionHandler;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Executable Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.ExecutableNodeImpl#getOwnedElements <em>Owned Element</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.ExecutableNodeImpl#getHandlers <em>Handler</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class ExecutableNodeImpl
		extends ActivityNodeImpl
		implements ExecutableNode {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutableNodeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.EXECUTABLE_NODE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Element> getOwnedElements() {
		CacheAdapter cache = getCacheAdapter();
		if (cache != null) {
			Resource eResource = eResource();
			@SuppressWarnings("unchecked")
			EList<Element> ownedElements = (EList<Element>) cache.get(eResource, this, UMLPackage.Literals.ELEMENT__OWNED_ELEMENT);
			if (ownedElements == null) {
				cache.put(eResource, this, UMLPackage.Literals.ELEMENT__OWNED_ELEMENT, ownedElements = new DerivedUnionEObjectEList<Element>(Element.class, this, UMLPackage.EXECUTABLE_NODE__OWNED_ELEMENT, OWNED_ELEMENT_ESUBSETS));
			}
			return ownedElements;
		}
		return new DerivedUnionEObjectEList<Element>(Element.class, this, UMLPackage.EXECUTABLE_NODE__OWNED_ELEMENT, OWNED_ELEMENT_ESUBSETS);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EList<ExceptionHandler> getHandlers() {
		return (EList<ExceptionHandler>) eDynamicGet(UMLPackage.EXECUTABLE_NODE__HANDLER - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.EXECUTABLE_NODE__HANDLER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExceptionHandler createHandler() {
		ExceptionHandler newHandler = (ExceptionHandler) create(UMLPackage.Literals.EXCEPTION_HANDLER);
		getHandlers().add(newHandler);
		return newHandler;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.EXECUTABLE_NODE__EANNOTATIONS:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getEAnnotations()).basicAdd(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__IN_INTERRUPTIBLE_REGION:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getInInterruptibleRegions()).basicAdd(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__IN_STRUCTURED_NODE:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetInStructuredNode((StructuredActivityNode) otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__INCOMING:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getIncomings()).basicAdd(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__OUTGOING:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getOutgoings()).basicAdd(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__IN_PARTITION:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getInPartitions()).basicAdd(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__HANDLER:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getHandlers()).basicAdd(otherEnd, msgs);
		}
		return eDynamicInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.EXECUTABLE_NODE__EANNOTATIONS:
			return ((InternalEList<?>) getEAnnotations()).basicRemove(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__OWNED_COMMENT:
			return ((InternalEList<?>) getOwnedComments()).basicRemove(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__NAME_EXPRESSION:
			return basicSetNameExpression(null, msgs);
		case UMLPackage.EXECUTABLE_NODE__IN_INTERRUPTIBLE_REGION:
			return ((InternalEList<?>) getInInterruptibleRegions()).basicRemove(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__IN_STRUCTURED_NODE:
			return basicSetInStructuredNode(null, msgs);
		case UMLPackage.EXECUTABLE_NODE__INCOMING:
			return ((InternalEList<?>) getIncomings()).basicRemove(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__OUTGOING:
			return ((InternalEList<?>) getOutgoings()).basicRemove(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__IN_PARTITION:
			return ((InternalEList<?>) getInPartitions()).basicRemove(otherEnd, msgs);
		case UMLPackage.EXECUTABLE_NODE__HANDLER:
			return ((InternalEList<?>) getHandlers()).basicRemove(otherEnd, msgs);
		}
		return eDynamicInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.EXECUTABLE_NODE__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.EXECUTABLE_NODE__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.EXECUTABLE_NODE__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.EXECUTABLE_NODE__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.EXECUTABLE_NODE__CLIENT_DEPENDENCY:
			return getClientDependencies();
		case UMLPackage.EXECUTABLE_NODE__NAME:
			return getName();
		case UMLPackage.EXECUTABLE_NODE__NAME_EXPRESSION:
			if (resolve)
				return getNameExpression();
			return basicGetNameExpression();
		case UMLPackage.EXECUTABLE_NODE__NAMESPACE:
			if (resolve)
				return getNamespace();
			return basicGetNamespace();
		case UMLPackage.EXECUTABLE_NODE__QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.EXECUTABLE_NODE__VISIBILITY:
			return getVisibility();
		case UMLPackage.EXECUTABLE_NODE__IS_LEAF:
			return isLeaf();
		case UMLPackage.EXECUTABLE_NODE__REDEFINED_ELEMENT:
			return getRedefinedElements();
		case UMLPackage.EXECUTABLE_NODE__REDEFINITION_CONTEXT:
			return getRedefinitionContexts();
		case UMLPackage.EXECUTABLE_NODE__ACTIVITY:
			if (resolve)
				return getActivity();
			return basicGetActivity();
		case UMLPackage.EXECUTABLE_NODE__IN_GROUP:
			return getInGroups();
		case UMLPackage.EXECUTABLE_NODE__IN_INTERRUPTIBLE_REGION:
			return getInInterruptibleRegions();
		case UMLPackage.EXECUTABLE_NODE__IN_STRUCTURED_NODE:
			if (resolve)
				return getInStructuredNode();
			return basicGetInStructuredNode();
		case UMLPackage.EXECUTABLE_NODE__INCOMING:
			return getIncomings();
		case UMLPackage.EXECUTABLE_NODE__OUTGOING:
			return getOutgoings();
		case UMLPackage.EXECUTABLE_NODE__REDEFINED_NODE:
			return getRedefinedNodes();
		case UMLPackage.EXECUTABLE_NODE__IN_PARTITION:
			return getInPartitions();
		case UMLPackage.EXECUTABLE_NODE__HANDLER:
			return getHandlers();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.EXECUTABLE_NODE__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__NAME:
			setName((String) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__NAME_EXPRESSION:
			setNameExpression((StringExpression) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__VISIBILITY:
			setVisibility((VisibilityKind) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__IS_LEAF:
			setIsLeaf((Boolean) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__ACTIVITY:
			setActivity((Activity) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__IN_INTERRUPTIBLE_REGION:
			getInInterruptibleRegions().clear();
			getInInterruptibleRegions().addAll((Collection<? extends InterruptibleActivityRegion>) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__IN_STRUCTURED_NODE:
			setInStructuredNode((StructuredActivityNode) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__INCOMING:
			getIncomings().clear();
			getIncomings().addAll((Collection<? extends ActivityEdge>) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__OUTGOING:
			getOutgoings().clear();
			getOutgoings().addAll((Collection<? extends ActivityEdge>) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__REDEFINED_NODE:
			getRedefinedNodes().clear();
			getRedefinedNodes().addAll((Collection<? extends ActivityNode>) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__IN_PARTITION:
			getInPartitions().clear();
			getInPartitions().addAll((Collection<? extends ActivityPartition>) newValue);
			return;
		case UMLPackage.EXECUTABLE_NODE__HANDLER:
			getHandlers().clear();
			getHandlers().addAll((Collection<? extends ExceptionHandler>) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.EXECUTABLE_NODE__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.EXECUTABLE_NODE__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.EXECUTABLE_NODE__NAME:
			unsetName();
			return;
		case UMLPackage.EXECUTABLE_NODE__NAME_EXPRESSION:
			setNameExpression((StringExpression) null);
			return;
		case UMLPackage.EXECUTABLE_NODE__VISIBILITY:
			unsetVisibility();
			return;
		case UMLPackage.EXECUTABLE_NODE__IS_LEAF:
			setIsLeaf(IS_LEAF_EDEFAULT);
			return;
		case UMLPackage.EXECUTABLE_NODE__ACTIVITY:
			setActivity((Activity) null);
			return;
		case UMLPackage.EXECUTABLE_NODE__IN_INTERRUPTIBLE_REGION:
			getInInterruptibleRegions().clear();
			return;
		case UMLPackage.EXECUTABLE_NODE__IN_STRUCTURED_NODE:
			setInStructuredNode((StructuredActivityNode) null);
			return;
		case UMLPackage.EXECUTABLE_NODE__INCOMING:
			getIncomings().clear();
			return;
		case UMLPackage.EXECUTABLE_NODE__OUTGOING:
			getOutgoings().clear();
			return;
		case UMLPackage.EXECUTABLE_NODE__REDEFINED_NODE:
			getRedefinedNodes().clear();
			return;
		case UMLPackage.EXECUTABLE_NODE__IN_PARTITION:
			getInPartitions().clear();
			return;
		case UMLPackage.EXECUTABLE_NODE__HANDLER:
			getHandlers().clear();
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.EXECUTABLE_NODE__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.EXECUTABLE_NODE__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.EXECUTABLE_NODE__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.EXECUTABLE_NODE__OWNER:
			return isSetOwner();
		case UMLPackage.EXECUTABLE_NODE__CLIENT_DEPENDENCY:
			return !getClientDependencies().isEmpty();
		case UMLPackage.EXECUTABLE_NODE__NAME:
			return isSetName();
		case UMLPackage.EXECUTABLE_NODE__NAME_EXPRESSION:
			return basicGetNameExpression() != null;
		case UMLPackage.EXECUTABLE_NODE__NAMESPACE:
			return isSetNamespace();
		case UMLPackage.EXECUTABLE_NODE__QUALIFIED_NAME:
			return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
		case UMLPackage.EXECUTABLE_NODE__VISIBILITY:
			return isSetVisibility();
		case UMLPackage.EXECUTABLE_NODE__IS_LEAF:
			return isLeaf() != IS_LEAF_EDEFAULT;
		case UMLPackage.EXECUTABLE_NODE__REDEFINED_ELEMENT:
			return isSetRedefinedElements();
		case UMLPackage.EXECUTABLE_NODE__REDEFINITION_CONTEXT:
			return isSetRedefinitionContexts();
		case UMLPackage.EXECUTABLE_NODE__ACTIVITY:
			return basicGetActivity() != null;
		case UMLPackage.EXECUTABLE_NODE__IN_GROUP:
			return isSetInGroups();
		case UMLPackage.EXECUTABLE_NODE__IN_INTERRUPTIBLE_REGION:
			return !getInInterruptibleRegions().isEmpty();
		case UMLPackage.EXECUTABLE_NODE__IN_STRUCTURED_NODE:
			return basicGetInStructuredNode() != null;
		case UMLPackage.EXECUTABLE_NODE__INCOMING:
			return !getIncomings().isEmpty();
		case UMLPackage.EXECUTABLE_NODE__OUTGOING:
			return !getOutgoings().isEmpty();
		case UMLPackage.EXECUTABLE_NODE__REDEFINED_NODE:
			return !getRedefinedNodes().isEmpty();
		case UMLPackage.EXECUTABLE_NODE__IN_PARTITION:
			return !getInPartitions().isEmpty();
		case UMLPackage.EXECUTABLE_NODE__HANDLER:
			return !getHandlers().isEmpty();
		}
		return eDynamicIsSet(featureID);
	}

	/**
	 * The array of subset feature identifiers for the '{@link #getOwnedElements() <em>Owned Element</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnedElements()
	 * @generated
	 * @ordered
	 */
	protected static final int[] OWNED_ELEMENT_ESUBSETS = new int[] { UMLPackage.EXECUTABLE_NODE__OWNED_COMMENT, UMLPackage.EXECUTABLE_NODE__NAME_EXPRESSION, UMLPackage.EXECUTABLE_NODE__HANDLER };

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetOwnedElements() {
		return super.isSetOwnedElements()
				|| eIsSet(UMLPackage.EXECUTABLE_NODE__HANDLER);
	}

} //ExecutableNodeImpl
