/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.FontStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Font Style</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.FontStyleImpl#getFontColor <em>Font Color</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.FontStyleImpl#getFontName <em>Font Name</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.FontStyleImpl#getFontHeight <em>Font Height</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.FontStyleImpl#isBold <em>Bold</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.FontStyleImpl#isItalic <em>Italic</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.FontStyleImpl#isUnderline <em>Underline</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.FontStyleImpl#isStrikeThrough <em>Strike Through</em>}</li>
 * </ul>
 *
 * @generated not
 */
public class FontStyleImpl extends org.eclipse.emf.cdo.ecore.impl.EModelElementImpl implements FontStyle {

	/**
	 * The default value of the '{@link #getFontColor() <em>Font Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getFontColor()
	 * @generated
	 * @ordered
	 */
	protected static final int FONT_COLOR_EDEFAULT = 0;

	/**
	 * The default value of the '{@link #getFontName() <em>Font Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getFontName()
	 * @generated
	 * @ordered
	 */
	protected static final String FONT_NAME_EDEFAULT = "Tahoma"; //$NON-NLS-1$

	/**
	 * The default value of the '{@link #getFontHeight() <em>Font Height</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getFontHeight()
	 * @generated
	 * @ordered
	 */
	protected static final int FONT_HEIGHT_EDEFAULT = 9;

	/**
	 * The default value of the '{@link #isBold() <em>Bold</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #isBold()
	 * @generated
	 * @ordered
	 */
	protected static final boolean BOLD_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isItalic() <em>Italic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #isItalic()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ITALIC_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isUnderline() <em>Underline</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #isUnderline()
	 * @generated
	 * @ordered
	 */
	protected static final boolean UNDERLINE_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isStrikeThrough() <em>Strike Through</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #isStrikeThrough()
	 * @generated
	 * @ordered
	 */
	protected static final boolean STRIKE_THROUGH_EDEFAULT = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected FontStyleImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattablestylePackage.Literals.FONT_STYLE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * Decrease the generated ESTATIC_FEATURE_COUNT from 1 to 0 because the inherited
	 * EModelElement.eAnnotations feature is implemented dynamically, too.
	 * <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	protected static final int ESTATIC_FEATURE_COUNT = 0;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected int eStaticFeatureCount() {
		return ESTATIC_FEATURE_COUNT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getFontColor() {
		return (Integer) eDynamicGet(NattablestylePackage.FONT_STYLE__FONT_COLOR - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__FONT_COLOR, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setFontColor(int newFontColor) {
		eDynamicSet(NattablestylePackage.FONT_STYLE__FONT_COLOR - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__FONT_COLOR, newFontColor);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getFontName() {
		return (String) eDynamicGet(NattablestylePackage.FONT_STYLE__FONT_NAME - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__FONT_NAME, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setFontName(String newFontName) {
		eDynamicSet(NattablestylePackage.FONT_STYLE__FONT_NAME - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__FONT_NAME, newFontName);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getFontHeight() {
		return (Integer) eDynamicGet(NattablestylePackage.FONT_STYLE__FONT_HEIGHT - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__FONT_HEIGHT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setFontHeight(int newFontHeight) {
		eDynamicSet(NattablestylePackage.FONT_STYLE__FONT_HEIGHT - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__FONT_HEIGHT, newFontHeight);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isBold() {
		return (Boolean) eDynamicGet(NattablestylePackage.FONT_STYLE__BOLD - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__BOLD, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setBold(boolean newBold) {
		eDynamicSet(NattablestylePackage.FONT_STYLE__BOLD - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__BOLD, newBold);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isItalic() {
		return (Boolean) eDynamicGet(NattablestylePackage.FONT_STYLE__ITALIC - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__ITALIC, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setItalic(boolean newItalic) {
		eDynamicSet(NattablestylePackage.FONT_STYLE__ITALIC - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__ITALIC, newItalic);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isUnderline() {
		return (Boolean) eDynamicGet(NattablestylePackage.FONT_STYLE__UNDERLINE - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__UNDERLINE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setUnderline(boolean newUnderline) {
		eDynamicSet(NattablestylePackage.FONT_STYLE__UNDERLINE - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__UNDERLINE, newUnderline);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isStrikeThrough() {
		return (Boolean) eDynamicGet(NattablestylePackage.FONT_STYLE__STRIKE_THROUGH - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__STRIKE_THROUGH, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setStrikeThrough(boolean newStrikeThrough) {
		eDynamicSet(NattablestylePackage.FONT_STYLE__STRIKE_THROUGH - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.FONT_STYLE__STRIKE_THROUGH, newStrikeThrough);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NattablestylePackage.FONT_STYLE__FONT_COLOR:
			return getFontColor();
		case NattablestylePackage.FONT_STYLE__FONT_NAME:
			return getFontName();
		case NattablestylePackage.FONT_STYLE__FONT_HEIGHT:
			return getFontHeight();
		case NattablestylePackage.FONT_STYLE__BOLD:
			return isBold();
		case NattablestylePackage.FONT_STYLE__ITALIC:
			return isItalic();
		case NattablestylePackage.FONT_STYLE__UNDERLINE:
			return isUnderline();
		case NattablestylePackage.FONT_STYLE__STRIKE_THROUGH:
			return isStrikeThrough();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NattablestylePackage.FONT_STYLE__FONT_COLOR:
			setFontColor((Integer) newValue);
			return;
		case NattablestylePackage.FONT_STYLE__FONT_NAME:
			setFontName((String) newValue);
			return;
		case NattablestylePackage.FONT_STYLE__FONT_HEIGHT:
			setFontHeight((Integer) newValue);
			return;
		case NattablestylePackage.FONT_STYLE__BOLD:
			setBold((Boolean) newValue);
			return;
		case NattablestylePackage.FONT_STYLE__ITALIC:
			setItalic((Boolean) newValue);
			return;
		case NattablestylePackage.FONT_STYLE__UNDERLINE:
			setUnderline((Boolean) newValue);
			return;
		case NattablestylePackage.FONT_STYLE__STRIKE_THROUGH:
			setStrikeThrough((Boolean) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NattablestylePackage.FONT_STYLE__FONT_COLOR:
			setFontColor(FONT_COLOR_EDEFAULT);
			return;
		case NattablestylePackage.FONT_STYLE__FONT_NAME:
			setFontName(FONT_NAME_EDEFAULT);
			return;
		case NattablestylePackage.FONT_STYLE__FONT_HEIGHT:
			setFontHeight(FONT_HEIGHT_EDEFAULT);
			return;
		case NattablestylePackage.FONT_STYLE__BOLD:
			setBold(BOLD_EDEFAULT);
			return;
		case NattablestylePackage.FONT_STYLE__ITALIC:
			setItalic(ITALIC_EDEFAULT);
			return;
		case NattablestylePackage.FONT_STYLE__UNDERLINE:
			setUnderline(UNDERLINE_EDEFAULT);
			return;
		case NattablestylePackage.FONT_STYLE__STRIKE_THROUGH:
			setStrikeThrough(STRIKE_THROUGH_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NattablestylePackage.FONT_STYLE__FONT_COLOR:
			return getFontColor() != FONT_COLOR_EDEFAULT;
		case NattablestylePackage.FONT_STYLE__FONT_NAME:
			return FONT_NAME_EDEFAULT == null ? getFontName() != null : !FONT_NAME_EDEFAULT.equals(getFontName());
		case NattablestylePackage.FONT_STYLE__FONT_HEIGHT:
			return getFontHeight() != FONT_HEIGHT_EDEFAULT;
		case NattablestylePackage.FONT_STYLE__BOLD:
			return isBold() != BOLD_EDEFAULT;
		case NattablestylePackage.FONT_STYLE__ITALIC:
			return isItalic() != ITALIC_EDEFAULT;
		case NattablestylePackage.FONT_STYLE__UNDERLINE:
			return isUnderline() != UNDERLINE_EDEFAULT;
		case NattablestylePackage.FONT_STYLE__STRIKE_THROUGH:
			return isStrikeThrough() != STRIKE_THROUGH_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}
} // FontStyleImpl
