/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.StyledElementImpl;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IPasteConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>IPaste Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl.IPasteConfigurationImpl#getPostActions <em>Post Actions</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl.IPasteConfigurationImpl#isDetachedMode <em>Detached Mode</em>}</li>
 * </ul>
 *
 * @generated
 */
public class IPasteConfigurationImpl extends StyledElementImpl implements IPasteConfiguration {

	/**
	 * The default value of the '{@link #isDetachedMode() <em>Detached Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDetachedMode()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DETACHED_MODE_EDEFAULT = true;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPasteConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattableaxisconfigurationPackage.Literals.IPASTE_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<String> getPostActions() {
		return (EList<String>)eDynamicGet(NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__POST_ACTIONS - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.IPASTE_CONFIGURATION__POST_ACTIONS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isDetachedMode() {
		return (Boolean)eDynamicGet(NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__DETACHED_MODE - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.IPASTE_CONFIGURATION__DETACHED_MODE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDetachedMode(boolean newDetachedMode) {
		eDynamicSet(NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__DETACHED_MODE - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.IPASTE_CONFIGURATION__DETACHED_MODE, newDetachedMode);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__POST_ACTIONS:
				return getPostActions();
			case NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__DETACHED_MODE:
				return isDetachedMode();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__POST_ACTIONS:
				getPostActions().clear();
				getPostActions().addAll((Collection<? extends String>)newValue);
				return;
			case NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__DETACHED_MODE:
				setDetachedMode((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__POST_ACTIONS:
				getPostActions().clear();
				return;
			case NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__DETACHED_MODE:
				setDetachedMode(DETACHED_MODE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__POST_ACTIONS:
				return !getPostActions().isEmpty();
			case NattableaxisconfigurationPackage.IPASTE_CONFIGURATION__DETACHED_MODE:
				return isDetachedMode() != DETACHED_MODE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}
} // IPasteConfigurationImpl
