/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.validation.problems.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.cdo.validation.problems.EProblem;
import org.eclipse.papyrus.cdo.validation.problems.EProblemsContainer;
import org.eclipse.papyrus.cdo.validation.problems.ESeverity;
import org.eclipse.papyrus.cdo.validation.problems.ProblemsFactory;
import org.eclipse.papyrus.cdo.validation.problems.ProblemsPackage;
import org.eclipse.papyrus.cdo.validation.problems.internal.ProblemsPlugin;
import org.eclipse.papyrus.cdo.validation.problems.util.ProblemsEvent;
import org.eclipse.papyrus.cdo.validation.problems.util.ProblemsListener;

public class ProblemsManager {
    private final ManagerAdapter adapter;
    private EProblemsContainer problems;
    private ECrossReferenceAdapter xrefs;
    private ProblemsAdapter problemsAdapter;
    private CopyOnWriteArrayList<ProblemsListener> listeners = new CopyOnWriteArrayList();

    ProblemsManager(Notifier notifier) {
        this.adapter = new ManagerAdapter();
        notifier.eAdapters().add((Object)this.adapter);
        ((BasicNotifierImpl.EObservableAdapterList)notifier.eAdapters()).addListener((BasicNotifierImpl.EObservableAdapterList.Listener)this.adapter);
        this.xrefs = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)notifier);
        this.problems = ProblemsFactory.eINSTANCE.createEProblemsContainer();
        if (this.xrefs != null) {
            this.problems.eAdapters().add((Object)this.xrefs);
        }
        this.problemsAdapter = new ProblemsAdapter();
        this.problems.eAdapters().add((Object)this.problemsAdapter);
    }

    public static ProblemsManager getProblemsManager(ResourceSet resourceSet) {
        ProblemsManager result = null;
        for (Adapter next : resourceSet.eAdapters()) {
            if (!(next instanceof ManagerAdapter)) continue;
            result = ((ManagerAdapter)next).getManager();
            break;
        }
        if (result == null) {
            result = new ProblemsManager((Notifier)resourceSet);
        }
        return result;
    }

    public static ProblemsManager createProblemsManager(ResourceSet resourceSet, EClass customProblemClass) {
        if (customProblemClass == null) {
            throw new IllegalArgumentException("null customProblemClass");
        }
        return new Custom((Notifier)resourceSet, customProblemClass);
    }

    public static IStatus toIStatus(EProblem problem) {
        return new StatusWrapper(problem);
    }

    public EProblem createProblem(Diagnostic diagnostic) {
        return this.createProblem(diagnostic, null);
    }

    public EProblem createProblem(Diagnostic diagnostic, String type) {
        EProblem result;
        Object next;
        EObject element = null;
        Iterator data = diagnostic.getData().iterator();
        while (data.hasNext()) {
            next = data.next();
            if (!(next instanceof EObject) || next instanceof Resource) continue;
            element = (EObject)next;
            break;
        }
        if (element == null) {
            result = null;
        } else {
            result = this.createProblem();
            result.setSeverity(ESeverity.get(diagnostic.getSeverity()));
            result.setSource(diagnostic.getSource());
            result.setCode(diagnostic.getCode());
            result.setMessage(diagnostic.getMessage());
            if (type != null) {
                result.setType(type);
            }
            result.setElement(element);
            while (data.hasNext()) {
                next = data.next();
                if (!(next instanceof EObject) || next instanceof Resource) continue;
                result.getRelated().add((Object)((EObject)next));
            }
        }
        return result;
    }

    public Iterator<EProblem> getAllProblems() {
        return this.problems.allProblems();
    }

    public Iterator<EProblem> getAllProblems(EObject eObject) {
        EProblemsIterator<EStructuralFeature.Setting> result = this.xrefs == null ? this.problems.allProblems(eObject) : new EProblemsIterator<EStructuralFeature.Setting>(this.xrefs.getNonNavigableInverseReferences(eObject).iterator()){

            @Override
            protected EProblem convert(EStructuralFeature.Setting object) {
                return object.getEStructuralFeature() == ProblemsPackage.Literals.EPROBLEM__ELEMENT ? (EProblem)object.getEObject() : null;
            }
        };
        return result;
    }

    public Iterator<EProblem> getAllProblems(final Resource resource) {
        Iterator<EProblem> result = this.xrefs == null ? new Iterator<EProblem>(){
            private final Iterator<EProblem> all;
            private EProblem next;
            {
                this.all = ProblemsManager.this.getAllProblems();
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    while (this.all.hasNext()) {
                        EProblem couldBe = this.all.next();
                        if (couldBe.getElement().eResource() != resource) continue;
                        this.next = couldBe;
                        break;
                    }
                }
                return this.next != null;
            }

            @Override
            public EProblem next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                EProblem result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        } : new Iterator<EProblem>(resource){
            private final Iterator<EObject> objects;
            private Iterator<EProblem> iterator;
            {
                this.objects = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
                this.iterator = Collections.emptyList().iterator();
            }

            @Override
            public boolean hasNext() {
                while (!this.iterator.hasNext() && this.objects.hasNext()) {
                    this.iterator = ProblemsManager.this.getAllProblems(this.objects.next());
                }
                return this.iterator.hasNext();
            }

            @Override
            public EProblem next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return result;
    }

    public boolean addProblem(EProblem problem) {
        return this.problems.getProblems().add((Object)problem);
    }

    public boolean addDiagnostic(Diagnostic diagnostic) {
        return this.addDiagnostic(diagnostic, null);
    }

    public boolean addDiagnostic(Diagnostic diagnostic, String type) {
        boolean result;
        if (!diagnostic.getChildren().isEmpty()) {
            result = false;
            for (Diagnostic next : diagnostic.getChildren()) {
                boolean bl = result = this.addDiagnostic(next, type) || result;
            }
        } else {
            EProblem problem = this.createProblem(diagnostic, type);
            result = problem != null && this.addProblem(problem);
        }
        return result;
    }

    public void purgeProblems(EObject object) {
        this.purgeProblems(Collections.singleton(object));
    }

    public void purgeProblems(Collection<? extends EObject> objects) {
        this.purgeProblems((Iterator<? extends EObject>)EcoreUtil.getAllContents(objects));
    }

    public void purgeProblems(Resource resource) {
        this.purgeProblems((Iterator<? extends EObject>)EcoreUtil.getAllProperContents((Resource)resource, (boolean)false));
    }

    public void purgeAllProblems() {
        for (EProblem next : this.problems.getProblems()) {
            next.eAdapters().clear();
        }
        this.problems.getProblems().clear();
    }

    public void dispose() {
        Notifier target;
        if (this.problems != null) {
            this.problems.eAdapters().clear();
            TreeIterator iter = this.problems.eAllContents();
            while (iter.hasNext()) {
                ((EObject)iter.next()).eAdapters().clear();
            }
            this.problems = null;
        }
        if ((target = this.adapter.getTarget()) != null) {
            target.eAdapters().remove((Object)this.adapter);
        }
        this.listeners.clear();
    }

    protected EProblem createProblem() {
        return ProblemsFactory.eINSTANCE.createEProblem();
    }

    void setCrossReferenceAdapter(ECrossReferenceAdapter adapter) {
        if (adapter != this.xrefs) {
            if (this.xrefs != null && this.problems != null) {
                this.problems.eAdapters().remove((Object)this.xrefs);
            }
            this.xrefs = adapter;
            if (adapter != null && this.problems != null) {
                this.problems.eAdapters().add((Object)adapter);
            }
        }
    }

    private void purgeProblems(Iterator<? extends EObject> contents) {
        ArrayList<EProblem> toRemove = new ArrayList<EProblem>();
        while (contents.hasNext()) {
            Iterator<EProblem> problems = this.getAllProblems(contents.next());
            while (problems.hasNext()) {
                toRemove.add(problems.next());
            }
        }
        for (EProblem next : toRemove) {
            next.eAdapters().clear();
        }
        this.problems.getProblems().removeAll(toRemove);
    }

    public static void delete(EProblem problem) {
        EcoreUtil.remove((EObject)problem);
        problem.setElement(null);
        problem.eAdapters().clear();
    }

    public void addProblemsListener(ProblemsListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeProblemsListener(ProblemsListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireAdded(EProblem problem) {
        if (!this.listeners.isEmpty()) {
            ProblemsEvent event = new ProblemsEvent(this, 0, problem);
            for (ProblemsListener next : this.listeners) {
                try {
                    next.problemAdded(event);
                }
                catch (Exception e) {
                    ProblemsPlugin.INSTANCE.log(e);
                }
            }
        }
    }

    protected void fireRemoved(EProblem problem) {
        if (!this.listeners.isEmpty()) {
            ProblemsEvent event = new ProblemsEvent(this, 1, problem);
            for (ProblemsListener next : this.listeners) {
                try {
                    next.problemRemoved(event);
                }
                catch (Exception e) {
                    ProblemsPlugin.INSTANCE.log(e);
                }
            }
        }
    }

    static class Custom
    extends ProblemsManager {
        private final EClass customProblemClass;

        public Custom(Notifier notifier, EClass customProblemClass) {
            super(notifier);
            if (!ProblemsPackage.Literals.EPROBLEM.isSuperTypeOf(customProblemClass)) {
                throw new IllegalArgumentException("customProblemClass does not conform to EProblem");
            }
            this.customProblemClass = customProblemClass;
        }

        @Override
        protected EProblem createProblem() {
            return (EProblem)EcoreUtil.create((EClass)this.customProblemClass);
        }
    }

    private static abstract class EProblemsIterator<E>
    implements Iterator<EProblem> {
        private final Iterator<? extends E> delegate;
        private EProblem preparedNext;

        public EProblemsIterator(Iterator<? extends E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            if (this.preparedNext == null) {
                while (this.delegate.hasNext()) {
                    EProblem problem = this.convert(this.delegate.next());
                    if (problem == null) continue;
                    this.preparedNext = problem;
                    break;
                }
            }
            return this.preparedNext != null;
        }

        protected abstract EProblem convert(E var1);

        @Override
        public EProblem next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EProblem result = this.preparedNext;
            this.preparedNext = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private class ManagerAdapter
    extends AdapterImpl
    implements BasicNotifierImpl.EObservableAdapterList.Listener {
        private ManagerAdapter() {
        }

        ProblemsManager getManager() {
            return ProblemsManager.this;
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            if (newTarget == null) {
                ProblemsManager.this.dispose();
            }
        }

        public void added(Notifier notifier, Adapter adapter) {
            if (adapter instanceof ECrossReferenceAdapter) {
                ProblemsManager.this.setCrossReferenceAdapter((ECrossReferenceAdapter)adapter);
            }
        }

        public void removed(Notifier notifier, Adapter adapter) {
            if (adapter instanceof ECrossReferenceAdapter) {
                ProblemsManager.this.setCrossReferenceAdapter(null);
            }
        }
    }

    private class ProblemsAdapter
    extends AdapterImpl {
        private ProblemsAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == ProblemsPackage.Literals.EPROBLEMS_CONTAINER__PROBLEMS) {
                switch (msg.getEventType()) {
                    case 3: {
                        ProblemsManager.this.fireAdded((EProblem)msg.getNewValue());
                        break;
                    }
                    case 5: {
                        for (Object next : (Collection)msg.getNewValue()) {
                            ProblemsManager.this.fireAdded((EProblem)next);
                        }
                        break;
                    }
                    case 4: {
                        ProblemsManager.this.fireRemoved((EProblem)msg.getOldValue());
                        break;
                    }
                    case 6: {
                        for (Object next : (Collection)msg.getOldValue()) {
                            ProblemsManager.this.fireRemoved((EProblem)next);
                        }
                        break;
                    }
                }
            }
        }
    }

    private static class StatusWrapper
    implements IStatus {
        static final IStatus[] NO_STATUSES = new IStatus[0];
        private final EProblem problem;

        StatusWrapper(EProblem problem) {
            this.problem = problem;
        }

        public IStatus[] getChildren() {
            return NO_STATUSES;
        }

        public int getCode() {
            return this.problem.getCode();
        }

        public Throwable getException() {
            return null;
        }

        public String getMessage() {
            return this.problem.getMessage();
        }

        public String getPlugin() {
            return this.problem.getSource();
        }

        public int getSeverity() {
            return this.problem.getSeverity().getValue();
        }

        public boolean isMultiStatus() {
            return false;
        }

        public boolean isOK() {
            return this.getSeverity() == 0;
        }

        public boolean matches(int severityMask) {
            return (this.getSeverity() & severityMask) != 0;
        }
    }
}

