/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class UISafeProgressMonitor
implements IProgressMonitor {
    private final Display display;
    private final IProgressMonitor delegate;

    public UISafeProgressMonitor(IProgressMonitor delegate, Display display) {
        this.delegate = delegate;
        this.display = display;
    }

    private void exec(Runnable runnable) {
        if (Display.getCurrent() == this.display) {
            runnable.run();
        } else {
            this.display.syncExec(runnable);
        }
    }

    public void beginTask(final String name, final int totalWork) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                UISafeProgressMonitor.this.delegate.beginTask(name, totalWork);
            }
        });
    }

    public void internalWorked(final double work) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                UISafeProgressMonitor.this.delegate.internalWorked(work);
            }
        });
    }

    public boolean isCanceled() {
        final boolean[] result = new boolean[1];
        this.exec(new Runnable(){

            @Override
            public void run() {
                result[0] = UISafeProgressMonitor.this.delegate.isCanceled();
            }
        });
        return result[0];
    }

    public void setCanceled(final boolean value) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                UISafeProgressMonitor.this.delegate.setCanceled(value);
            }
        });
    }

    public void setTaskName(final String name) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                UISafeProgressMonitor.this.delegate.setTaskName(name);
            }
        });
    }

    public void subTask(final String name) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                UISafeProgressMonitor.this.delegate.subTask(name);
            }
        });
    }

    public void worked(final int work) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                UISafeProgressMonitor.this.delegate.worked(work);
            }
        });
    }

    public void done() {
        this.exec(new Runnable(){

            @Override
            public void run() {
                UISafeProgressMonitor.this.done();
            }
        });
    }
}

