/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.handlers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.cdo.internal.ui.views.DIResourceQuery;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelExportWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportModelHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event)) != null) {
            ExportModelHandler.exportModels(window, null, (IStructuredSelection)selection);
        }
        return null;
    }

    public static void exportModels(IWorkbenchWindow window, IContainer destination, IStructuredSelection selection) {
        ModelExportWizard wizard = new ModelExportWizard();
        wizard.init(window.getWorkbench(), selection);
        wizard.setInitialDestination(destination);
        new WizardDialog(window.getShell(), (IWizard)wizard).open();
    }

    public static void exportModels(IContainer destination, Iterable<URI> resourceURIs) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ArrayList models = Lists.newArrayList();
        for (URI next : resourceURIs) {
            CDOView view;
            CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)next);
            if (checkout == null || (view = checkout.getView()) == null) continue;
            try {
                CDOResourceNode resource = view.getResourceNode(CDOURIUtil.extractResourcePath((URI)next));
                if (!(resource instanceof CDOResource) || !DIResourceQuery.getDIResources(view).contains(resource)) continue;
                models.add(DIModel.getInstance((CDOResource)resource, true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (window != null && !models.isEmpty()) {
            ExportModelHandler.exportModels(window, destination, (IStructuredSelection)new StructuredSelection((List)models));
        }
    }
}

