/*****************************************************************************
 * Copyright (c) 2013, 2017 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.cdo.internal.ui.handlers;

import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.cdo.ui.Activator;

/**
 * This is the UnlockObjectsHandler type. Enjoy.
 */
public class UnlockObjectsHandler
		extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event)
			throws ExecutionException {

		List<Object> selected = UIHandlerUtil.getSelection(event);
		Activator.getActiveDawnEditor().getDawnEditorSupport()
				.unlockObjects(selected);

		return null;
	}
}
