/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.moka.launch.ExecutionEngineLaunchConfigurationReader;
import org.eclipse.papyrus.moka.trace.interfaces.format.ITraceFileFormater;
import org.eclipse.papyrus.moka.ui.launch.MokaExecutableElementSelection;
import org.eclipse.papyrus.moka.ui.launch.MokaExecutableSelectionComponent;
import org.eclipse.papyrus.moka.ui.launch.MokaExecutionEngineSelection;
import org.eclipse.papyrus.moka.ui.launch.MokaExecutionEngineSelectionComponent;
import org.eclipse.papyrus.moka.ui.launch.MokaProjectSelection;
import org.eclipse.papyrus.moka.ui.launch.MokaProjectSelectionComponent;
import org.eclipse.papyrus.moka.ui.launch.MokaTraceActivationListener;
import org.eclipse.papyrus.moka.ui.launch.MokaTraceServiceComponent;
import org.eclipse.papyrus.moka.ui.launch.MokaTriggerComboPopulation;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class MokaRunConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected static String TAB_NAME = "Moka Main";
    protected Composite mainContainer;
    protected MokaProjectSelectionComponent projectSelectionComp;
    protected MokaExecutableSelectionComponent executableSelectionComp;
    protected MokaExecutionEngineSelectionComponent executionEngineSelectionComp;
    protected MokaTraceServiceComponent traceServiceComp;
    protected Image image;

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String selectedExecutionEngine;
            String init_uri = configuration.getAttribute(ExecutionEngineLaunchConfigurationReader.MODEL_URI_ATTRIBUTE_NAME, "");
            if (!init_uri.equals("")) {
                this.projectSelectionComp.projectSelectionText.setText(init_uri);
                String init_fragment = configuration.getAttribute(ExecutionEngineLaunchConfigurationReader.MODEL_ELEMENT_URI_ATTRIBUTE_NAME, "");
                this.executableSelectionComp.eligibleExecutableElement.selectByURIFragment(init_fragment);
            }
            if ((selectedExecutionEngine = configuration.getAttribute("EXECUTION_ENGINE_ATTRIBUTE", "")) != null) {
                this.executionEngineSelectionComp.eligibleExecutionEngineCombo.setText(selectedExecutionEngine);
            }
            boolean isTraceServiceActivate = configuration.getAttribute("MOKA_TRACE_SERVICE_ACTIVATE", false);
            if (MokaTraceServiceComponent.shouldDisplay()) {
                this.traceServiceComp.traceCheckBox.setSelection(isTraceServiceActivate);
                this.traceServiceComp.enableTraceWidget(isTraceServiceActivate);
                String selectedTraceFilePath = configuration.getAttribute("MOKA_TRACE_FILE_PATH", "");
                this.traceServiceComp.filePathSelector.getText().setText(selectedTraceFilePath);
                String formaterId = configuration.getAttribute("MOKA_TRACE_FORMATER", "");
                this.traceServiceComp.setFormaterFromID(formaterId);
                Boolean isTracepointMode = configuration.getAttribute("MOKA_TRACE_TRACEPOINT_MODE", false);
                this.traceServiceComp.traceTracepointModeCheckBox.setSelection(isTracepointMode.booleanValue());
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String executionEngine;
        configuration.setAttribute(ExecutionEngineLaunchConfigurationReader.MODEL_URI_ATTRIBUTE_NAME, this.projectSelectionComp.projectSelectionText.getText());
        EObject selected = (EObject)this.executableSelectionComp.eligibleExecutableElement.getSelected();
        if (selected != null) {
            configuration.setAttribute(ExecutionEngineLaunchConfigurationReader.MODEL_ELEMENT_URI_ATTRIBUTE_NAME, selected.eResource().getURIFragment(selected));
        }
        if ((executionEngine = this.executionEngineSelectionComp.eligibleExecutionEngineCombo.getText()) != null) {
            configuration.setAttribute("EXECUTION_ENGINE_ATTRIBUTE", executionEngine);
        }
        if (MokaTraceServiceComponent.shouldDisplay() && this.traceServiceComp.traceCheckBox.getSelection()) {
            configuration.setAttribute("MOKA_TRACE_SERVICE_ACTIVATE", true);
            String traceFilePath = this.traceServiceComp.getFilePath();
            configuration.setAttribute("MOKA_TRACE_FILE_PATH", traceFilePath);
            ITraceFileFormater fileFormater = this.traceServiceComp.getFormater();
            configuration.setAttribute("MOKA_TRACE_FORMATER", fileFormater.getId());
            Boolean isTracepointMode = this.traceServiceComp.traceTracepointModeCheckBox.getSelection();
            configuration.setAttribute("MOKA_TRACE_TRACEPOINT_MODE", (Object)isTracepointMode);
        } else {
            configuration.setAttribute("MOKA_TRACE_SERVICE_ACTIVATE", false);
        }
    }

    public void createControl(Composite parent) {
        this.mainContainer = new Composite(parent, 4);
        this.mainContainer.setLayout((Layout)new GridLayout());
        this.projectSelectionComp = new MokaProjectSelectionComponent(this.mainContainer, 4, "UML Model", 2);
        this.executableSelectionComp = new MokaExecutableSelectionComponent(this.mainContainer, 4, "Element to be executed", 2);
        this.executionEngineSelectionComp = new MokaExecutionEngineSelectionComponent(this.mainContainer, 4, "Execution Engine (if no selection, the default engine is used)", 2);
        if (MokaTraceServiceComponent.shouldDisplay()) {
            this.traceServiceComp = new MokaTraceServiceComponent(this.mainContainer, 4, "Generate trace", 1);
        }
        MokaProjectSelection listener = new MokaProjectSelection(this.projectSelectionComp.projectSelectionText, this);
        MokaTriggerComboPopulation comboPopulationTrigger = new MokaTriggerComboPopulation(this.executableSelectionComp.eligibleExecutableElement);
        this.projectSelectionComp.projectSelectionButton.addSelectionListener((SelectionListener)listener);
        this.projectSelectionComp.projectSelectionText.addModifyListener((ModifyListener)comboPopulationTrigger);
        this.executableSelectionComp.eligibleExecutableElement.addSelectionListener((SelectionListener)new MokaExecutableElementSelection(this));
        this.executionEngineSelectionComp.eligibleExecutionEngineCombo.addSelectionListener((SelectionListener)new MokaExecutionEngineSelection(this));
        if (MokaTraceServiceComponent.shouldDisplay()) {
            this.traceServiceComp.traceCheckBox.addSelectionListener((SelectionListener)new MokaTraceActivationListener(this));
            this.traceServiceComp.filePathSelector.addCommitListener(new ICommitListener(){

                public void commit(AbstractEditor editor) {
                    MokaRunConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.traceServiceComp.addRadioListener(this);
            this.traceServiceComp.addTracePointModeListner(this);
        }
        this.setControl((Control)this.mainContainer);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = new Image((Device)Display.getCurrent(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/moka_icon.png"));
        }
        return this.image;
    }
}

