/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.tracepoint.service.preferences;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.papyrus.moka.tracepoint.service.Activator;
import org.eclipse.papyrus.moka.tracepoint.service.ITraceMechanism;
import org.eclipse.papyrus.moka.tracepoint.service.Messages;
import org.eclipse.papyrus.moka.tracepoint.service.TraceActions;
import org.eclipse.papyrus.moka.tracepoint.service.TraceMechanism;
import org.eclipse.papyrus.moka.tracepoint.service.preferences.BinaryEncodedMChoiceFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TPPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public TPPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.TPPreferencePage_TraceOptions);
    }

    public void createFieldEditors() {
        List<ITraceMechanism> mechanisms = TraceMechanism.getTraceMechanisms();
        int elements = 0;
        for (ITraceMechanism mechanism : mechanisms) {
            EList<String> mechanismIDs = mechanism.getTraceMechanismIDs(null);
            elements += mechanismIDs.size();
        }
        String[][] mechList = new String[elements][2];
        elements = 0;
        for (ITraceMechanism mechanism : mechanisms) {
            EList<String> mechanismIDs = mechanism.getTraceMechanismIDs(null);
            for (String id : mechanismIDs) {
                String description = mechanism.getTraceMechanismDescription(null, id);
                if (description == null) {
                    description = Messages.TraceActionSelection_NotAvail;
                }
                mechList[elements][0] = id;
                mechList[elements][1] = description;
                ++elements;
            }
        }
        String[][] taClassOptions = TraceActions.getStringFields(TraceActions.TAClass.values());
        String[][] taStateOptions = TraceActions.getStringFields(TraceActions.TAState.values());
        String[][] taOperationOptions = TraceActions.getStringFields(TraceActions.TAOperation.values());
        String[][] taPortOptions = TraceActions.getStringFields(TraceActions.TAOperation.values());
        String[][] taTransitionOptions = TraceActions.getStringFields(TraceActions.TATransition.values());
        this.addField(new BinaryEncodedMChoiceFieldEditor("papyrus.trace.option.class", Messages.TraceActionSelection_ClassOptions, 3, taClassOptions, this.getFieldEditorParent(), true));
        this.addField(new BinaryEncodedMChoiceFieldEditor("papyrus.trace.option.state", Messages.TraceActionSelection_StateOptions, 3, taStateOptions, this.getFieldEditorParent(), true));
        this.addField(new BinaryEncodedMChoiceFieldEditor("papyrus.trace.option.op", Messages.TraceActionSelection_OperationOptions, 3, taOperationOptions, this.getFieldEditorParent(), true));
        this.addField(new BinaryEncodedMChoiceFieldEditor("papyrus.trace.option.port", Messages.TraceActionSelection_PortOptions, 3, taPortOptions, this.getFieldEditorParent(), true));
        this.addField(new BinaryEncodedMChoiceFieldEditor("papyrus.trace.option.transition", Messages.TraceActionSelection_TransitionOptions, 3, taTransitionOptions, this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new ComboFieldEditor("papyrus.trace.implementation", Messages.TPPreferencePage_TRACE_IMPL, mechList, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }
}

