/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.moka.kernel.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.kernel.service.IExecutionEngineService;

public class ServiceRegistry {
    protected static String MOKA_SERVICE_EXTENSION_POINT_ID = "org.eclipse.papyrus.moka.kernel.service";
    protected HashMap<Class<?>, IExecutionEngineService<IExecutionEngine>> registry = new HashMap();
    protected static final String SERVICE_CLASS_ATTRIBUTE = "class";
    protected static final String SERVICE_CONTEXT_ELEMENT = "context";
    protected static final String SERVICE_ENGINE_ID = "engineID";
    private static ServiceRegistry INSTANCE;

    private ServiceRegistry() {
    }

    public static ServiceRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServiceRegistry();
        }
        return INSTANCE;
    }

    protected boolean canInstantiate(IConfigurationElement serviceSpecification, IExecutionEngine engine) {
        boolean canInstantiate = false;
        if (serviceSpecification != null) {
            IConfigurationElement[] contextSpecification = serviceSpecification.getChildren(SERVICE_CONTEXT_ELEMENT);
            if (contextSpecification.length == 0) {
                canInstantiate = true;
            } else {
                int i = 0;
                while (!canInstantiate && i < contextSpecification.length) {
                    if (!contextSpecification[i].getAttribute(SERVICE_ENGINE_ID).equals(engine.getID())) {
                        ++i;
                        continue;
                    }
                    canInstantiate = true;
                }
            }
        }
        return canInstantiate;
    }

    public void loadServices(IExecutionEngine engine) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configurations = registry.getConfigurationElementsFor(MOKA_SERVICE_EXTENSION_POINT_ID);
        int i = 0;
        while (i < configurations.length) {
            if (this.canInstantiate(configurations[i], engine)) {
                Object instantiatedContribution = null;
                try {
                    instantiatedContribution = configurations[i].createExecutableExtension(SERVICE_CLASS_ATTRIBUTE);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (instantiatedContribution != null && instantiatedContribution instanceof IExecutionEngineService) {
                    this.register((IExecutionEngineService)instantiatedContribution);
                }
            }
            ++i;
        }
    }

    protected void register(IExecutionEngineService<IExecutionEngine> service) {
        if (service != null) {
            this.registry.put(service.getClass(), service);
        }
    }

    public List<IExecutionEngineService<IExecutionEngine>> getService(Class<?> clazz) {
        ArrayList<IExecutionEngineService<IExecutionEngine>> services = new ArrayList<IExecutionEngineService<IExecutionEngine>>();
        for (Class<?> type : this.registry.keySet()) {
            if (!clazz.isAssignableFrom(type)) continue;
            services.add(this.registry.get(type));
        }
        return services;
    }

    public Collection<IExecutionEngineService<IExecutionEngine>> getAllServices() {
        return this.registry.values();
    }

    public void clear() {
        this.registry.clear();
    }
}

