/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.simpleclassifiers;

import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IBooleanValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.PrimitiveValue;
import org.eclipse.papyrus.moka.fuml.values.Value;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class BooleanValue
extends PrimitiveValue
implements IBooleanValue {
    public Boolean value;

    @Override
    public ValueSpecification specify() {
        LiteralBoolean literal = UMLFactory.eINSTANCE.createLiteralBoolean();
        literal.setType((Type)this.type);
        literal.setValue(this.value.booleanValue());
        return literal;
    }

    @Override
    public Boolean equals(IValue otherValue) {
        boolean isEqual = false;
        if (otherValue instanceof BooleanValue) {
            isEqual = ((BooleanValue)otherValue).value.equals(this.value);
        }
        return isEqual;
    }

    @Override
    public Value copy() {
        BooleanValue newValue = (BooleanValue)super.copy();
        newValue.value = this.value;
        return newValue;
    }

    @Override
    public Value new_() {
        return new BooleanValue();
    }

    @Override
    public String toString() {
        String stringValue = "false";
        if (this.value.booleanValue()) {
            stringValue = "true";
        }
        return stringValue;
    }

    public Boolean getValue() {
        return this.value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }
}

