/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.UnoRuntime;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertySetUtil;

public class StyleUtil {
    private StyleUtil() {
    }

    public static void applyStyle(XText xText, String propertyName, Object propertyValue) {
        XTextRange xTextRange = xText.getEnd();
        PropertySetUtil.setProperty(xTextRange, propertyName, propertyValue);
    }

    public static void applyStyleLeft(XTextCursor cursor, int cursorStartPosition, String propertyName, Object propertyValue) {
        Object oldPropertyValue = PropertySetUtil.getPropertyValue(cursor, propertyName);
        int cursorCurrentPosition = cursor.getText().getString().length();
        cursor.goLeft((short)(cursorCurrentPosition - cursorStartPosition), true);
        PropertySetUtil.setProperty(cursor, propertyName, propertyValue);
        cursor.goRight((short)(cursorCurrentPosition - cursorStartPosition), false);
        PropertySetUtil.setProperty(cursor, propertyName, oldPropertyValue);
    }

    public static void applyStylePreviousParagraph(XTextCursor cursor, String propertyName, Object propertyValue) {
        Object oldPropertyValue = PropertySetUtil.getPropertyValue(cursor, propertyName);
        XParagraphCursor paragraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)cursor);
        paragraphCursor.gotoPreviousParagraph(true);
        PropertySetUtil.setProperty(paragraphCursor, propertyName, propertyValue);
        paragraphCursor.gotoNextParagraph(false);
        PropertySetUtil.setProperty(cursor, propertyName, oldPropertyValue);
    }

    public static XPropertySet getStylePropertySet(XTextDocument xTextDocument, String familyStyleName, String propertySetName) {
        XNameContainer styleContainer = StyleUtil.getStyleContainer(xTextDocument, familyStyleName);
        if (styleContainer == null) {
            return null;
        }
        XPropertySet stylePropertySet = null;
        try {
            stylePropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)styleContainer.getByName(propertySetName));
        }
        catch (Exception e) {
            Activator.log.error("Could not access style porpetyset " + propertySetName, (Throwable)e);
        }
        return stylePropertySet;
    }

    public static XNameContainer getStyleContainer(XTextDocument xTextDocument, String familyStyleName) {
        try {
            XStyleFamiliesSupplier xSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xTextDocument);
            XNameAccess nameAccess = xSupplier.getStyleFamilies();
            return (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)nameAccess.getByName(familyStyleName));
        }
        catch (Exception e) {
            Activator.log.error("Could not access the family style " + familyStyleName, (Throwable)e);
            return null;
        }
    }
}

