/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.WrapTextMode;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractTable;
import org.eclipse.papyrus.model2doc.core.builtintypes.Cell;
import org.eclipse.papyrus.model2doc.core.builtintypes.FileReferenceCell;
import org.eclipse.papyrus.model2doc.core.builtintypes.TextCell;
import org.eclipse.papyrus.model2doc.core.service.FileIOService;
import org.eclipse.papyrus.model2doc.core.service.FileIOServiceImpl;
import org.eclipse.papyrus.model2doc.core.transcription.ImageDescription;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.editor.ODTEditor;
import org.eclipse.papyrus.model2doc.odt.internal.util.ImageUtil;
import org.eclipse.papyrus.model2doc.odt.internal.util.ParagraphImageWriter;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertySetUtil;
import org.eclipse.papyrus.model2doc.odt.service.ODTFileIOService;
import org.eclipse.papyrus.model2doc.odt.service.ODTFileIOServiceImpl;

public class WriteUtil {
    private static final String HTML_TAG_REGEX = "<[^<>]+>";
    private static final String HTML_EXTENSION = "html";
    private static final FileIOService fileIOService = new FileIOServiceImpl();
    private static final ODTFileIOService odtFileIOService = new ODTFileIOServiceImpl();

    private WriteUtil() {
    }

    public static void addParagraph(XTextCursor xTextCursor, String text, boolean processRichText) {
        WriteUtil.addParagraph(xTextCursor, text, processRichText, true);
    }

    public static void addParagraph(XTextCursor xTextCursor, String text, boolean processRichText, boolean endParagraph) {
        if (processRichText) {
            WriteUtil.addParagraphWithRichText(xTextCursor, text);
        } else {
            WriteUtil.addText(xTextCursor, text);
            if (endParagraph) {
                WriteUtil.endParagraph(xTextCursor);
            }
        }
    }

    public static void addControlCharacter(XTextCursor xTextCursor, short controlCharacter) {
        XText xText = xTextCursor.getText();
        xText.insertControlCharacter((XTextRange)xTextCursor, controlCharacter, false);
        xTextCursor.gotoEnd(false);
    }

    public static void addText(XTextCursor xTextCursor, String text) {
        xTextCursor.setString(text);
        xTextCursor.gotoEnd(false);
    }

    public static void addTextContent(XTextCursor xTextCursor, XTextContent xTextContent) {
        XText xText = xTextCursor.getText();
        xText.insertTextContent((XTextRange)xTextCursor, xTextContent, false);
        xTextCursor.gotoEnd(false);
    }

    public static void addImageLink(String imageFilePath, String caption, XTextCursor xTextCursor, ODTEditor odtEditor) {
        ParagraphImageWriter writer = new ParagraphImageWriter(odtEditor);
        writer.writeImage(xTextCursor, imageFilePath, caption);
    }

    public static void addImageLink(ImageDescription image, String caption, XTextCursor xTextCursor, ODTEditor odtEditor) {
        String imageFilePath = String.valueOf(odtFileIOService.getODTFilePrefix()) + image.getPath();
        try {
            XMultiServiceFactory xMultiServiceFactory = odtEditor.getXMultiServiceFactory();
            Object tmp = xMultiServiceFactory.createInstance("com.sun.star.text.TextFrame");
            XTextFrame textFrame = (XTextFrame)UnoRuntime.queryInterface(XTextFrame.class, (Object)tmp);
            XPropertySet framePropertySet = WriteUtil.createXPropertySet(textFrame);
            framePropertySet.setPropertyValue("SizeType", (Object)0);
            framePropertySet.setPropertyValue("AnchorType", (Object)TextContentAnchorType.AS_CHARACTER);
            framePropertySet.setPropertyValue("ZOrder", (Object)1);
            framePropertySet.setPropertyValue("TextWrap", (Object)WrapTextMode.THROUGH);
            framePropertySet.setPropertyValue("LeftBorderDistance", (Object)0);
            framePropertySet.setPropertyValue("RightBorderDistance", (Object)0);
            framePropertySet.setPropertyValue("TopBorderDistance", (Object)0);
            framePropertySet.setPropertyValue("BottomBorderDistance", (Object)0);
            Object graphicObject = xMultiServiceFactory.createInstance("com.sun.star.text.TextGraphicObject");
            XTextContent graphicContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)graphicObject);
            XNameContainer bitmapContainer = odtEditor.getBitmapTable(imageFilePath);
            PropertySetUtil.setProperty(graphicContent, "AnchorType", TextContentAnchorType.AT_CHARACTER);
            if (bitmapContainer != null) {
                PropertySetUtil.setProperty(graphicContent, "GraphicURL", bitmapContainer.getByName(imageFilePath));
            }
            graphicContent = ImageUtil.resizeImage(graphicContent, imageFilePath, odtEditor.getXTextDocument(), odtEditor.getXMultiComponentFactory(), odtEditor.getXComponentContext());
            XPropertySet graphicPropSet = WriteUtil.createXPropertySet(graphicContent);
            Object heightValue = graphicPropSet.getPropertyValue("Height");
            Object widthValue = graphicPropSet.getPropertyValue("Width");
            XPropertySet textFrameSet = WriteUtil.createXPropertySet(textFrame);
            textFrameSet.setPropertyValue("Height", heightValue);
            textFrameSet.setPropertyValue("Width", widthValue);
            xTextCursor.getText().insertTextContent((XTextRange)xTextCursor, (XTextContent)textFrame, false);
            XTextCursor localCursor = textFrame.getText().createTextCursor();
            XParagraphCursor paragraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)localCursor);
            XPropertySet paraSet = WriteUtil.createXPropertySet(paragraphCursor);
            paraSet.setPropertyValue("ParaStyleName", (Object)"Illustration");
            localCursor.getText().insertTextContent((XTextRange)localCursor, graphicContent, false);
            localCursor.gotoEnd(true);
            localCursor.getText().insertString((XTextRange)localCursor, "Illustration", false);
            if (caption != null && !caption.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append(": ");
                builder.append(caption);
                localCursor.getText().insertString((XTextRange)localCursor, builder.toString(), false);
            }
            WriteUtil.endParagraph(xTextCursor);
            fileIOService.removeFile(new File(image.getPath()));
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    private static final XPropertySet createXPropertySet(Object object) {
        return (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
    }

    public static void endLine(XTextCursor xTextCursor) {
        WriteUtil.addControlCharacter(xTextCursor, (short)1);
    }

    public static void endParagraph(XTextCursor xTextCursor) {
        WriteUtil.addControlCharacter(xTextCursor, (short)0);
    }

    public static void insertTextFile(XTextCursor xTextCursor, String fileURL) {
        xTextCursor.gotoEnd(false);
        XDocumentInsertable inserter = (XDocumentInsertable)UnoRuntime.queryInterface(XDocumentInsertable.class, (Object)xTextCursor);
        if (inserter != null) {
            try {
                inserter.insertDocumentFromURL(fileURL, new PropertyValue[0]);
            }
            catch (IOException | IllegalArgumentException e) {
                Activator.log.error(e);
            }
        }
    }

    public static String removeHTMLTags(String text) {
        return text.replaceAll(HTML_TAG_REGEX, "");
    }

    public static void addParagraphWithRichText(XTextCursor xTextCursor, String text) {
        String[] noRichText = text.split(HTML_TAG_REGEX, 2);
        String richText = text;
        if (noRichText.length != 0) {
            WriteUtil.addText(xTextCursor, noRichText[0]);
            richText = text.replaceFirst(noRichText[0], "");
        }
        richText = richText.replaceAll("&nbsp;", " ");
        String location = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        StringBuilder pathName = new StringBuilder();
        pathName.append(location);
        pathName.append(File.separator);
        pathName.append("tmp_ParagraphWithRichText_");
        pathName.append(new Date().getTime());
        pathName.append(".");
        pathName.append(HTML_EXTENSION);
        File file = fileIOService.createFile(pathName.toString(), richText);
        String fileURL = odtFileIOService.getFileURL(file);
        WriteUtil.insertTextFile(xTextCursor, fileURL);
        fileIOService.removeFile(file);
        WriteUtil.endParagraph(xTextCursor);
    }

    public static void writeTable(XTextCursor xTextCursor, AbstractTable table, ODTEditor odtEditor) {
        int rowsNumber = table.getRowsNumber();
        int colNumbers = table.getColumnsNumber();
        if (rowsNumber <= 0 || colNumbers <= 0) {
            return;
        }
        EList allCells = table.getAllCells();
        int totalCells = allCells.size();
        if (rowsNumber * colNumbers != totalCells) {
            Activator.log.warn(NLS.bind((String)"The number of cells in the table is not as excepted. We won't manage the table {0}.", (Object)table.getCaption()));
            return;
        }
        try {
            XMultiServiceFactory xMultiServiceFactory = odtEditor.getXMultiServiceFactory();
            Object obj = xMultiServiceFactory.createInstance("com.sun.star.text.TextTable");
            XTextTable textTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)obj);
            textTable.initialize(rowsNumber, colNumbers);
            WriteUtil.addTextContent(xTextCursor, (XTextContent)textTable);
            List<String> cellNames = Arrays.asList(textTable.getCellNames());
            if (cellNames.size() != allCells.size()) {
                Activator.log.warn(NLS.bind((String)"--The number of LibreOffice cells is {0} instead of {1}, as required", (Object)cellNames.size(), (Object)allCells.size()));
            }
            Integer headerBackGroundColor = 0xD4D4D4;
            Iterator<String> libreOfficeCellNamesIter = cellNames.iterator();
            Iterator tableCellIterator = allCells.iterator();
            while (libreOfficeCellNamesIter.hasNext() && tableCellIterator.hasNext()) {
                XText cellText = (XText)UnoRuntime.queryInterface(XText.class, (Object)textTable.getCellByName(libreOfficeCellNamesIter.next()));
                Cell cell = (Cell)tableCellIterator.next();
                if (cell instanceof TextCell) {
                    cellText.setString(((TextCell)cell).getText());
                } else if (cell instanceof FileReferenceCell) {
                    XTextCursor cursor = cellText.createTextCursor();
                    URL url = ((FileReferenceCell)cell).getFileReference().getFileAccessor().createInputFileURL();
                    WriteUtil.insertTextFile(cursor, url.toString());
                } else {
                    Activator.log.warn(NLS.bind((String)"--The cell eClass {0} is not managed by the transcription", (Object)cell.eClass().getName()));
                }
                switch (cell.getLocation()) {
                    case CORNER: 
                    case COLUMN_HEADER: 
                    case ROW_HEADER: {
                        PropertySetUtil.setProperty(cellText, "BackColor", headerBackGroundColor);
                    }
                }
            }
        }
        catch (com.sun.star.uno.Exception e) {
            Activator.log.error((Throwable)e);
        }
    }
}

