/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.svgextension.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IExpandableFigure;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramSVGGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.util.DiagramImageUtils;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.uml.export.Activator;
import org.eclipse.papyrus.uml.export.svgextension.internal.OpenRenderedMapModeGraphics;
import org.eclipse.swt.graphics.ImageData;

public class OpenAPIDiagramSVGGenerator
extends DiagramSVGGenerator {
    private Point ltranslateOffset;

    public OpenAPIDiagramSVGGenerator(DiagramEditPart diagramEditPart) {
        super(diagramEditPart);
    }

    public ImageDescriptor openCreateSWTImageDescriptorForParts(List editparts, org.eclipse.swt.graphics.Rectangle sourceRect) {
        ImageDescriptor imageDesc = new ImageDescriptor(){

            public ImageData getImageData() {
                return SharedImages.get((String)"icons/error.gif").getImageData();
            }
        };
        Graphics graphics = null;
        try {
            IMapMode mm = this.getMapMode();
            PrecisionRectangle rect = new PrecisionRectangle();
            rect.setX(sourceRect.x);
            rect.setY(sourceRect.y);
            rect.setWidth(sourceRect.width);
            rect.setHeight(sourceRect.height);
            mm.LPtoDP((Translatable)rect);
            graphics = this.setUpGraphics((int)Math.round(rect.preciseWidth), (int)Math.round(rect.preciseHeight));
            OpenRenderedMapModeGraphics mapModeGraphics = new OpenRenderedMapModeGraphics(graphics, this.getMapMode());
            this.openRenderToGraphics((Graphics)mapModeGraphics, new Point(sourceRect.x, sourceRect.y), editparts);
            imageDesc = this.getImageDescriptor(graphics);
        }
        catch (Throwable throwable) {
            if (graphics != null) {
                this.disposeGraphics(graphics);
            }
            throw throwable;
        }
        if (graphics != null) {
            this.disposeGraphics(graphics);
        }
        return imageDesc;
    }

    public void openRenderToGraphics(Graphics graphics, Point translateOffset, List editparts) {
        this.ltranslateOffset = translateOffset;
        graphics.translate(-translateOffset.x, -translateOffset.y);
        graphics.pushState();
        LinkedList<Object> connectionsToPaint = new LinkedList<Object>();
        Map decorations = this.findDecorations(editparts);
        ListIterator editPartsItr = editparts.listIterator();
        while (editPartsItr.hasNext()) {
            IGraphicalEditPart editPart = (IGraphicalEditPart)editPartsItr.next();
            if (editPart instanceof ConnectionEditPart) {
                connectionsToPaint.add(editPart);
                continue;
            }
            connectionsToPaint.addAll(this.findConnectionsToPaint(editPart));
            IFigure figure = editPart.getFigure();
            this.paintFigure(graphics, figure, editPart);
            this.paintDecorations(graphics, figure, decorations);
        }
        decorations = this.findDecorations(connectionsToPaint);
        Iterator connItr = connectionsToPaint.iterator();
        while (connItr.hasNext()) {
            IFigure figure = ((GraphicalEditPart)connItr.next()).getFigure();
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
        }
    }

    public IFigure getPrintableLayer() {
        try {
            Field f = ((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getSuperclass().getDeclaredField("printableLayer");
            f.setAccessible(true);
            return (IFigure)f.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Activator.log(e);
            return null;
        }
    }

    public Collection<ConnectionEditPart> findConnectionsToPaint(IGraphicalEditPart editPart) {
        HashSet editParts = new HashSet();
        HashSet<ConnectionEditPart> connectionEPs = new HashSet<ConnectionEditPart>();
        HashSet<ConnectionEditPart> connectionsToPaint = new HashSet<ConnectionEditPart>();
        this.getNestedEditParts(editPart, editParts);
        Iterator editPartsItr = editParts.iterator();
        while (editPartsItr.hasNext()) {
            connectionEPs.addAll(this.getAllConnectionsFrom((GraphicalEditPart)editPartsItr.next()));
        }
        while (!connectionEPs.isEmpty()) {
            Stack<ConnectionEditPart> connectionsPath = new Stack<ConnectionEditPart>();
            ConnectionEditPart conn = (ConnectionEditPart)connectionEPs.iterator().next();
            connectionEPs.remove(conn);
            connectionsPath.add(conn);
            EditPart target = conn.getTarget();
            while (connectionEPs.contains(target)) {
                ConnectionEditPart targetConn = (ConnectionEditPart)target;
                connectionEPs.remove(targetConn);
                connectionsPath.add(targetConn);
                target = targetConn.getTarget();
            }
            if (!editParts.contains(target) && !connectionsToPaint.contains(target)) continue;
            connectionsToPaint.addAll(connectionsPath);
        }
        return connectionsToPaint;
    }

    public void paintFigure(Graphics graphics, IFigure figure) {
        if (!figure.isVisible() || figure.getBounds().isEmpty()) {
            return;
        }
        Rectangle relBounds = null;
        relBounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds().getCopy() : figure.getBounds().getCopy();
        Rectangle abBounds = relBounds.getCopy();
        DiagramImageUtils.translateTo((Translatable)abBounds, (IFigure)figure, (IFigure)this.getPrintableLayer());
        int transX = abBounds.x - relBounds.x;
        int transY = abBounds.y - relBounds.y;
        graphics.pushState();
        graphics.translate(transX, transY);
        figure.paint(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    public void paintFigure(Graphics graphics, IFigure figure, IGraphicalEditPart editPart) {
        if (!figure.isVisible() || figure.getBounds().isEmpty()) {
            return;
        }
        Rectangle relBounds = null;
        relBounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds().getCopy() : figure.getBounds().getCopy();
        Rectangle abBounds = relBounds.getCopy();
        DiagramImageUtils.translateTo((Translatable)abBounds, (IFigure)figure, (IFigure)this.getPrintableLayer());
        int transX = abBounds.x - relBounds.x;
        int transY = abBounds.y - relBounds.y;
        graphics.pushState();
        graphics.translate(transX, transY);
        figure.paint(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    public Map findDecorations(Collection editparts) {
        IGraphicalEditPart first;
        IFigure decorationLayer;
        Map figureMap = this.mapFiguresToEditParts(editparts);
        HashMap<IFigure, Object> result = new HashMap<IFigure, Object>();
        if (!editparts.isEmpty() && (decorationLayer = LayerManager.Helper.find((EditPart)(first = (IGraphicalEditPart)editparts.iterator().next())).getLayer((Object)"Decoration Printable Layer")) != null) {
            ArrayList figures = new ArrayList(editparts);
            Iterator iter = figures.listIterator();
            while (iter.hasNext()) {
                iter.set(((IGraphicalEditPart)iter.next()).getFigure());
            }
            block1: for (Object next : decorationLayer.getChildren()) {
                if (!(next instanceof Decoration)) continue;
                Decoration decoration = (Decoration)next;
                IFigure owner = decoration.getOwnerFigure();
                while (owner != null) {
                    if (figureMap.containsKey(owner)) {
                        Object existing = result.get(owner);
                        if (existing == null) {
                            result.put(owner, decoration);
                            continue block1;
                        }
                        if (existing instanceof Collection) {
                            ((Collection)existing).add(decoration);
                            continue block1;
                        }
                        ArrayList<Object> c = new ArrayList<Object>(2);
                        c.add(existing);
                        c.add(decoration);
                        result.put(owner, c);
                        continue block1;
                    }
                    owner = owner.getParent();
                }
            }
        }
        return result;
    }

    public Map mapFiguresToEditParts(Collection editParts) {
        HashMap<IFigure, IGraphicalEditPart> result = new HashMap<IFigure, IGraphicalEditPart>();
        for (IGraphicalEditPart next : editParts) {
            result.put(next.getFigure(), next);
        }
        return result;
    }

    public void getNestedEditParts(IGraphicalEditPart childEditPart, Collection editParts) {
        for (IGraphicalEditPart child : childEditPart.getChildren()) {
            editParts.add(child);
            this.getNestedEditParts(child, editParts);
        }
    }

    public void paintDecorations(Graphics graphics, IFigure figure, Map decorations) {
        Object decoration = decorations.get(figure);
        if (decoration != null) {
            if (decoration instanceof Collection) {
                Iterator iter = ((Collection)decoration).iterator();
                while (iter.hasNext()) {
                    this.paintFigure(graphics, (IFigure)iter.next());
                }
            } else {
                this.paintFigure(graphics, (IFigure)decoration);
            }
        }
    }

    public List<ConnectionEditPart> getAllConnectionsFrom(GraphicalEditPart ep) {
        LinkedList<ConnectionEditPart> connections = new LinkedList<ConnectionEditPart>();
        for (ConnectionEditPart sourceConn : ep.getSourceConnections()) {
            connections.add(sourceConn);
            connections.addAll(this.getAllConnectionsFrom((GraphicalEditPart)sourceConn));
        }
        return connections;
    }
}

