/**
 * Copyright (c) 2007, 2014, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Artem Tikhomirov (Borland) - refactored javaInitilizers not to use methods from GMFGen model
 * 								[221347] Got rid of generated interfaces
 * 								(IObjectInitializer, IFeatureInitializer) and implementation thereof
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Christian W. Damus (CEA) - bug 440263
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up providers + missing nonNLS
 */
package xpt.providers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenElementInitializer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureInitializer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureSeqInitializer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenReferenceNewElementSpec;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import plugin.Activator;
import xpt.Common;
import xpt.Common_qvto;
import xpt.expressions.ExpressionAbstractExpression;
import xpt.expressions.getExpression;

/**
 * XXX should generate this class only when there is initialization logic defined in the model
 */
@Singleton
@SuppressWarnings("all")
public class ElementInitializers {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private ElementInitializers_qvto _elementInitializers_qvto;

  @Inject
  private Activator xptActivator;

  @Inject
  private ExpressionAbstractExpression xptAbstractExpression;

  @Inject
  private MetaModel xptMetaModel;

  @Inject
  private getExpression xptGetExpression;

  @MetaDef
  public CharSequence initMethodCall(final GenCommonBase linkOrNode, final TypeModelFacet modelFacet, final String newElementVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenElementInitializer _modelElementInitializer = modelFacet.getModelElementInitializer();
      boolean _tripleNotEquals = (_modelElementInitializer != null);
      if (_tripleNotEquals) {
        CharSequence _elementInitializersInstanceCall = this.elementInitializersInstanceCall(linkOrNode);
        _builder.append(_elementInitializersInstanceCall);
        _builder.append(".init_");
        String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(linkOrNode);
        _builder.append(_stringUniqueIdentifier);
        _builder.append("(");
        _builder.append(newElementVar);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  @MetaDef
  protected CharSequence elementInitializersInstanceCall(final GenCommonBase base) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(base.getDiagram());
    _builder.append(_qualifiedClassName);
    _builder.append(".getInstance()");
    return _builder;
  }

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _elementInitializersClassName = it.getElementInitializersClassName();
    _builder.append(_elementInitializersClassName);
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _elementInitializersPackageName = it.getElementInitializersPackageName();
    _builder.append(_elementInitializersPackageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence ElementInitializers(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// use #getInstance to access cached instance");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _Initializers = this.Initializers(it);
    _builder.append(_Initializers, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _JavaSupport = this.JavaSupport(it);
    _builder.append(_JavaSupport, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static ");
    CharSequence _className_2 = this.className(it);
    _builder.append(_className_2, "\t");
    _builder.append(" getInstance() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _className_3 = this.className(it);
    _builder.append(_className_3, "\t\t");
    _builder.append(" cached = ");
    CharSequence _instanceAccess = this.xptActivator.instanceAccess(it.getEditorGen());
    _builder.append(_instanceAccess, "\t\t");
    _builder.append(".getElementInitializers();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (cached == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _instanceAccess_1 = this.xptActivator.instanceAccess(it.getEditorGen());
    _builder.append(_instanceAccess_1, "\t\t\t");
    _builder.append(".setElementInitializers(cached = new ");
    CharSequence _className_4 = this.className(it);
    _builder.append(_className_4, "\t\t\t");
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return cached;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence Initializers(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenNode> _allNodes = it.getAllNodes();
      for(final GenNode next : _allNodes) {
        CharSequence _initMethod = this.initMethod(next);
        _builder.append(_initMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenLink> _links = it.getLinks();
      for(final GenLink next_1 : _links) {
        CharSequence _initMethod_1 = this.initMethod(next_1);
        _builder.append(_initMethod_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence JavaSupport(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((it.getEditorGen().getExpressionProviders() != null) && 
        this._common_qvto.<GenJavaExpressionProvider>notEmpty(Iterables.<GenJavaExpressionProvider>filter(it.getEditorGen().getExpressionProviders().getProviders(), GenJavaExpressionProvider.class)))) {
        {
          EList<GenNode> _allNodes = it.getAllNodes();
          for(final GenNode next : _allNodes) {
            CharSequence _javaMethod = this.javaMethod(next);
            _builder.append(_javaMethod);
            _builder.newLineIfNotEmpty();
          }
        }
        {
          EList<GenLink> _links = it.getLinks();
          for(final GenLink next_1 : _links) {
            CharSequence _javaMethod_1 = this.javaMethod(next_1);
            _builder.append(_javaMethod_1);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _initMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      TypeModelFacet _modelFacet = it.getModelFacet();
      boolean _tripleNotEquals = (_modelFacet != null);
      if (_tripleNotEquals) {
        CharSequence _initMethod = this.initMethod(it.getModelFacet(), it);
        _builder.append(_initMethod);
      }
    }
    return _builder;
  }

  protected CharSequence _initMethod(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      LinkModelFacet _modelFacet = it.getModelFacet();
      boolean _tripleNotEquals = (_modelFacet != null);
      if (_tripleNotEquals) {
        CharSequence _initMethod = this.initMethod(it.getModelFacet(), it);
        _builder.append(_initMethod);
      }
    }
    return _builder;
  }

  protected CharSequence _initMethod(final ModelFacet it, final GenCommonBase diagramElement) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _initMethod(final TypeModelFacet it, final GenCommonBase diagramElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenElementInitializer _modelElementInitializer = it.getModelElementInitializer();
      boolean _tripleNotEquals = (_modelElementInitializer != null);
      if (_tripleNotEquals) {
        CharSequence _initMethod = this.initMethod(it.getModelElementInitializer(), diagramElement);
        _builder.append(_initMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _initMethod(final GenElementInitializer it, final GenCommonBase diagramElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((it != null) && (it.getTypeModelFacet() != null))) {
        this._common_qvto.ERROR(("No idea how to init using " + it));
      }
    }
    return _builder;
  }

  protected CharSequence _initMethod(final GenFeatureSeqInitializer it, final GenCommonBase diagramElement) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void init_");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(diagramElement);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("(");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getElementClass());
    _builder.append(_QualifiedClassName);
    _builder.append(" instance) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    {
      EList<GenFeatureInitializer> _initializers = it.getInitializers();
      for(final GenFeatureInitializer i : _initializers) {
        _builder.append("\t\t");
        CharSequence _performInit = this.performInit(i, diagramElement, "instance", it.getElementClass(), CollectionLiterals.<Integer>newLinkedList(Integer.valueOf(it.getInitializers().indexOf(i))));
        _builder.append(_performInit, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("} catch(RuntimeException e) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(diagramElement.getDiagram().getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getInstance().logError(\"Element initialization failed\", e); //$NON-NLS-1$");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _performInit(final GenFeatureInitializer it, final GenCommonBase diagramElement, final String instanceVar, final GenClass instanceClass, final List<Integer> counters) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  /**
   * FIXME: need cleaner appoach to provider's language switch (not to mix if == literal and polymorphism)
   */
  protected CharSequence _performInit(final GenFeatureValueSpec it, final GenCommonBase diagramElement, final String instanceVar, final GenClass instanceClass, final List<Integer> counters) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenLanguage _language = it.getValue().getProvider().getLanguage();
      boolean _equals = Objects.equals(_language, GenLanguage.LITERAL_LITERAL);
      if (_equals) {
        CharSequence _modifyFeature = this.xptMetaModel.modifyFeature(it.getFeature(), instanceVar, instanceClass, it.getValue().getBody());
        _builder.append(_modifyFeature);
        _builder.newLineIfNotEmpty();
      } else {
        String expressionVarName = this._elementInitializers_qvto.getVariableName("value", counters);
        _builder.newLineIfNotEmpty();
        _builder.append("Object ");
        _builder.append(expressionVarName);
        _builder.append(" = ");
        CharSequence _evaluateExpr = this.evaluateExpr(it.getValue().getProvider(), diagramElement, it, instanceVar);
        _builder.append(_evaluateExpr);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        {
          boolean _isListType = it.getFeature().isListType();
          if (_isListType) {
            _builder.append("if (");
            _builder.append(expressionVarName);
            _builder.append(" instanceof java.util.Collection) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it.getFeature(), instanceVar, instanceClass, true);
            _builder.append(_featureValue, "\t");
            _builder.append(".clear();");
            _builder.newLineIfNotEmpty();
            {
              boolean _expressionResultNeedsCast = this._elementInitializers_qvto.expressionResultNeedsCast(it.getFeature().getTypeGenClassifier());
              if (_expressionResultNeedsCast) {
                _builder.append("for (java.util.Iterator it = ((java.util.Collection) ");
                _builder.append(expressionVarName);
                _builder.append(").iterator(); it.hasNext(); ) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("Object next = ");
                CharSequence _qualifiedClassName = this.xptAbstractExpression.qualifiedClassName(diagramElement.getDiagram());
                _builder.append(_qualifiedClassName, "\t");
                _builder.append(".performCast(it.next(), ");
                CharSequence _MetaClass = this.xptMetaModel.MetaClass(it.getFeature().getTypeGenClassifier());
                _builder.append(_MetaClass, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _featureValue_1 = this.xptMetaModel.getFeatureValue(it.getFeature(), instanceVar, instanceClass, true);
                _builder.append(_featureValue_1, "\t");
                _builder.append(".add((");
                CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getFeature().getTypeGenClassifier());
                _builder.append(_QualifiedClassName, "\t");
                _builder.append(") next);");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
              } else {
                CharSequence _featureValue_2 = this.xptMetaModel.getFeatureValue(it.getFeature(), instanceVar, instanceClass, true);
                _builder.append(_featureValue_2);
                _builder.append(".addAll(((java.util.Collection) ");
                _builder.append(expressionVarName);
                _builder.append("));");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("} else if(");
            _builder.append(expressionVarName);
            _builder.append(" != null) {");
            _builder.newLineIfNotEmpty();
            {
              boolean _expressionResultNeedsCast_1 = this._elementInitializers_qvto.expressionResultNeedsCast(it.getFeature().getTypeGenClassifier());
              if (_expressionResultNeedsCast_1) {
                _builder.append(expressionVarName);
                _builder.append(" = ");
                CharSequence _qualifiedClassName_1 = this.xptAbstractExpression.qualifiedClassName(diagramElement.getDiagram());
                _builder.append(_qualifiedClassName_1);
                _builder.append(".performCast(");
                _builder.append(expressionVarName);
                _builder.append(", ");
                CharSequence _MetaClass_1 = this.xptMetaModel.MetaClass(it.getFeature().getTypeGenClassifier());
                _builder.append(_MetaClass_1);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
            CharSequence _featureValue_3 = this.xptMetaModel.getFeatureValue(it.getFeature(), instanceVar, instanceClass, true);
            _builder.append(_featureValue_3);
            _builder.append(".add((");
            CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName(it.getFeature().getTypeGenClassifier());
            _builder.append(_QualifiedClassName_1);
            _builder.append(") ");
            _builder.append(expressionVarName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
          } else {
            _builder.append("if(");
            _builder.append(expressionVarName);
            _builder.append(" != null) {");
            _builder.newLineIfNotEmpty();
            {
              boolean _expressionResultNeedsCast_2 = this._elementInitializers_qvto.expressionResultNeedsCast(it.getFeature().getTypeGenClassifier());
              if (_expressionResultNeedsCast_2) {
                _builder.append(expressionVarName);
                _builder.append(" = ");
                CharSequence _qualifiedClassName_2 = this.xptAbstractExpression.qualifiedClassName(diagramElement.getDiagram());
                _builder.append(_qualifiedClassName_2);
                _builder.append(".performCast(");
                _builder.append(expressionVarName);
                _builder.append(", ");
                CharSequence _MetaClass_2 = this.xptMetaModel.MetaClass(it.getFeature().getTypeGenClassifier());
                _builder.append(_MetaClass_2);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
            CharSequence _setFeatureValue = this.xptMetaModel.setFeatureValue(it.getFeature(), instanceVar, instanceClass, expressionVarName, true);
            _builder.append(_setFeatureValue);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _performInit(final GenReferenceNewElementSpec it, final GenCommonBase diagramElement, final String instanceVar, final GenClass instanceClass, final List<Integer> counters) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenFeatureSeqInitializer> _newElementInitializers = it.getNewElementInitializers();
      for(final GenFeatureSeqInitializer newElemInit : _newElementInitializers) {
        List<Integer> initializerCounters = this._elementInitializers_qvto.newListAppending(counters, it.getNewElementInitializers().indexOf(newElemInit));
        _builder.newLineIfNotEmpty();
        String newInstanceVar = this._elementInitializers_qvto.getVariableName("newInstance", initializerCounters);
        _builder.newLineIfNotEmpty();
        CharSequence _NewInstance = this.xptMetaModel.NewInstance(newElemInit.getElementClass(), newInstanceVar);
        _builder.append(_NewInstance);
        _builder.newLineIfNotEmpty();
        CharSequence _modifyFeature = this.xptMetaModel.modifyFeature(it.getFeature(), instanceVar, instanceClass, newInstanceVar);
        _builder.append(_modifyFeature);
        _builder.newLineIfNotEmpty();
        {
          EList<GenFeatureInitializer> _initializers = newElemInit.getInitializers();
          for(final GenFeatureInitializer i : _initializers) {
            CharSequence _performInit = this.performInit(i, diagramElement, newInstanceVar, newElemInit.getElementClass(), this._elementInitializers_qvto.newListAppending(initializerCounters, newElemInit.getInitializers().indexOf(i)));
            _builder.append(_performInit);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _evaluateExpr(final GenExpressionProviderBase it, final GenCommonBase diagramElement, final GenFeatureValueSpec valueExpr, final String instanceVar) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _evaluateExpr(final GenExpressionInterpreter it, final GenCommonBase diagramElement, final GenFeatureValueSpec valueExpr, final String instanceVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _expression = this.xptGetExpression.getExpression(it, valueExpr.getValue(), valueExpr.getFeatureSeqInitializer().getElementClass());
    _builder.append(_expression);
    _builder.append(".evaluate(");
    _builder.append(instanceVar);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * XXX revisit: if emf java merge doesn't support genereated NOT methods with modified
   * return type, there's no much sense to keep Object value = invokeJavaMethodWithSpecificReturnType, * as client won't benefit from such code (he can't modify return type and thus would get duplicated methods on regeneration)
   * However, if merge does ignore method return type when merging, allowing Object as return type may help.
   */
  protected CharSequence _evaluateExpr(final GenJavaExpressionProvider it, final GenCommonBase diagramElement, final GenFeatureValueSpec valueExpr, final String instanceVar) {
    StringConcatenation _builder = new StringConcatenation();
    String _javaMethodName = this._elementInitializers_qvto.javaMethodName(diagramElement, valueExpr);
    _builder.append(_javaMethodName);
    _builder.append("(");
    _builder.append(instanceVar);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _javaMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isSansDomain = it.isSansDomain();
      boolean _not = (!_isSansDomain);
      if (_not) {
        CharSequence _javaMethod = this.javaMethod(it.getModelFacet(), it);
        _builder.append(_javaMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _javaMethod(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isSansDomain = it.isSansDomain();
      boolean _not = (!_isSansDomain);
      if (_not) {
        CharSequence _javaMethod = this.javaMethod(it.getModelFacet(), it);
        _builder.append(_javaMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _javaMethod(final ModelFacet it, final GenCommonBase diagramElement) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _javaMethod(final TypeModelFacet it, final GenCommonBase diagramElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenElementInitializer _modelElementInitializer = it.getModelElementInitializer();
      boolean _tripleNotEquals = (_modelElementInitializer != null);
      if (_tripleNotEquals) {
        CharSequence _javaMethod = this.javaMethod(it.getModelElementInitializer(), diagramElement);
        _builder.append(_javaMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _javaMethod(final GenElementInitializer it, final GenCommonBase diagramElement) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(((("No idea how to handle " + it) + " for ") + diagramElement));
    return _builder;
  }

  protected CharSequence _javaMethod(final GenFeatureSeqInitializer it, final GenCommonBase diagramElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<GenFeatureValueSpec> _recurseCollectValueSpec = this._elementInitializers_qvto.recurseCollectValueSpec(it);
      for(final GenFeatureValueSpec vs : _recurseCollectValueSpec) {
        CharSequence _javaMethod = this.javaMethod(vs.getValue().getProvider(), diagramElement, vs);
        _builder.append(_javaMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _javaMethod(final GenExpressionProviderBase it, final GenCommonBase diagramElement, final GenFeatureValueSpec vs) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _javaMethod(final GenJavaExpressionProvider it, final GenCommonBase diagramElement, final GenFeatureValueSpec vs) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private ");
    CharSequence _featureTargetType = this.xptMetaModel.featureTargetType(vs.getFeature());
    _builder.append(_featureTargetType);
    _builder.append(" ");
    String _javaMethodName = this._elementInitializers_qvto.javaMethodName(diagramElement, vs);
    _builder.append(_javaMethodName);
    _builder.append("(");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(vs.getFeatureSeqInitializer().getElementClass());
    _builder.append(_QualifiedClassName);
    _builder.append(" it) {");
    _builder.newLineIfNotEmpty();
    {
      if ((it.isInjectExpressionBody() && (!StringExtensions.isNullOrEmpty(vs.getValue().getBody())))) {
        String body = vs.getValue().getBody();
        {
          List<String> _collect = body.lines().collect(Collectors.<String>toList());
          boolean _hasElements = false;
          for(final String line : _collect) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate("\n", "");
            }
            _builder.append(line);
            _builder.append(" ");
            CharSequence _nonNLS = this._common.nonNLS(line);
            _builder.append(_nonNLS);
          }
        }
        _builder.newLineIfNotEmpty();
      } else {
        if ((it.isThrowException() || (it.isInjectExpressionBody() && StringExtensions.isNullOrEmpty(vs.getValue().getBody())))) {
          _builder.append("// TODO: implement this method to return value");
          _builder.newLine();
          _builder.append("// for ");
          CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(vs.getFeature());
          _builder.append(_MetaFeature);
          _builder.newLineIfNotEmpty();
          _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
          _builder.newLine();
          _builder.append("throw new java.lang.UnsupportedOperationException(\"No user java implementation provided in \'");
          String _javaMethodName_1 = this._elementInitializers_qvto.javaMethodName(diagramElement, vs);
          _builder.append(_javaMethodName_1);
          _builder.append("\' operation\"); ");
          CharSequence _nonNLS_1 = this._common.nonNLS(1);
          _builder.append(_nonNLS_1);
          _builder.newLineIfNotEmpty();
        } else {
          _builder.append("return null;");
          _builder.newLine();
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence initMethod(final GenLinkEnd it) {
    if (it instanceof GenNode) {
      return _initMethod((GenNode)it);
    } else if (it instanceof GenLink) {
      return _initMethod((GenLink)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence initMethod(final EObject it, final GenCommonBase diagramElement) {
    if (it instanceof GenFeatureSeqInitializer) {
      return _initMethod((GenFeatureSeqInitializer)it, diagramElement);
    } else if (it instanceof TypeModelFacet) {
      return _initMethod((TypeModelFacet)it, diagramElement);
    } else if (it instanceof GenElementInitializer) {
      return _initMethod((GenElementInitializer)it, diagramElement);
    } else if (it instanceof ModelFacet) {
      return _initMethod((ModelFacet)it, diagramElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, diagramElement).toString());
    }
  }

  public CharSequence performInit(final GenFeatureInitializer it, final GenCommonBase diagramElement, final String instanceVar, final GenClass instanceClass, final List<Integer> counters) {
    if (it instanceof GenFeatureValueSpec) {
      return _performInit((GenFeatureValueSpec)it, diagramElement, instanceVar, instanceClass, counters);
    } else if (it instanceof GenReferenceNewElementSpec) {
      return _performInit((GenReferenceNewElementSpec)it, diagramElement, instanceVar, instanceClass, counters);
    } else if (it != null) {
      return _performInit(it, diagramElement, instanceVar, instanceClass, counters);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, diagramElement, instanceVar, instanceClass, counters).toString());
    }
  }

  public CharSequence evaluateExpr(final GenExpressionProviderBase it, final GenCommonBase diagramElement, final GenFeatureValueSpec valueExpr, final String instanceVar) {
    if (it instanceof GenExpressionInterpreter) {
      return _evaluateExpr((GenExpressionInterpreter)it, diagramElement, valueExpr, instanceVar);
    } else if (it instanceof GenJavaExpressionProvider) {
      return _evaluateExpr((GenJavaExpressionProvider)it, diagramElement, valueExpr, instanceVar);
    } else if (it != null) {
      return _evaluateExpr(it, diagramElement, valueExpr, instanceVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, diagramElement, valueExpr, instanceVar).toString());
    }
  }

  public CharSequence javaMethod(final GenLinkEnd it) {
    if (it instanceof GenNode) {
      return _javaMethod((GenNode)it);
    } else if (it instanceof GenLink) {
      return _javaMethod((GenLink)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence javaMethod(final EObject it, final GenCommonBase diagramElement) {
    if (it instanceof GenFeatureSeqInitializer) {
      return _javaMethod((GenFeatureSeqInitializer)it, diagramElement);
    } else if (it instanceof TypeModelFacet) {
      return _javaMethod((TypeModelFacet)it, diagramElement);
    } else if (it instanceof GenElementInitializer) {
      return _javaMethod((GenElementInitializer)it, diagramElement);
    } else if (it instanceof ModelFacet) {
      return _javaMethod((ModelFacet)it, diagramElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, diagramElement).toString());
    }
  }

  public CharSequence javaMethod(final GenExpressionProviderBase it, final GenCommonBase diagramElement, final GenFeatureValueSpec vs) {
    if (it instanceof GenJavaExpressionProvider) {
      return _javaMethod((GenJavaExpressionProvider)it, diagramElement, vs);
    } else if (it != null) {
      return _javaMethod(it, diagramElement, vs);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, diagramElement, vs).toString());
    }
  }
}
