/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.util;

import com.google.common.collect.Iterators;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.IServiceRegistryProvider;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.tools.util.IExecutorService;
import org.eclipse.papyrus.infra.tools.util.IProgressCallable;
import org.eclipse.papyrus.infra.tools.util.IProgressRunnable;
import org.eclipse.papyrus.infra.tools.util.Iterators2;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.util.LocalMemento;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class UIUtil {
    private UIUtil() {
    }

    public static IExecutorService createUIExecutor(Display display) {
        return new DisplayExecutorService(display);
    }

    public static ExecutorService createObservableExecutor(Realm realm) {
        return new RealmExecutorService(realm);
    }

    public static IMemento createLocalMemento() {
        return LocalMemento.createMemento("__anonymous__", null);
    }

    public static <V> Future<V> syncCall(Display display, Callable<V> callable) {
        FutureTask<V> result = new FutureTask<V>(callable);
        display.syncExec(result);
        return result;
    }

    public static <V> Future<V> syncCall(Callable<V> callable) {
        return UIUtil.syncCall(Display.getDefault(), callable);
    }

    public static <V> Future<V> asyncCall(Display display, Callable<V> callable) {
        FutureTask<V> result = new FutureTask<V>(callable);
        display.asyncExec(result);
        return result;
    }

    public static <V> Future<V> asyncCall(Callable<V> callable) {
        return UIUtil.asyncCall(Display.getDefault(), callable);
    }

    public static <V> V call(IRunnableContext context, boolean fork, boolean cancelable, IProgressCallable<V> callable) throws InvocationTargetException, InterruptedException {
        class RunnableWrapper
        implements IRunnableWithProgress {
            final IProgressCallable<V> delegate;
            V result;

            RunnableWrapper(IProgressCallable<V> delegate) {
                this.delegate = delegate;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    this.result = this.delegate.call(monitor);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        RunnableWrapper wrapper = new RunnableWrapper(callable);
        context.run(fork, cancelable, (IRunnableWithProgress)wrapper);
        return wrapper.result;
    }

    public static Executor createAsyncOnceExecutor() {
        return UIUtil.createAsyncOnceExecutor(Display.getDefault());
    }

    public static Executor createAsyncOnceExecutor(final Display display) {
        return new Executor(){
            private final AtomicBoolean pending = new AtomicBoolean();

            @Override
            public void execute(final Runnable task) {
                if (this.pending.compareAndSet(false, true)) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            pending.set(false);
                            task.run();
                        }
                    });
                }
            }
        };
    }

    public static TreeIterator<Control> allChildren(Control root) {
        return new AbstractTreeIterator<Control>((Object)root, false){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends Control> getChildren(Object object) {
                return object instanceof Composite ? Iterators.forArray((Object[])((Composite)object).getChildren()) : Collections.emptyIterator();
            }
        };
    }

    public static <C extends Control> TreeIterator<C> allChildren(Control root, Class<C> type) {
        return Iterators2.filter(UIUtil.allChildren(root), type);
    }

    private static class DisplayExecutorService
    extends UIExecutorService {
        private final Display display;

        DisplayExecutorService(Display display) {
            this.display = display;
        }

        @Override
        void asyncExec(Runnable runnable) {
            this.display.asyncExec(runnable);
        }

        public void syncExec(Runnable task) {
            this.display.syncExec(task);
        }

        public <V> Future<V> submit(IProgressCallable<V> callable) {
            IProgressService service = this.getProgressService(callable);
            IWorkbenchSiteProgressService wbService = service instanceof IWorkbenchSiteProgressService ? (IWorkbenchSiteProgressService)service : null;
            FutureProgress<V> result = new FutureProgress<V>(callable, wbService);
            try {
                service.run(true, true, result);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            return result;
        }

        public <V> V syncCall(IProgressCallable<V> callable) throws InterruptedException, ExecutionException {
            IProgressService service = this.getProgressService(callable);
            IWorkbenchSiteProgressService wbService = service instanceof IWorkbenchSiteProgressService ? (IWorkbenchSiteProgressService)service : null;
            FutureProgress<V> result = new FutureProgress<V>(callable, wbService);
            try {
                service.busyCursorWhile(result);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            return (V)result.get();
        }
    }

    private static class FutureProgress<V>
    extends CompletableFuture<V>
    implements IRunnableWithProgress {
        private final IProgressCallable<V> delegate;
        private final IWorkbenchSiteProgressService service;
        private volatile IProgressMonitor monitor;

        FutureProgress(IProgressCallable<V> delegate, IWorkbenchSiteProgressService service) {
            this.delegate = delegate;
            this.service = service;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.monitor = monitor;
                if (this.service != null) {
                    this.service.incrementBusy();
                }
                try {
                    this.complete(this.delegate.call(monitor));
                }
                finally {
                    this.monitor = null;
                    if (this.service != null) {
                        this.service.decrementBusy();
                    }
                }
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            IProgressMonitor monitor = this.monitor;
            if (monitor != null) {
                monitor.setCanceled(true);
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }

    private static class RealmExecutorService
    extends UIExecutorService {
        private final Realm realm;

        RealmExecutorService(Realm realm) {
            this.realm = realm;
        }

        @Override
        void asyncExec(Runnable runnable) {
            this.realm.asyncExec(runnable);
        }

        public void syncExec(Runnable task) {
            this.realm.exec(task);
        }

        public <V> Future<V> submit(IProgressCallable<V> callable) {
            FutureTask<Object> result = new FutureTask<Object>(() -> callable.call((IProgressMonitor)new NullProgressMonitor()));
            this.asyncExec(result);
            return result;
        }

        public <V> V syncCall(IProgressCallable<V> callable) throws InterruptedException, ExecutionException {
            FutureTask<Object> result = new FutureTask<Object>(() -> callable.call((IProgressMonitor)new NullProgressMonitor()));
            this.syncExec(result);
            return (V)result.get();
        }
    }

    private static abstract class UIExecutorService
    extends AbstractExecutorService
    implements IExecutorService {
        private final Lock lock = new ReentrantLock();
        private final Condition emptyCond = this.lock.newCondition();
        private final Queue<RunnableWrapper> pending = new LinkedList<RunnableWrapper>();
        private volatile boolean shutdown;

        UIExecutorService() {
        }

        @Override
        public void execute(Runnable command) {
            if (this.isShutdown()) {
                throw new RejectedExecutionException("Executor service is shut down");
            }
            this.asyncExec(this.enqueue(command));
        }

        public <V> V syncCall(Callable<V> callable) throws InterruptedException, ExecutionException {
            class SyncResult
            implements Runnable {
                V result;
                ExecutionException fail;
                private final /* synthetic */ Callable val$callable;

                SyncResult(Callable callable) {
                    this.val$callable = callable;
                }

                @Override
                public void run() {
                    try {
                        this.result = this.val$callable.call();
                    }
                    catch (Exception e) {
                        this.fail = new ExecutionException(e);
                        this.fail.fillInStackTrace();
                    }
                }
            }
            SyncResult result = new SyncResult(callable);
            this.syncExec(result);
            if (result.fail != null) {
                throw result.fail;
            }
            return result.result;
        }

        abstract void asyncExec(Runnable var1);

        @Override
        public List<Runnable> shutdownNow() {
            ArrayList<Runnable> result = new ArrayList<Runnable>();
            this.shutdown();
            RunnableWrapper dequeued = this.dequeue();
            while (dequeued != null) {
                result.add(dequeued);
                dequeued = this.dequeue();
            }
            return result;
        }

        private RunnableWrapper enqueue(Runnable task) {
            RunnableWrapper result = new RunnableWrapper(task);
            this.lock.lock();
            try {
                boolean wasEmpty = this.pending.isEmpty();
                this.pending.offer(result);
                if (wasEmpty) {
                    this.emptyCond.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }

        private RunnableWrapper dequeue() {
            RunnableWrapper result = null;
            this.lock.lock();
            try {
                result = this.pending.poll();
                if (result == null) {
                    this.emptyCond.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }

        boolean dequeue(RunnableWrapper task) {
            boolean result = false;
            this.lock.lock();
            try {
                result = this.pending.remove(task);
                if (result && this.pending.isEmpty()) {
                    this.emptyCond.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }

        @Override
        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        public boolean isTerminated() {
            this.lock.lock();
            try {
                boolean bl = this.isShutdown() && this.pending.isEmpty();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            if (timeout < 0L) {
                throw new IllegalArgumentException("negative timeout");
            }
            Date deadline = timeout == 0L ? null : new Date(System.currentTimeMillis() + unit.toMillis(timeout));
            boolean result = false;
            this.lock.lock();
            try {
                block9: {
                    boolean stillWaiting;
                    block8: {
                        stillWaiting = true;
                        result = this.isTerminated();
                        if (!true) break block8;
                        if (result) return result;
                        if (!stillWaiting) break block9;
                    }
                    do {
                        if (deadline == null) {
                            this.emptyCond.await();
                        } else {
                            stillWaiting = this.emptyCond.awaitUntil(deadline);
                        }
                        result = this.isTerminated();
                        if (result) return result;
                    } while (stillWaiting);
                }
                return result;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Future<?> submit(final IProgressRunnable task) {
            return this.submit((IProgressCallable)new IProgressCallable<Void>(){

                public Void call(IProgressMonitor monitor) {
                    task.run(monitor);
                    return null;
                }
            });
        }

        public void syncExec(final IProgressRunnable task) throws InterruptedException, ExecutionException {
            this.syncCall((IProgressCallable)new IProgressCallable<Void>(){

                public Void call(IProgressMonitor monitor) {
                    task.run(monitor);
                    return null;
                }
            });
        }

        IProgressService getProgressService(IProgressCallable<?> callable) {
            IProgressService result;
            try {
                ServicesRegistry registry = callable instanceof IServiceRegistryProvider ? ((IServiceRegistryProvider)callable).getServiceRegistry() : null;
                IMultiDiagramEditor editor = (IMultiDiagramEditor)ServiceUtils.getInstance().getService(IMultiDiagramEditor.class, (Object)registry);
                result = (IProgressService)editor.getEditorSite().getService(IWorkbenchSiteProgressService.class);
            }
            catch (ServiceException e) {
                result = PlatformUI.getWorkbench().getProgressService();
            }
            return result;
        }

        private class RunnableWrapper
        implements Runnable {
            private final Runnable delegate;

            RunnableWrapper(Runnable delegate) {
                this.delegate = delegate;
            }

            @Override
            public void run() {
                if (UIExecutorService.this.dequeue(this)) {
                    this.delegate.run();
                }
            }
        }
    }
}

