/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula.function;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.formula.function.AbstractFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionException;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionValue;
import org.eclipse.nebula.widgets.nattable.formula.function.MultipleValueFunctionValue;
import org.eclipse.nebula.widgets.nattable.formula.function.StringFunctionValue;

public abstract class AbstractMathFunction
extends AbstractFunction {
    public AbstractMathFunction() {
    }

    public AbstractMathFunction(List<FunctionValue> values) {
        super(values);
        this.validateMethodParameter(values);
    }

    @Override
    public void addFunctionValue(FunctionValue value) {
        if (value instanceof StringFunctionValue) {
            throw new FunctionException("#VALUE!", Messages.getString("FormulaParser.error.invalidNumberValue", value.getValue()));
        }
        if (value instanceof MultipleValueFunctionValue) {
            Object multi = ((MultipleValueFunctionValue)value).getValue();
            this.validateMethodParameter((List<FunctionValue>)multi);
        }
        super.addFunctionValue(value);
    }

    protected BigDecimal convertValue(Object value) {
        if (value instanceof FunctionValue) {
            value = ((FunctionValue)value).getValue();
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        return new BigDecimal(value.toString());
    }

    protected void validateMethodParameter(List<FunctionValue> values) {
        for (FunctionValue value : values) {
            if (!(value instanceof StringFunctionValue)) continue;
            throw new FunctionException("#VALUE!", Messages.getString("FormulaParser.error.invalidNumberValue", value.getValue()));
        }
    }
}

