/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;

public final class LifelineUtils {
    private static final String LIFELINE_ANNOTATION = "org.eclipse.papyrus.uml.diagram.timing.lifeline";
    private static final String LIFELINE_TYPE = "type";

    private LifelineUtils() {
    }

    public static LifelineType getLifelineType(Lifeline lifeline) {
        String type;
        EAnnotation eAnnotation = lifeline.getEAnnotation(LIFELINE_ANNOTATION);
        if (eAnnotation != null && (type = (String)eAnnotation.getDetails().get((Object)LIFELINE_TYPE)) != null) {
            return LifelineType.valueOf(type);
        }
        return LifelineType.full;
    }

    public static void setLifelineType(Lifeline lifeline, LifelineType lifelineType) {
        EAnnotation eAnnotation = lifeline.getEAnnotation(LIFELINE_ANNOTATION);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(LIFELINE_ANNOTATION);
            lifeline.getEAnnotations().add((Object)eAnnotation);
        }
        eAnnotation.getDetails().put((Object)LIFELINE_TYPE, (Object)lifelineType.name());
    }

    public static void updateFragmentNames(Lifeline lifeline, View lifelineView) {
        View fullLifelineView = lifelineView;
        if (lifelineView != null && !"Lifeline_FullShape".equals(lifelineView.getType())) {
            fullLifelineView = null;
        }
        HashMap<String, Integer> stateInvariantCounts = new HashMap<String, Integer>();
        EList fragments = lifeline.getCoveredBys();
        HashMap<StateInvariant, CallSite> stateInvariantNames = new HashMap<StateInvariant, CallSite>();
        int i = 0;
        while (i < fragments.size()) {
            InteractionFragment interactionFragment = (InteractionFragment)fragments.get(i);
            if (interactionFragment instanceof StateInvariant) {
                String baseStateInvariantName;
                StateInvariant stateInvariant = (StateInvariant)interactionFragment;
                String stateInvariantId = StateInvariantUtils.getStateInvariantId(stateInvariant);
                if (stateInvariantId != null && fullLifelineView != null) {
                    View stateDefinitionView = StateDefinitionUtils.getStateDefinitionViewWithId(stateInvariantId, fullLifelineView);
                    baseStateInvariantName = StateDefinitionUtils.getStateDefinitionName(stateDefinitionView);
                    StateInvariantUtils.setInnerStateInvariantName(stateInvariant, baseStateInvariantName);
                } else {
                    baseStateInvariantName = StateInvariantUtils.getInnerStateInvariantName(stateInvariant);
                }
                if (baseStateInvariantName != null) {
                    Integer count = (Integer)stateInvariantCounts.get(baseStateInvariantName);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    String stateInvariantName = baseStateInvariantName + "_" + String.valueOf(count);
                    stateInvariant.setName(stateInvariantName);
                    stateInvariantCounts.put(baseStateInvariantName, count);
                    stateInvariantNames.put(stateInvariant, (CallSite)((Object)stateInvariantName));
                }
            }
            ++i;
        }
        int nFragments = fragments.size();
        int i2 = 0;
        while (i2 < nFragments) {
            OccurrenceSpecification occurrenceSpecification;
            InteractionFragment interactionFragment = (InteractionFragment)fragments.get(i2);
            if (interactionFragment instanceof OccurrenceSpecification && OccurrenceSpecificationUtils.isAutogeneratedName(occurrenceSpecification = (OccurrenceSpecification)interactionFragment)) {
                if (i2 == 0) {
                    occurrenceSpecification.setName(Messages.LifelineUtils_CreationOccurrence);
                } else if (i2 == nFragments - 1) {
                    occurrenceSpecification.setName(Messages.LifelineUtils_DestructionOccurrence);
                } else {
                    InteractionFragment previous = (InteractionFragment)fragments.get(i2 - 1);
                    InteractionFragment next = (InteractionFragment)fragments.get(i2 + 1);
                    if (previous instanceof StateInvariant && next instanceof StateInvariant) {
                        StateInvariant precedingStateInvariant = (StateInvariant)previous;
                        StateInvariant followingStateInvariant = (StateInvariant)next;
                        String previousName = (String)stateInvariantNames.get(precedingStateInvariant);
                        String followingName = (String)stateInvariantNames.get(followingStateInvariant);
                        if (previousName == null) {
                            previousName = "<unnamed>";
                        }
                        if (followingName == null) {
                            followingName = "<unnamed>";
                        }
                        occurrenceSpecification.setName(previousName + "_To_" + followingName);
                    }
                }
            }
            ++i2;
        }
    }

    public static IUndoableOperation getUpdateFragmentNamesCommand(EObject element) {
        HashSet<View> impactedLifelines = new HashSet<View>();
        Set crossReferencingViews = CrossReferencerUtil.getCrossReferencingViews((EObject)element, (String)"PapyrusUMLTimingDiagram");
        for (View referencingView : crossReferencingViews) {
            View lifeline = ViewUtils.findSuperViewWithId(referencingView, "Lifeline_FullShape");
            if (lifeline == null) {
                lifeline = ViewUtils.findSuperViewWithId(referencingView, "Lifeline_CompactShape");
            }
            if (lifeline == null) continue;
            impactedLifelines.add(lifeline);
        }
        if (impactedLifelines.isEmpty()) {
            return null;
        }
        CompositeCommand compositeCommand = new CompositeCommand(Messages.LifelineUtils_UpdateFragmentNames);
        for (final View lifelineView : impactedLifelines) {
            Assert.isLegal((boolean)(lifelineView.getElement() instanceof Lifeline));
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)lifelineView);
            compositeCommand.add((IUndoableOperation)new AbstractTransactionalCommand(editingDomain, Messages.LifelineUtils_UpdateLifelineFragmentNames, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    EObject element = lifelineView.getElement();
                    if (element instanceof Lifeline) {
                        Lifeline lifeline = (Lifeline)element;
                        LifelineUtils.updateFragmentNames(lifeline, lifelineView);
                    }
                    return CommandResult.newOKCommandResult();
                }
            });
        }
        return compositeCommand;
    }

    public static boolean isLifelineEditPart(String visualID) {
        return "Lifeline_FullShape".equals(visualID) || "Lifeline_CompactShape".equals(visualID);
    }

    public static boolean isLifelineEditPart(EditPart editPart) {
        return editPart instanceof FullLifelineEditPartCN || editPart instanceof CompactLifelineEditPartCN;
    }

    public static boolean isLifelineView(View view) {
        String visualID = UMLVisualIDRegistry.getVisualID(view);
        return LifelineUtils.isLifelineEditPart(visualID);
    }

    public static EditPart getLifelineCompartment(EditPart lifelineEditPart) {
        EditPart compartment = lifelineEditPart instanceof FullLifelineEditPartCN ? EditPartUtils.findFirstChildEditPartWithId(lifelineEditPart, "Lifeline_FullSubfragmentCompartment") : EditPartUtils.findFirstChildEditPartWithId(lifelineEditPart, "Lifeline_CompactSubfragmentCompartment");
        if (compartment == null) {
            throw new IllegalStateException("No compartment in Lifeline");
        }
        return compartment;
    }

    public static enum LifelineType {
        full,
        compact;

    }
}

