/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.deprecatedelements;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sysml14.deprecatedelements.FlowPort;
import org.eclipse.papyrus.sysml14.deprecatedelements.FlowSpecification;
import org.eclipse.papyrus.sysml14.deprecatedelements.internal.impl.FlowPortImpl;
import org.eclipse.papyrus.sysml14.internal.util.IconUtil;
import org.eclipse.papyrus.sysml14.portsandflows.FlowDirection;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class FlowPortCustomImpl
extends FlowPortImpl
implements FlowPort {
    private static Map<String, Image> icons;

    public static Map<String, Image> getIcons(FlowPort flowPort) {
        if (icons == null) {
            Stereotype stereotype = UMLUtil.getStereotype((EObject)flowPort);
            icons = IconUtil.getImages(stereotype);
        }
        return icons;
    }

    @Override
    public boolean isAtomic() {
        FlowSpecification flowSpec;
        Type type;
        boolean isAtomic = true;
        if (this.getBase_Port() != null && (type = this.getBase_Port().getType()) != null && type instanceof Interface && (flowSpec = (FlowSpecification)UMLUtil.getStereotypeApplication((Element)type, FlowSpecification.class)) != null) {
            isAtomic = false;
        }
        return isAtomic;
    }

    @Override
    public Image getIcon() {
        Image image = null;
        if (this.getBase_Port() != null) {
            Map<String, Image> iconList = FlowPortCustomImpl.getIcons(this);
            switch (this.getDirection()) {
                case IN: {
                    image = iconList.get(this.getImageKey(FlowDirection.IN));
                    break;
                }
                case OUT: {
                    image = iconList.get(this.getImageKey(FlowDirection.OUT));
                    break;
                }
                case INOUT: {
                    image = iconList.get(this.getImageKey(FlowDirection.INOUT));
                    break;
                }
                default: {
                    image = iconList.get(this.getImageKey(FlowDirection.INOUT));
                }
            }
        }
        return image;
    }

    private String getImageKey(FlowDirection flowDirection) {
        return String.valueOf(FlowPort.class.getSimpleName()) + "_" + flowDirection.getName().toUpperCase();
    }
}

