/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IOpenable;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ContentChangedEventProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.DefaultCurrentFolderAndPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ICurrentFolderAndPageMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.BasicPageManagerImpl;
import org.eclipse.swt.widgets.Display;

public class PageManagerImpl
extends BasicPageManagerImpl {
    private ICurrentFolderAndPageMngr folderAndPageMngr;
    private ContentChangedEventProvider contentChangedEventProvider;

    protected PageManagerImpl(SashWindowsMngr diSashModel, ContentChangedEventProvider contentChangedEventProvider) {
        super(diSashModel);
        this.contentChangedEventProvider = contentChangedEventProvider;
        this.folderAndPageMngr = new DefaultCurrentFolderAndPageMngr(diSashModel);
    }

    protected PageManagerImpl(SashWindowsMngr diSashModel, ContentChangedEventProvider contentChangedEventProvider, ICurrentFolderAndPageMngr folderAndPageMngr) {
        super(diSashModel);
        this.contentChangedEventProvider = contentChangedEventProvider;
        this.folderAndPageMngr = folderAndPageMngr;
    }

    protected TabFolder getCurrentFolder() {
        return this.folderAndPageMngr.getCurrentFolder();
    }

    protected boolean isLegacyMode() {
        return false;
    }

    protected boolean isPage(EObject content) {
        return Platform.getAdapterManager().getAdapter((Object)content, IOpenable.class) != null;
    }

    public void closePage(Object pageIdentifier) {
        this.doExecute(() -> super.closePage(pageIdentifier));
    }

    public void closeAllOpenedPages() {
        this.doExecute(() -> super.closeAllOpenedPages());
    }

    public void closeOtherPages(Object pageIdentifier) {
        this.doExecute(() -> super.closeOtherPages(pageIdentifier));
    }

    public void selectPage(final Object pageIdentifier) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PageManagerImpl.this.folderAndPageMngr.setActivePage(pageIdentifier);
            }
        });
    }

    public void setCurrentFolderAndPageMngr(ICurrentFolderAndPageMngr currentFolderAndPageMngr) {
        this.folderAndPageMngr = currentFolderAndPageMngr;
    }

    protected <T> T doExecute(BasicPageManagerImpl.SashModelOperation<T> sashModelOperation) {
        Object result;
        boolean deliver = this.contentChangedEventProvider.isDeliver();
        this.contentChangedEventProvider.setDeliver(false);
        try {
            result = super.doExecute(sashModelOperation);
        }
        finally {
            this.contentChangedEventProvider.setDeliver(deliver);
        }
        return (T)result;
    }

    private void doExecute(Runnable sashModelOperation) {
        this.doExecute(ignored -> {
            sashModelOperation.run();
            return ignored;
        });
    }
}

