/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class UnlinkPrototypeAction
extends AbstractLaunchConfigurationAction {
    public static final String ID_UNLINK_PROTOTYPE_ACTION = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".ID_UNLINK_PROTOTYPE_ACTION";

    public UnlinkPrototypeAction(Viewer viewer, String mode) {
        super(LaunchConfigurationsMessages.UnlinkPrototypeAction_Unlink_prototype_1, viewer, mode);
    }

    @Override
    protected void performAction() {
        try {
            for (Object launchConfiguration : this.getStructuredSelection().toList()) {
                ILaunchConfigurationDialog dialog;
                if (!(launchConfiguration instanceof ILaunchConfiguration)) continue;
                ILaunchConfigurationWorkingCopy workingCopy = ((ILaunchConfiguration)launchConfiguration).getWorkingCopy();
                workingCopy.setPrototype(null, false);
                workingCopy.doSave();
                if (this.getStructuredSelection().size() != 1 || !((dialog = LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog()) instanceof LaunchConfigurationsDialog)) continue;
                ((LaunchConfigurationsDialog)dialog).getTabViewer().setInput(workingCopy);
            }
            this.getViewer().refresh();
        }
        catch (CoreException e) {
            this.errorDialog(e);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean onlyLaunchConfigurationWithPrototypeSelected = false;
        for (Object object : selection.toList()) {
            if (object instanceof ILaunchConfiguration) {
                if (((ILaunchConfiguration)object).isPrototype()) {
                    return false;
                }
                try {
                    if (((ILaunchConfiguration)object).getPrototype() != null) {
                        onlyLaunchConfigurationWithPrototypeSelected = true;
                        continue;
                    }
                    return false;
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e.getStatus());
                    continue;
                }
            }
            return false;
        }
        return onlyLaunchConfigurationWithPrototypeSelected;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_DLCL_UNLINK_PROTO");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_ELCL_UNLINK_PROTO");
    }

    public String getToolTipText() {
        return LaunchConfigurationsMessages.LaunchConfigurationsDialog_8;
    }
}

