/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.common.layout.DistributionTree;
import org.eclipse.papyrus.uml.diagram.common.layout.EditPartTree;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractDistributeAction;

public class DistributeNodeAction
extends AbstractDistributeAction {
    private EditPartTree rootTree;
    private boolean parentContainer;
    private double margin = 10.0;

    public DistributeNodeAction(int distribution, List<IGraphicalEditPart> selectedElements) {
        super(distribution, selectedElements);
    }

    @Override
    protected void buildAction(List<?> elementsForAction) {
        switch (this.distribution) {
            case 64: 
            case 128: {
                this.parentContainer = true;
                break;
            }
            case 66: 
            case 144: {
                this.parentContainer = false;
                break;
            }
        }
        ArrayList<EditPart> elements = new ArrayList<EditPart>();
        int i = 0;
        while (i < elementsForAction.size()) {
            elements.add(i, (EditPart)elementsForAction.get(i));
            ++i;
        }
        this.rootTree = new DistributionTree(elements);
        this.createRequests(elements);
    }

    @Override
    public Command getCommand() {
        CompoundCommand command = new CompoundCommand("Command to Distribute Nodes");
        Enumeration eptEnum = this.rootTree.breadthFirstEnumeration();
        while (eptEnum.hasMoreElements()) {
            ChangeBoundsRequest currentReq;
            EditPartTree ept = (EditPartTree)eptEnum.nextElement();
            if (ept.getEditPart() == null || (currentReq = (ChangeBoundsRequest)ept.getRequest()) == null) continue;
            Command curCommand = null;
            curCommand = ept.getEditPart().getCommand((Request)currentReq);
            if (curCommand == null) continue;
            command.add(curCommand);
        }
        return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
    }

    protected void createRequests(List<EditPart> editparts) {
        int depth;
        int i = depth = this.rootTree.getDepth();
        while (i >= 0) {
            List epTrees = this.rootTree.getChildLevel(i);
            if (i == 0) {
                epTrees.add(this.rootTree);
            }
            int iter = 0;
            while (iter < epTrees.size()) {
                List children = ((EditPartTree)epTrees.get(iter)).getChildLevel(1);
                this.removeUnselectedTree(children);
                if (children.size() >= 2 && this.parentContainer || children.size() >= 3 && !this.parentContainer) {
                    ArrayList<EditPart> childrenEP = new ArrayList<EditPart>();
                    for (EditPartTree editPartTree : children) {
                        childrenEP.add(editPartTree.getEditPart());
                    }
                    PrecisionRectangle boundsArea = this.calcultateArea(childrenEP);
                    if (this.parentContainer && !(((EditPartTree)children.get(0)).getEditPart().getParent() instanceof RootEditPart)) {
                        double usedMargin = this.margin > 6.0 ? this.margin : 6.0;
                        boundsArea.setX(boundsArea.preciseX() + usedMargin);
                        boundsArea.setY(boundsArea.preciseY() + usedMargin);
                        boundsArea.setWidth(boundsArea.preciseWidth() - 2.0 * usedMargin);
                        boundsArea.setHeight(boundsArea.preciseHeight() - 2.0 * usedMargin);
                    }
                    double[] hSpaceAndvSpace = this.calculatesSpaceBetweenNodes(boundsArea, childrenEP);
                    Collections.sort(children, new CoordinatesComparator());
                    double newPosition = 0.0;
                    switch (this.distribution) {
                        case 64: {
                            newPosition = !this.horizontalDegradedMode ? boundsArea.preciseX + hSpaceAndvSpace[0] : boundsArea.preciseX();
                            break;
                        }
                        case 66: {
                            newPosition = boundsArea.preciseX;
                            break;
                        }
                        case 128: {
                            newPosition = !this.verticalDegradedMode ? boundsArea.preciseY + hSpaceAndvSpace[1] : boundsArea.preciseY();
                            break;
                        }
                        case 144: {
                            newPosition = boundsArea.preciseY;
                            break;
                        }
                    }
                    for (EditPartTree editPartTree : children) {
                        if (!editPartTree.isSelected()) continue;
                        PrecisionPoint ptLocation = null;
                        PrecisionRectangle absolutePosition = LayoutUtils.getAbsolutePosition((EditPart)editPartTree.getEditPart());
                        if (this.distribution == 64 || this.distribution == 66) {
                            ptLocation = new PrecisionPoint(newPosition, absolutePosition.preciseY);
                            newPosition += absolutePosition.preciseWidth() + hSpaceAndvSpace[0];
                        } else {
                            ptLocation = new PrecisionPoint(absolutePosition.preciseX, newPosition);
                            newPosition += absolutePosition.preciseHeight() + hSpaceAndvSpace[1];
                        }
                        if (ptLocation == null) continue;
                        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move");
                        req.setEditParts(editPartTree.getEditPart());
                        PrecisionPoint oldLocation = new PrecisionPoint(absolutePosition.preciseX, absolutePosition.preciseY);
                        Dimension delta = ptLocation.getDifference((Point)oldLocation);
                        req.setMoveDelta(new Point(delta.width, delta.height));
                        req.setSizeDelta(absolutePosition.getSize().getDifference(absolutePosition.getSize()));
                        editPartTree.setRequest((Request)req);
                    }
                }
                ++iter;
            }
            --i;
        }
    }

    protected void removeUnselectedTree(List<EditPartTree> epTrees) {
        ArrayList<EditPartTree> removedChildren = new ArrayList<EditPartTree>();
        for (EditPartTree editPartTree : epTrees) {
            if (editPartTree.isSelected()) continue;
            removedChildren.add(editPartTree);
        }
        epTrees.removeAll(removedChildren);
    }

    protected PrecisionRectangle calcultateArea(List<EditPart> nodeChild) {
        PrecisionRectangle area = new PrecisionRectangle();
        if (this.parentContainer) {
            area = LayoutUtils.getAbsolutePosition((EditPart)nodeChild.get(0).getParent());
        } else {
            PrecisionRectangle tmpArea = LayoutUtils.getAbsolutePosition((EditPart)nodeChild.get(0));
            double minX = tmpArea.preciseX();
            double maxX = tmpArea.preciseX() + tmpArea.preciseWidth();
            double minY = tmpArea.preciseY();
            double maxY = tmpArea.preciseY() + tmpArea.preciseHeight();
            for (EditPart currentEP : nodeChild) {
                if (currentEP.getSelected() == 0) continue;
                tmpArea = LayoutUtils.getAbsolutePosition((EditPart)currentEP);
                minX = tmpArea.preciseX < minX ? tmpArea.preciseX : minX;
                minY = tmpArea.preciseY < minY ? tmpArea.preciseY : minY;
                maxX = tmpArea.getTopRight().preciseX() > maxX ? tmpArea.getTopRight().preciseX() : maxX;
                double d = maxY = tmpArea.getBottomRight().preciseY() > maxY ? tmpArea.getBottomRight().preciseY() : maxY;
            }
            area.setX(minX);
            area.setY(minY);
            area.setHeight(Math.abs(maxY - minY));
            area.setWidth(Math.abs(maxX - minX));
        }
        return area;
    }

    protected double[] calculatesSpaceBetweenNodes(PrecisionRectangle boundsArea, List<EditPart> nodeChild) {
        this.horizontalDegradedMode = false;
        this.verticalDegradedMode = false;
        double vertical = 0.0;
        double horizontal = 0.0;
        double vSpace = 0.0;
        double hSpace = 0.0;
        double[] hSpaceAndvSpace = new double[]{0.0, 0.0};
        for (EditPart currentEP : nodeChild) {
            if (currentEP.getSelected() == 0) continue;
            PrecisionRectangle rect = LayoutUtils.getAbsolutePosition((EditPart)currentEP);
            vertical += rect.preciseHeight();
            horizontal += rect.preciseWidth();
        }
        double divisor = 1.0;
        if (this.parentContainer) {
            divisor = nodeChild.size() + 1;
        } else if (!this.parentContainer) {
            divisor = nodeChild.size() - 1;
        }
        hSpace = (boundsArea.preciseWidth() - horizontal) / divisor;
        vSpace = (boundsArea.preciseHeight() - vertical) / divisor;
        if (hSpace < 0.0 && this.parentContainer) {
            this.horizontalDegradedMode = true;
            double diff = boundsArea.preciseWidth() - horizontal;
            hSpace = diff / (divisor - 2.0);
        }
        if (vSpace < 0.0 && this.parentContainer) {
            this.verticalDegradedMode = true;
            double diff = boundsArea.preciseHeight() - vertical;
            vSpace = diff / (divisor - 2.0);
        }
        hSpaceAndvSpace[0] = hSpace;
        hSpaceAndvSpace[1] = vSpace;
        return hSpaceAndvSpace;
    }

    protected class CoordinatesComparator
    implements Comparator<Object> {
        protected CoordinatesComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            PrecisionRectangle rect1 = LayoutUtils.getAbsolutePosition((EditPart)((EditPartTree)o1).getEditPart());
            PrecisionRectangle rect2 = LayoutUtils.getAbsolutePosition((EditPart)((EditPartTree)o2).getEditPart());
            if (DistributeNodeAction.this.distribution == 64 || DistributeNodeAction.this.distribution == 66) {
                if (rect1.preciseX() < rect2.preciseX()) {
                    return -1;
                }
                if (rect1.preciseX() == rect2.preciseX()) {
                    return 0;
                }
                return 1;
            }
            if (rect1.preciseY() < rect2.preciseY()) {
                return -1;
            }
            if (rect1.preciseY() == rect2.preciseY()) {
                return 0;
            }
            return 1;
        }
    }
}

