/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.CustomOclValidationVisitor;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.MappingExtensionHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalAstWalker;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.EntryOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ConversionUtils;
import org.eclipse.m2m.internal.qvt.oml.stdlib.QVTUMLReflection;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BlockExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BreakExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ContinueExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeExpression;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeLoopExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.InstantiationExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ReturnExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.VariableInitExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.WhileExp;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.IfExp;
import org.eclipse.ocl.ecore.IterateExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.lpg.FormattingHelper;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.Visitable;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalValidationVisitor
extends QvtOperationalAstWalker {
    private QvtOperationalEnv fEnv;

    public QvtOperationalValidationVisitor(QvtOperationalEnv environment) {
        super(new ValidationNodeProcessor(environment));
        ((ValidationNodeProcessor)this.getNodeProcessor()).myOclValidationVisitor.setVisitor(this);
        this.fEnv = environment;
    }

    @Override
    public Object visitIfExp(org.eclipse.ocl.expressions.IfExp<EClassifier> ifExp) {
        if (ifExp.getCondition() == null || ifExp.getThenExpression() == null) {
            QvtOperationalUtil.reportError(this.fEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_ifExpIncomplete, new Object[0]), ifExp.getStartPosition(), ifExp.getEndPosition());
        } else if (ifExp.getCondition().getType() != this.fEnv.getOCLStandardLibrary().getBoolean()) {
            QvtOperationalUtil.reportError(this.fEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_ifExpNonBooleanCond, new Object[0]), ifExp.getStartPosition(), ifExp.getEndPosition());
        }
        EObject container = ifExp.eContainer();
        while (container != null) {
            if (container instanceof VariableInitExp && ifExp.getElseExpression() == null) {
                QvtOperationalUtil.reportWarning(this.fEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_ifExpWithoutElseAssignment, new Object[0]), ifExp.getStartPosition(), ifExp.getEndPosition());
                break;
            }
            container = container.eContainer();
        }
        return super.visitIfExp(ifExp);
    }

    @Override
    public Object visitContinueExp(ContinueExp astNode) {
        this.validateBreakContinue((ImperativeExpression)astNode);
        return super.visitContinueExp(astNode);
    }

    @Override
    public Object visitBreakExp(BreakExp astNode) {
        this.validateBreakContinue((ImperativeExpression)astNode);
        return super.visitBreakExp(astNode);
    }

    private void validateBreakContinue(ImperativeExpression breakContinueExp) {
        boolean isLoopFound = false;
        EObject container = breakContinueExp.eContainer();
        while (container != null) {
            if (container instanceof ImperativeLoopExp || container instanceof WhileExp) {
                isLoopFound = true;
                break;
            }
            if (container instanceof IterateExp || container instanceof IteratorExp) break;
            container = container.eContainer();
        }
        if (!isLoopFound) {
            QvtOperationalUtil.reportError(this.fEnv, NLS.bind(ValidationMessages.BreakContinue_InvalidExpressionUsage, breakContinueExp.eClass().getName()), breakContinueExp.getStartPosition(), breakContinueExp.getEndPosition());
        } else if (!(breakContinueExp.eContainer() instanceof ImperativeExpression) && !(breakContinueExp.eContainer() instanceof IfExp)) {
            QvtOperationalUtil.reportError(this.fEnv, NLS.bind(ValidationMessages.BreakContinue_InvalidExpressionOwner, breakContinueExp.eClass().getName()), breakContinueExp.getStartPosition(), breakContinueExp.getEndPosition());
        }
    }

    @Override
    public Object visitOperationCallExp(OperationCallExp<EClassifier, EOperation> callExp) {
        if (callExp.getReferredOperation() instanceof Constructor) {
            QvtOperationalUtil.reportError(this.fEnv, NLS.bind(ValidationMessages.OperationIsUndefined, this.operationString(this.fEnv, ((EOperation)callExp.getReferredOperation()).getName(), (List<? extends TypedElement<EClassifier>>)callExp.getArgument()), callExp.getSource() == null ? null : this.fEnv.getUMLReflection().getName(callExp.getSource().getType())), callExp.getStartPosition(), callExp.getEndPosition());
        }
        return super.visitOperationCallExp(callExp);
    }

    protected String operationString(QvtOperationalEnv env, String operName, List<? extends TypedElement<EClassifier>> args) {
        StringBuffer result = new StringBuffer();
        result.append(operName);
        result.append('(');
        Iterator<? extends TypedElement<EClassifier>> iter = args.iterator();
        while (iter.hasNext()) {
            TypedElement<EClassifier> arg = iter.next();
            EClassifier type = (EClassifier)arg.getType();
            result.append(type == null ? null : env.getUMLReflection().getName((Object)type));
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public Object visitInstantiationExp(InstantiationExp instantiationExp) {
        Constructor constructorOp;
        Boolean result = Boolean.TRUE;
        EClass instantiatedClass = instantiationExp.getInstantiatedClass();
        Variable referredObject = null;
        if (instantiationExp.eContainer() instanceof Variable) {
            referredObject = (Variable)instantiationExp.eContainer();
        }
        if (instantiatedClass == null && referredObject != null && QVTUMLReflection.isUserModelElement((EClassifier)referredObject.getType())) {
            instantiatedClass = (EClass)referredObject.getType();
        }
        if ((constructorOp = ASTBindingHelper.getConstructorOperation(instantiationExp)) != null) {
            if (instantiatedClass != null && (instantiatedClass.isAbstract() || instantiatedClass.isInterface())) {
                QvtOperationalUtil.reportError(this.fEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_canNotInstantiateAbstractType, QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, (EClassifier)instantiatedClass)), instantiationExp.getStartPosition(), instantiationExp.getEndPosition());
                result = Boolean.FALSE;
            }
            return result;
        }
        if (instantiatedClass != null && !QvtOperationalStdLibrary.INSTANCE.getTransformationClass().isSuperTypeOf(instantiatedClass) && instantiationExp.getArgument().isEmpty()) {
            if (instantiatedClass.isAbstract() || instantiatedClass.isInterface()) {
                QvtOperationalUtil.reportError(this.fEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_canNotInstantiateAbstractType, QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, (EClassifier)instantiatedClass)), instantiationExp.getStartPosition(), instantiationExp.getEndPosition());
                result = Boolean.FALSE;
            }
            return result;
        }
        if (instantiatedClass == null || !QvtOperationalStdLibrary.INSTANCE.getTransformationClass().isSuperTypeOf(instantiatedClass)) {
            EClassifier type;
            EClassifier eClassifier = type = referredObject != null ? (EClassifier)referredObject.getType() : (EClassifier)instantiationExp.getType();
            if (type != null) {
                if (type instanceof org.eclipse.ocl.types.CollectionType) {
                    if (type.getInstanceClass() == null || type.getInstanceClass() == Collection.class) {
                        QvtOperationalUtil.reportError(this.fEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_canNotInstantiateAbstractType, QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, type)), instantiationExp.getStartPosition(), instantiationExp.getEndPosition());
                        result = Boolean.FALSE;
                    }
                } else if (type instanceof EDataType) {
                    if (instantiationExp.getArgument().size() != 1 || !ConversionUtils.isStringType((EClassifier)((org.eclipse.ocl.ecore.OCLExpression)instantiationExp.getArgument().get(0)).getType())) {
                        this.fEnv.reportError(NLS.bind(ValidationMessages.QvtOperationalValidationVisitor_invalidParamsForDatatypeInstantiation, instantiationExp.getArgument(), QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, type)), instantiationExp.getStartPosition(), instantiationExp.getEndPosition());
                        result = Boolean.FALSE;
                    }
                } else {
                    this.fEnv.reportError(NLS.bind(ValidationMessages.QvtOperationalValidationVisitor_invalidInstantiatedType, QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, type)), instantiationExp.getStartPosition(), instantiationExp.getEndPosition());
                    result = Boolean.FALSE;
                }
            }
        } else {
            ImperativeOperation mainOperation;
            Module instantiatedModule = (Module)instantiatedClass;
            if (!(instantiatedModule.isIsBlackbox() || (mainOperation = QvtOperationalParserUtil.getMainOperation(instantiatedModule)) instanceof EntryOperation && mainOperation.getEParameters().isEmpty())) {
                String message = NLS.bind(ValidationMessages.QvtOperationalValidationVisitor_ParameterlessMainExpected, instantiatedModule.getName());
                this.fEnv.reportError(message, instantiationExp.getStartPosition(), instantiationExp.getEndPosition());
            }
        }
        if (instantiatedClass instanceof OperationalTransformation) {
            OperationalTransformation transf = (OperationalTransformation)instantiatedClass;
            EList actualArgs = instantiationExp.getArgument();
            EList<ModelParameter> formalArgs = transf.getModelParameter();
            if (actualArgs.size() == formalArgs.size()) {
                int i = 0;
                for (ModelParameter modelParameter : formalArgs) {
                    boolean compatible;
                    EClassifier paramType = (EClassifier)modelParameter.getType();
                    org.eclipse.ocl.ecore.OCLExpression nextActualArg = (org.eclipse.ocl.ecore.OCLExpression)actualArgs.get(i++);
                    EClassifier expectedType = (EClassifier)nextActualArg.getType();
                    boolean bl = compatible = paramType instanceof ModelType && expectedType instanceof ModelType && this.checkCompatibleModelType((ModelType)paramType, (ModelType)expectedType);
                    if (compatible) continue;
                    this.fEnv.reportError(NLS.bind(ValidationMessages.QvtOperationalValidationVisitor_incompatibleArgumentModelType, this.fEnv.getFormatter().formatType(nextActualArg.getType()), this.fEnv.getFormatter().formatType((Object)modelParameter.getEType())), nextActualArg.getStartPosition(), nextActualArg.getEndPosition());
                    result = Boolean.FALSE;
                }
            } else {
                this.fEnv.reportError(NLS.bind(ValidationMessages.QvtOperationalValidationVisitor_unresolvedTransformationSignature, new Object[]{this.fEnv.getFormatter().formatName((Object)transf), this.formatArgumentList((List<?>)actualArgs, this.fEnv.getFormatter()), this.formatArgumentList((List<?>)formalArgs, this.fEnv.getFormatter())}), instantiationExp.getStartPosition(), instantiationExp.getEndPosition());
                result = Boolean.FALSE;
            }
        }
        return result;
    }

    private String formatArgumentList(List<?> args, FormattingHelper helper) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        int i = 0;
        for (Object nextArg : args) {
            if (i++ > 0) {
                buf.append(',').append(' ');
            }
            if (nextArg instanceof TypedElement) {
                TypedElement typedElement = (TypedElement)nextArg;
                buf.append(helper.formatType(typedElement.getType()));
                continue;
            }
            if (nextArg instanceof ETypedElement) {
                buf.append(helper.formatType((Object)((ETypedElement)nextArg).getEType()));
                continue;
            }
            if (!(nextArg instanceof EClassifier)) continue;
            buf.append(helper.formatType(nextArg));
        }
        buf.append(')');
        return buf.toString();
    }

    private boolean checkCompatibleModelType(ModelType modelType1, ModelType modelType2) {
        EList<EPackage> metamodel1 = modelType1.getMetamodel();
        EList<EPackage> metamodel2 = modelType2.getMetamodel();
        if (metamodel1.size() < metamodel2.size()) {
            return false;
        }
        LinkedList<String> uris1 = new LinkedList<String>();
        for (EPackage ePackage : metamodel1) {
            if (ePackage.getNsURI() != null) {
                uris1.add(ePackage.getNsURI());
                continue;
            }
            return false;
        }
        LinkedList<String> uris2 = new LinkedList<String>();
        for (EPackage ePackage : metamodel1) {
            if (ePackage.getNsURI() != null) {
                uris2.add(ePackage.getNsURI());
                continue;
            }
            return false;
        }
        return uris1.containsAll(uris2);
    }

    @Override
    public Object visitMappingCallExp(MappingCallExp mappingCallExp) {
        if (mappingCallExp.getReferredOperation() instanceof MappingOperation) {
            MappingOperation mappingOperation = (MappingOperation)mappingCallExp.getReferredOperation();
            if (QvtOperationalUtil.hasAbstractOutputParameter(mappingOperation) && QvtOperationalParserUtil.isAbstractOperation(mappingOperation) && mappingOperation.getDisjunct().isEmpty()) {
                String errMessage = NLS.bind(ValidationMessages.directCallToAbstractMappingDisallowed, QvtOperationalParserUtil.safeGetMappingQualifiedName(this.fEnv, mappingOperation));
                this.fEnv.reportError(errMessage, mappingCallExp.getStartPosition(), mappingCallExp.getEndPosition());
            }
            Iterator itArgument = mappingCallExp.getArgument().iterator();
            Iterator itParams = mappingOperation.getEParameters().iterator();
            while (itArgument.hasNext()) {
                OCLExpression arg = (OCLExpression)itArgument.next();
                MappingParameter mappingParam = (MappingParameter)itParams.next();
                if (mappingParam.getKind() != DirectionKind.OUT) continue;
                if (!(arg instanceof VariableExp) && !(arg instanceof PropertyCallExp)) {
                    this.fEnv.reportError(ValidationMessages.outParamNotAnLValueError, arg.getStartPosition(), arg.getEndPosition());
                }
                if (arg.getType() == mappingParam.getEType()) continue;
                this.fEnv.reportError(ValidationMessages.outParamNotSameTypeError, arg.getStartPosition(), arg.getEndPosition());
            }
        }
        return super.visitMappingCallExp(mappingCallExp);
    }

    @Override
    public Object visitReturnExp(ReturnExp returnExp) {
        OperationBody body = QvtOperationalParserUtil.findParentElement(returnExp, OperationBody.class);
        if (body != null && body.getOperation() != null) {
            EClassifier actualType = (EClassifier)returnExp.getType();
            EClassifier declaredType = body.getOperation().getEType();
            if (actualType != null && declaredType != null) {
                int rel = TypeUtil.getRelationship((Environment)this.fEnv, (Object)actualType, (Object)declaredType);
                if ((rel & 3) == 0) {
                    String typeName = QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, declaredType);
                    this.fEnv.reportError(NLS.bind(ValidationMessages.typeMismatchError, typeName), returnExp.getStartPosition(), returnExp.getEndPosition());
                }
                if (returnExp.getValue() == null && !body.getOperation().getResult().isEmpty()) {
                    this.fEnv.reportError(ValidationMessages.missingReturnValueError, returnExp.getStartPosition(), returnExp.getEndPosition());
                }
            } else {
                if (actualType != null && returnExp.getValue() == null && declaredType == this.fEnv.getOCLStandardLibrary().getOclVoid()) {
                    return Boolean.TRUE;
                }
                String typeName = QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, declaredType);
                this.fEnv.reportError(NLS.bind(ValidationMessages.typeMismatchError, typeName), returnExp.getStartPosition(), returnExp.getEndPosition());
            }
            if (body instanceof MappingBody) {
                this.fEnv.reportError(ValidationMessages.returnNotAllowedInMappingYet, returnExp.getStartPosition(), returnExp.getEndPosition());
            }
        } else {
            this.fEnv.reportError(ValidationMessages.returnUsedOutsideOperationBody, returnExp.getStartPosition(), returnExp.getEndPosition());
        }
        return super.visitReturnExp(returnExp);
    }

    @Override
    public Object visitMappingOperation(MappingOperation operation) {
        boolean result = MappingExtensionHelper.validate(operation, this.fEnv);
        for (VarParameter resultParam : operation.getResult()) {
            result &= this.validateOutParamType(resultParam);
        }
        for (EParameter nextEParam : operation.getEParameters()) {
            VarParameter varParameter;
            if (!(nextEParam instanceof VarParameter) || (varParameter = (VarParameter)nextEParam).getKind() != DirectionKind.OUT) continue;
            result &= this.validateOutParamType(varParameter);
        }
        if (Boolean.TRUE.equals(super.visitMappingOperation(operation)) && result) {
            return true;
        }
        return false;
    }

    @Override
    public Object visitEntryOperation(EntryOperation entry) {
        EObject eContainer = entry.eContainer();
        if (eContainer instanceof Library) {
            this.fEnv.reportError(ValidationMessages.QvtOperationalValidationVisitor_MainInLibraryError, entry.getStartPosition(), entry.getEndPosition());
        }
        for (EParameter param : entry.getEParameters()) {
            if (!(param instanceof ASTNode)) continue;
            QvtOperationalUtil.reportWarning(this.fEnv, NLS.bind(ValidationMessages.EntryOp_DepricatedParamDecl, null), ((ASTNode)param).getStartPosition(), ((ASTNode)param).getEndPosition());
        }
        return super.visitEntryOperation(entry);
    }

    @Override
    public Object visitImperativeOperation(ImperativeOperation imperativeOperation) {
        EClassifier eType;
        boolean result = true;
        VarParameter context = imperativeOperation.getContext();
        if (context != null && !QvtOperationalValidationVisitor.isValidContextualType(eType = context.getEType())) {
            result = false;
            String errMessage = NLS.bind(ValidationMessages.QvtOperationalValidationVisitor_invalidContextualType, QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, eType));
            this.fEnv.reportError(errMessage, context.getStartPosition(), context.getEndPosition());
        }
        this.validateUniqueParamNames(imperativeOperation);
        for (EParameter nextEParam : imperativeOperation.getEParameters()) {
            VarParameter varParameter = (VarParameter)nextEParam;
            this.validateParamNameRequired(varParameter);
        }
        for (VarParameter nextResultParam : imperativeOperation.getResult()) {
            this.validateParamNameRequired(nextResultParam);
            if (nextResultParam.getKind() == DirectionKind.OUT) continue;
            this.fEnv.reportError(ValidationMessages.QvtOperationalValidationVisitor_resultParamDirectionMustBeOut, nextResultParam.getStartPosition(), nextResultParam.getEndPosition());
        }
        if (Boolean.TRUE.equals(super.visitImperativeOperation(imperativeOperation)) && result) {
            return true;
        }
        return false;
    }

    @Override
    public Object visitOperationBody(OperationBody operationBody) {
        ImperativeOperation operation;
        if (!(operationBody instanceof MappingBody) && (operation = operationBody.getOperation()).getEType() != null && operation.getEType() != this.fEnv.getOCLStandardLibrary().getOclVoid()) {
            int bodySize;
            EList<org.eclipse.ocl.ecore.OCLExpression> content = operationBody.getContent();
            if (operation.getResult().size() == 1 && ((bodySize = content.size()) == 0 && !operation.isIsBlackbox() || bodySize > 1 && !QvtOperationalVisitorCS.isOclExpDeterministic((OCLExpression<EClassifier>)((OCLExpression)content.get(bodySize - 1))))) {
                String message = ValidationMessages.useReturnExpForOperationResult;
                int endPos = operation.getResult().isEmpty() ? operationBody.getStartPosition() : ((VarParameter)operation.getResult().get(operation.getResult().size() - 1)).getEndPosition();
                this.fEnv.reportWarning(message, operation.getStartPosition(), endPos);
            }
        }
        return super.visitOperationBody(operationBody);
    }

    @Override
    public Object visitVariableInitExp(VariableInitExp variableInitExp) {
        EObject parentExp = variableInitExp.eContainer();
        if (!(parentExp instanceof OperationBody || parentExp instanceof BlockExp || parentExp instanceof AssignExp || parentExp instanceof Variable && parentExp.eContainer() != null && parentExp.eContainer() instanceof VariableInitExp)) {
            this.fEnv.reportError(ValidationMessages.QvtOperationalValidationVisitor_CannotDeclareVariables, variableInitExp.getStartPosition(), variableInitExp.getEndPosition());
        }
        return super.visitVariableInitExp(variableInitExp);
    }

    private static boolean isValidContextualType(EClassifier type) {
        return type != null && !QVTUMLReflection.isModuleInstance(type);
    }

    private boolean validateOutParamType(VarParameter resultParam) {
        EClassifier paramType = resultParam.getEType();
        if (paramType != null && (QVTUMLReflection.isModelTypeInstance(paramType) || QVTUMLReflection.isModuleInstance(paramType) || !QVTUMLReflection.isUserModelElement(paramType) && !(paramType instanceof CollectionType) && paramType != QvtOperationalStdLibrary.INSTANCE.getElementType())) {
            this.fEnv.reportError(NLS.bind(ValidationMessages.nonModelTypeError, QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, paramType)), resultParam.getStartPosition(), resultParam.getEndPosition());
            return false;
        }
        return true;
    }

    private void validateUniqueParamNames(ImperativeOperation operation) {
        List<ModelParameter> modelParams = QvtOperationalValidationVisitor.getModelParamsInScope(operation);
        EList regularParams = operation.getEParameters();
        EList<VarParameter> resultParams = operation.getResult();
        this.validateUniqueParamNames((List)regularParams, (List)modelParams);
        this.validateUniqueParamNames((List)regularParams, (List)regularParams);
        this.validateUniqueParamNames((List)resultParams, (List)modelParams);
        this.validateUniqueParamNames((List)resultParams, (List)regularParams);
        this.validateUniqueParamNames((List)resultParams, (List)resultParams);
    }

    private static List<ModelParameter> getModelParamsInScope(ImperativeOperation mappingOperation) {
        Module module = QvtOperationalParserUtil.getOwningModule(mappingOperation);
        return module instanceof OperationalTransformation ? ((OperationalTransformation)module).getModelParameter() : Collections.emptyList();
    }

    private boolean validateParamNameRequired(VarParameter param) {
        boolean result = true;
        String name = param.getName();
        if (name == null || name.trim().length() == 0) {
            result = false;
            this.fEnv.reportError(ValidationMessages.QvtOperationalValidationVisitor_parameterNamedRequired, param.getStartPosition(), param.getEndPosition());
        }
        return result;
    }

    private <T extends VarParameter> boolean validateUniqueParamNames(List<? extends T> params, List<? extends T> scopeParameters) {
        boolean result = true;
        for (VarParameter nextParam : params) {
            VarParameter sameNameParam;
            if (nextParam.getName() == null || (sameNameParam = (VarParameter)QvtOperationalValidationVisitor.findParamByName(nextParam.getName(), scopeParameters)) == null || sameNameParam == nextParam) continue;
            result = false;
            this.fEnv.reportError(NLS.bind(ValidationMessages.NameAlreadyDefinedError, new Object[]{nextParam.getName()}), nextParam.getStartPosition(), nextParam.getEndPosition());
        }
        return result;
    }

    private static <T extends EParameter> T findParamByName(String name, List<T> parameters) {
        for (EParameter nextParam : parameters) {
            String paramName = nextParam.getName();
            if (!(name != null ? name.equals(paramName) : name == paramName)) continue;
            return (T)nextParam;
        }
        return null;
    }

    private static class ValidationNodeProcessor
    implements QvtOperationalAstWalker.NodeProcessor {
        final CustomOclValidationVisitor myOclValidationVisitor;

        ValidationNodeProcessor(QvtOperationalEnv environment) {
            this.myOclValidationVisitor = new CustomOclValidationVisitor(environment);
        }

        public void process(Visitable e, Visitable parent) {
            if (e.eClass().eContainer() == EcorePackage.eINSTANCE) {
                try {
                    e.accept((Visitor)this.myOclValidationVisitor);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    }
}

