/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.internationalization.common.IPreferenceStoreListener;
import org.eclipse.papyrus.infra.internationalization.common.PreferenceStoreManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.internationalization.common";
    public static final String INTERNATIONALIZATION_NODE_LABEL = "internationalization";
    private static Activator plugin;
    public static LogHelper log;
    private PreferenceStoreManager preferenceStores;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        log = new LogHelper((Plugin)this);
        this.preferenceStores = new PreferenceStoreManager(log);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.preferenceStores.dispose();
        this.preferenceStores = null;
        plugin = null;
        super.stop(context);
    }

    public IPreferenceStore getInternationalizationPreferenceStore(IProject project, String papyrusProjectName) {
        return this.preferenceStores.getInternationalizationPreferenceStore(project, papyrusProjectName);
    }

    public IPreferenceStore getInternationalizationPreferenceStore() {
        return this.preferenceStores.getInternationalizationPreferenceStore();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void addPreferenceStoreListener(IPreferenceStoreListener listener) {
        this.preferenceStores.addPreferenceStoreListener(listener);
    }

    public void removePreferenceStoreListener(IPreferenceStoreListener listener) {
        this.preferenceStores.removePreferenceStoreListener(listener);
    }
}

