/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class CustomOwnerClassChangeCommand
extends AbstractTransactionalCommand {
    public static final String CUSTOMREMOVE_COMMAND = "CustomremoveCommand";
    private PackageableElement classifier;

    public CustomOwnerClassChangeCommand(TransactionalEditingDomain domain, PackageableElement containedclassifier) {
        super(domain, CUSTOMREMOVE_COMMAND, null);
        this.classifier = containedclassifier;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EList listNestedClassifier;
        PackageableElement sourceClassifier = (PackageableElement)this.classifier.getOwner();
        if (sourceClassifier instanceof Class) {
            Class sourceClass = (Class)sourceClassifier;
            Class targetClass = (Class)this.classifier;
            targetClass.setPackage(sourceClass.getPackage());
            listNestedClassifier = sourceClass.getNestedClassifiers();
            listNestedClassifier.remove((Object)targetClass);
        }
        if (sourceClassifier instanceof Package) {
            Package sourcePackage = (Package)sourceClassifier;
            Package targetPackage = (Package)this.classifier;
            targetPackage.setNestingPackage(sourcePackage.getNestingPackage());
            listNestedClassifier = sourcePackage.getNestedPackages();
            listNestedClassifier.remove((Object)targetPackage);
        }
        return CommandResult.newOKCommandResult();
    }
}

