/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.Bag;

public class BagImpl<E>
extends AbstractCollection<E>
implements Bag.Internal<E> {
    private final @NonNull Map<E, @NonNull ElementCounter> map = new HashMap<E, ElementCounter>();
    private int size = 0;
    private @Nullable Integer hashCode = null;
    private @Nullable ElementCounter spareCounter = null;

    public static <E> Bag<E> emptyBag() {
        return ValueUtil.EMPTY_BAG;
    }

    public BagImpl() {
    }

    public BagImpl(@NonNull Iterable<? extends E> someElements) {
        for (E anElement : someElements) {
            this.add(anElement);
        }
    }

    @Deprecated
    public BagImpl(@NonNull Collection<? extends E> someElements) {
        this.addAll(someElements);
    }

    public BagImpl(@NonNull Iterator<? extends E> someElements) {
        while (someElements.hasNext()) {
            this.add(someElements.next());
        }
    }

    @Override
    public synchronized boolean add(E anElement) {
        ElementCounter newCounter = this.spareCounter;
        if (newCounter == null) {
            newCounter = new ElementCounter();
        } else {
            this.spareCounter = null;
            newCounter.value = 1;
        }
        ElementCounter oldCounter = this.map.put(anElement, newCounter);
        if (oldCounter != null) {
            ElementCounter elementCounter = newCounter;
            elementCounter.value = elementCounter.value + oldCounter.value;
            this.spareCounter = oldCounter;
        }
        ++this.size;
        this.hashCode = null;
        return true;
    }

    @Override
    public void clear() {
        this.hashCode = null;
        this.size = 0;
        this.map.clear();
    }

    @Override
    public boolean contains(Object anElement) {
        return this.count(anElement) > 0;
    }

    @Override
    public int count(Object anElement) {
        ElementCounter count = this.map.get(anElement);
        return count != null ? count.value : 0;
    }

    @Override
    public boolean equals(Object thatElement) {
        if (thatElement == this) {
            return true;
        }
        if (!(thatElement instanceof Bag.Internal)) {
            return false;
        }
        Bag.Internal thatBag = (Bag.Internal)thatElement;
        if (this.size() != thatBag.size()) {
            return false;
        }
        Map thatMap = thatBag.getMap();
        for (E thisObject : this.map.keySet()) {
            ElementCounter thisCount = this.map.get(thisObject);
            assert (thisCount != null);
            Number thatCount = thatMap.get(thisObject);
            if (thatCount != null && thatCount.intValue() == thisCount.intValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Map<E, ? extends Number> getMap() {
        return this.map;
    }

    @Override
    public int hashCode() {
        Integer hashCode2 = this.hashCode;
        if (hashCode2 == null) {
            int result = 37;
            result = 37 * result + this.map.hashCode();
            result = 37 * result + this.size;
            hashCode2 = this.hashCode = Integer.valueOf(result);
        }
        return hashCode2;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        Iterator<E> objectIterator = this.map.keySet().iterator();
        if (objectIterator.hasNext()) {
            return new BagIterator(this.map, objectIterator);
        }
        return ClassUtil.emptyIterator();
    }

    @Override
    public boolean remove(Object anElement) {
        ElementCounter count = this.map.remove(anElement);
        if (count == null) {
            return false;
        }
        this.size -= count.value;
        this.hashCode = null;
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    private static class BagIterator<E>
    implements Iterator<E> {
        private final @NonNull Map<E, @NonNull ElementCounter> map;
        private final @NonNull Iterator<E> objectIterator;
        private E currentObject;
        private int residualCount;

        private BagIterator(@NonNull Map<E, @NonNull ElementCounter> map, @NonNull Iterator<E> objectIterator) {
            this.map = map;
            this.objectIterator = objectIterator;
            assert (objectIterator.hasNext());
            this.currentObject = objectIterator.next();
            ElementCounter count = map.get(this.currentObject);
            assert (count != null);
            this.residualCount = count.intValue();
        }

        @Override
        public boolean hasNext() {
            return this.residualCount > 0;
        }

        @Override
        public E next() {
            if (this.residualCount <= 0) {
                throw new NoSuchElementException();
            }
            if (--this.residualCount > 0) {
                return this.currentObject;
            }
            if (this.objectIterator.hasNext()) {
                E savedObject = this.currentObject;
                this.currentObject = this.objectIterator.next();
                ElementCounter count = this.map.get(this.currentObject);
                assert (count != null);
                this.residualCount = count.intValue();
                return savedObject;
            }
            this.residualCount = 0;
            return this.currentObject;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported by OCL collections");
        }
    }

    private static class ElementCounter
    extends Number {
        private static final long serialVersionUID = -4943324197108585350L;
        private int value = 1;

        private ElementCounter() {
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public boolean equals(Object thatElement) {
            if (thatElement == this) {
                return true;
            }
            if (!(thatElement instanceof Number)) {
                return false;
            }
            return this.value == ((Number)thatElement).intValue();
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

