/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.SelectionAggregator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;

public class SelectionServiceImpl
implements ESelectionService {
    private IEclipseContext context;

    @Inject
    SelectionServiceImpl(IEclipseContext context) {
        this.context = context;
    }

    @Override
    public void setSelection(Object selection) {
        this.context.set("org.eclipse.ui.output.selection", selection);
    }

    @Override
    public void setPostSelection(Object selection) {
        this.context.set("org.eclipse.ui.output.postSelection", selection);
    }

    @Override
    public Object getSelection() {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            return aggregator.getSelection();
        }
        return null;
    }

    @Override
    public Object getSelection(String partId) {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            return aggregator.getSelection(partId);
        }
        return null;
    }

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            aggregator.addSelectionListener(listener);
        }
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            aggregator.removeSelectionListener(listener);
        }
    }

    @Override
    public void addSelectionListener(String partId, ISelectionListener listener) {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            aggregator.addSelectionListener(partId, listener);
        }
    }

    @Override
    public void removeSelectionListener(String partId, ISelectionListener listener) {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            aggregator.removeSelectionListener(partId, listener);
        }
    }

    @Override
    public void addPostSelectionListener(ISelectionListener listener) {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            aggregator.addPostSelectionListener(listener);
        }
    }

    @Override
    public void removePostSelectionListener(ISelectionListener listener) {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            aggregator.removePostSelectionListener(listener);
        }
    }

    @Override
    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            aggregator.addPostSelectionListener(partId, listener);
        }
    }

    @Override
    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        SelectionAggregator aggregator = this.getServiceAggregator();
        if (aggregator != null) {
            aggregator.removePostSelectionListener(partId, listener);
        }
    }

    private SelectionAggregator getServiceAggregator() {
        SelectionAggregator aggregator = (SelectionAggregator)this.context.get(SelectionAggregator.class);
        if (aggregator != null) {
            return aggregator;
        }
        MApplication app = (MApplication)this.context.get(MApplication.class);
        if (app == null) {
            return null;
        }
        MWindow selectedWindow = (MWindow)app.getSelectedElement();
        IEclipseContext windowContext = selectedWindow.getContext();
        if (windowContext == null) {
            return null;
        }
        return (SelectionAggregator)windowContext.get(SelectionAggregator.class);
    }
}

