/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.handlers;

import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.architecture.ArchitectureUIPlugin;
import org.eclipse.papyrus.infra.ui.architecture.widgets.ArchitectureContextComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ChangeArchitectureContextHandler
extends AbstractHandler {
    private static final String DIALOG_SECTION = ChangeArchitectureContextHandler.class.getName();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selection = this.getSelection(event);
        if (selection == null) {
            return new IContributionItem[0];
        }
        ResourceSet resourceSet = selection.eResource().getResourceSet();
        if (!(resourceSet instanceof ModelSet)) {
            return new IContributionItem[0];
        }
        ArchitectureDescriptionUtils helper = new ArchitectureDescriptionUtils((ModelSet)resourceSet);
        Object[] contextIds = new String[]{helper.getArchitectureContextId()};
        Object[] viewpointIds = helper.getArchitectureViewpointIds().toArray(new String[0]);
        Shell shell = Display.getCurrent().getActiveShell();
        ArchitectureContextDialog dialog = new ArchitectureContextDialog(shell);
        dialog.setSelectedContexts((String[])contextIds);
        dialog.setSelectedViewpoints((String[])viewpointIds);
        dialog.create();
        if (dialog.open() == 0) {
            TransactionalEditingDomain dom = helper.getModelSet().getTransactionalEditingDomain();
            CompoundCommand cmd = new CompoundCommand("Change Architecture Context");
            if (!Arrays.equals(dialog.getSelectedContextIds(), contextIds)) {
                cmd.append(helper.switchArchitectureContextId(dialog.getSelectedContextIds()[0]));
            }
            if (!Arrays.equals(dialog.getSelectedViewpointIds(), viewpointIds)) {
                cmd.append(helper.switchArchitectureViewpointIds(dialog.getSelectedViewpointIds()));
            }
            if (!cmd.isEmpty()) {
                dom.getCommandStack().execute((Command)cmd);
            }
        }
        return null;
    }

    protected EObject getSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection struct = (IStructuredSelection)selection;
            Object obj = struct.getFirstElement();
            return EMFHelper.getEObject((Object)obj);
        }
        return null;
    }

    private class ArchitectureContextDialog
    extends Dialog {
        private String[] originalContextIds;
        private String[] selectedContextIds;
        private String[] selectedViewpointIds;

        protected ArchitectureContextDialog(Shell parentShell) {
            super(parentShell);
        }

        public String[] getSelectedContextIds() {
            return this.selectedContextIds;
        }

        public String[] getSelectedViewpointIds() {
            return this.selectedViewpointIds;
        }

        public void setSelectedContexts(String[] selectedContextIds) {
            this.selectedContextIds = selectedContextIds;
            this.originalContextIds = selectedContextIds;
        }

        public void setSelectedViewpoints(String[] selectedViewpointIds) {
            this.selectedViewpointIds = selectedViewpointIds;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            Label label = new Label(container, 0);
            label.setText("Switch the architecture context and/or viewpoints applied to the Papyrus model:");
            ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
            final ArchitectureContextComposite acc = new ArchitectureContextComposite(container, 1, 1, 1808, 0, 0);
            acc.setAllowSeveralContexts(false);
            acc.setSelectedContexts(this.selectedContextIds);
            acc.setSelectedViewpoints(this.selectedViewpointIds);
            acc.setInput(manager.getVisibleArchitectureContexts().toArray(new MergedArchitectureContext[0]));
            acc.setUpdater(new ArchitectureContextComposite.Updater(){

                @Override
                public void update() {
                    ArchitectureContextDialog.this.selectedContextIds = acc.getSelectedContexts();
                    ArchitectureContextDialog.this.selectedViewpointIds = acc.getSelectedViewpoints();
                }
            });
            return container;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Switch Architecture Context");
        }

        protected boolean isResizable() {
            return true;
        }

        protected IDialogSettings getDialogBoundsSettings() {
            IDialogSettings globalSettings = ArchitectureUIPlugin.getPlugin().getDialogSettings();
            IDialogSettings dialogSettings = globalSettings.getSection(DIALOG_SECTION);
            if (dialogSettings == null) {
                dialogSettings = globalSettings.addNewSection(DIALOG_SECTION);
            }
            return dialogSettings;
        }

        protected void okPressed() {
            if (!Arrays.equals(this.getSelectedContextIds(), this.originalContextIds)) {
                MessageBox messageBox = new MessageBox(this.getShell(), 200);
                messageBox.setMessage("Changing the architecture context may cause significant changes to the model.\nDo you like to proceed?");
                messageBox.setText("Warning");
                int response = messageBox.open();
                if (response != 64) {
                    return;
                }
            }
            super.okPressed();
        }
    }
}

