/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sashwindows.di.service;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiFactory;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashModel;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.ILocalPageService;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.osgi.framework.FrameworkUtil;

public class BasicPageManagerImpl
implements IPageManager {
    private SashWindowsMngr diSashModel;

    public BasicPageManagerImpl(SashWindowsMngr diSashModel) {
        this.diSashModel = diSashModel;
    }

    @Override
    public void closePage(Object pageIdentifier) {
        this.diSashModel.getSashModel().removePageAndEmptyFolder(pageIdentifier);
    }

    @Override
    public void closeAllOpenedPages() {
        this.diSashModel.getSashModel().removeAllPages();
    }

    @Override
    public void closeAllOpenedPages(Object pageIdentifier) {
        while (this.isOpen(pageIdentifier)) {
            this.closePage(pageIdentifier);
        }
    }

    @Override
    public void closeOtherPages(Object pageIdentifier) {
        this.diSashModel.getSashModel().removeOtherPages(pageIdentifier);
    }

    @Override
    @Deprecated
    public void addPage(Object pageIdentifier) {
        if (this.isLegacyMode()) {
            this.diSashModel.getPageList().addPage(pageIdentifier);
        }
    }

    private void doAddPage(Object pageIdentifier) {
        if (this.isLegacyMode()) {
            this.diSashModel.getPageList().addPage(pageIdentifier);
        }
        this.diSashModel.getSashModel().addPage(this.getCurrentFolder(), pageIdentifier);
    }

    private void doAddPage(PageRef page) {
        if (this.isLegacyMode()) {
            this.diSashModel.getPageList().addPage(page.getPageIdentifier());
        }
        this.diSashModel.getSashModel().addPage(this.getCurrentFolder(), page);
    }

    @Deprecated
    public void removePage(Object pageIdentifier) {
        this.closeAllOpenedPages(pageIdentifier);
        if (this.isLegacyMode()) {
            this.diSashModel.getPageList().removePage(pageIdentifier);
        }
    }

    @Override
    public void reloadPage(Object diagramProxy) {
        int i;
        TabFolder folder;
        PageRef proxyRef;
        if (diagramProxy instanceof EObject && (proxyRef = this.diSashModel.getSashModel().lookupPage(diagramProxy)).eContainer() instanceof TabFolder && (folder = (TabFolder)proxyRef.eContainer()) != null && folder.getChildren() != null && (i = folder.getChildren().indexOf((Object)proxyRef)) >= 0) {
            PageRef newRef = DiFactory.eINSTANCE.createPageRef();
            newRef.setEmfPageIdentifier((EObject)diagramProxy);
            folder.getChildren().set(i, (Object)newRef);
        }
    }

    @Override
    public List<Object> allPages() {
        List<Object> result;
        if (this.isLegacyMode()) {
            result = this.legacyAllPages();
        } else {
            result = new ArrayList<Object>();
            List<Resource> notationResources = this.getResources("notation");
            for (Resource notationResource : notationResources) {
                for (EObject content : notationResource.getContents()) {
                    if (!this.isPage(content)) continue;
                    result.add(content);
                }
            }
        }
        return result;
    }

    protected boolean isLegacyMode() {
        return this.diSashModel.getPageList() != null;
    }

    private List<Object> legacyAllPages() {
        List<Object> result = this.diSashModel.getPageList() != null ? this.diSashModel.getPageList().getAvailablePage().stream().map(PageRef::getPageIdentifier).filter(Objects::nonNull).collect(Collectors.toList()) : new ArrayList<Object>(0);
        return result;
    }

    @Override
    public List<Object> allLocalPages(ILocalPageService service) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object next : this.allPages()) {
            if (!service.isLocalPage(next)) continue;
            result.add(next);
        }
        return result;
    }

    @Override
    public List<Object> getAssociatedPages(Object uriTrim) {
        ArrayList<Object> list = new ArrayList<Object>();
        SashModel sashModel = this.diSashModel.getSashModel();
        TreeIterator iter = sashModel.eAllContents();
        while (iter.hasNext()) {
            URI uriContainer;
            EObject pageID;
            PageRef pageRef;
            Object next = iter.next();
            if (!(next instanceof PageRef) || (pageRef = (PageRef)next) == null || (pageID = pageRef.getEmfPageIdentifier()) == null) continue;
            if (pageID.eIsProxy()) {
                InternalEObject internal = (InternalEObject)pageID;
                uriContainer = internal.eProxyURI().trimFragment().trimFileExtension();
            } else {
                uriContainer = pageID.eResource().getURI().trimFileExtension();
            }
            if (!(uriTrim instanceof URI) || !uriContainer.equals(uriTrim)) continue;
            list.add(pageID);
        }
        return list;
    }

    private List<Resource> getResources(String fileExtension) {
        LinkedList<Resource> resourcesList = new LinkedList<Resource>();
        ResourceSet resourceSet = this.diSashModel.eResource().getResourceSet();
        for (Resource resource : resourceSet.getResources()) {
            if (resource == null || !resource.isLoaded() || !fileExtension.equals(resource.getURI().fileExtension())) continue;
            resourcesList.add(resource);
        }
        return resourcesList;
    }

    protected boolean isPage(EObject content) {
        return true;
    }

    protected TabFolder getCurrentFolder() {
        TabFolder result = this.diSashModel.getSashModel().getCurrentSelection();
        return result;
    }

    @Override
    public boolean isOpen(Object pageIdentifier) {
        return this.diSashModel.getSashModel().lookupPage(pageIdentifier) != null;
    }

    @Override
    public void openPage(Object pageIdentifier) {
        this.doAddPage(pageIdentifier);
    }

    @Override
    public void openPage(Object pageIdentifier, String editorID) {
        PageRef newPage = DiFactory.eINSTANCE.createPageRef();
        newPage.setFavoriteEditor(editorID);
        newPage.setPageIdentifier(pageIdentifier);
        this.doAddPage(newPage);
    }

    @Override
    public void selectPage(Object pageIdentifier) {
    }

    public <T> T execute(SashModelOperation<T> sashModelOperation) throws IllegalAccessException {
        if (FrameworkUtil.getBundle(sashModelOperation.getClass()) != FrameworkUtil.getBundle(BasicPageManagerImpl.class)) {
            throw new IllegalAccessException("Attempt to access bundle-private API.");
        }
        return this.doExecute(sashModelOperation);
    }

    protected <T> T doExecute(SashModelOperation<T> sashModelOperation) {
        return sashModelOperation.execute(this.diSashModel);
    }

    @FunctionalInterface
    public static interface SashModelOperation<T> {
        public T execute(SashWindowsMngr var1);
    }
}

