/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.urischeme.internal.registration.Util;

public class DesktopFileWriter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String EQUAL_SIGN = "=";
    private static final String KEY_MIME_TYPE = "MimeType";
    private static final String KEY_EXEC = "Exec";
    private static final String EXEC_URI_PLACEHOLDER = "%u";
    private Map<String, String> properties;

    public DesktopFileWriter(List<String> lines) {
        this.properties = this.getProperties(lines);
    }

    public List<String> getRegisteredSchemes(Collection<String> schemes) {
        String mimeType = this.properties.get(KEY_MIME_TYPE);
        if (mimeType == null || mimeType.isEmpty()) {
            return Collections.emptyList();
        }
        Predicate<String> matchingSchemes = scheme -> {
            Util.assertUriSchemeIsLegal(scheme);
            String handlerPlusScheme = this.getHandlerPlusScheme((String)scheme);
            return mimeType.contains(handlerPlusScheme);
        };
        return schemes.stream().filter(matchingSchemes).collect(Collectors.toList());
    }

    public void addScheme(String scheme) {
        Util.assertUriSchemeIsLegal(scheme);
        String handlerPlusScheme = this.getHandlerPlusScheme(scheme);
        if (this.properties.containsKey(KEY_MIME_TYPE)) {
            String mimeType = this.properties.get(KEY_MIME_TYPE);
            if (!mimeType.contains(handlerPlusScheme)) {
                mimeType = String.valueOf(mimeType) + handlerPlusScheme;
                this.properties.put(KEY_MIME_TYPE, mimeType);
            }
        } else {
            this.properties.put(KEY_MIME_TYPE, handlerPlusScheme);
        }
    }

    public void removeScheme(String scheme) {
        Util.assertUriSchemeIsLegal(scheme);
        if (this.properties.containsKey(KEY_MIME_TYPE)) {
            String handlerPlusScheme = this.getHandlerPlusScheme(scheme);
            String mimeType = this.properties.get(KEY_MIME_TYPE);
            if ((mimeType = mimeType.replace(handlerPlusScheme, "")).isEmpty()) {
                this.properties.remove(KEY_MIME_TYPE);
            } else {
                this.properties.put(KEY_MIME_TYPE, mimeType);
            }
        }
    }

    public byte[] getResult() {
        this.addUriPlaceholderToExecProperty();
        Function<Map.Entry<String, String>, String> toList = new Function<Map.Entry<String, String>, String>(){

            @Override
            public String apply(Map.Entry<String, String> e) {
                if (e.getValue() == null) {
                    return e.getKey();
                }
                return String.join((CharSequence)DesktopFileWriter.EQUAL_SIGN, e.getKey(), e.getValue());
            }
        };
        String result = this.properties.entrySet().stream().map(toList).collect(Collectors.joining(LINE_SEPARATOR));
        return result.getBytes();
    }

    private void addUriPlaceholderToExecProperty() {
        String execValue;
        if (this.properties.containsKey(KEY_EXEC) && !(execValue = this.properties.get(KEY_EXEC)).contains(EXEC_URI_PLACEHOLDER)) {
            this.properties.put(KEY_EXEC, String.valueOf(execValue) + " " + EXEC_URI_PLACEHOLDER);
        }
    }

    private Map<String, String> getProperties(List<String> lines) {
        this.assertLinesNotEmpty(lines);
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (String line : lines) {
            if (line.contains(EQUAL_SIGN)) {
                String[] split = line.split(EQUAL_SIGN);
                props.put(split[0], split[1]);
                continue;
            }
            props.put(line, null);
        }
        this.assertDesktopEntryPresent(props);
        return props;
    }

    private void assertDesktopEntryPresent(LinkedHashMap<String, String> props) {
        Iterator<Map.Entry<String, String>> iterator = props.entrySet().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("File seems not to be a 'desktop' file");
        }
        String firstLine = iterator.next().getKey();
        if (!"[Desktop Entry]".equals(firstLine)) {
            throw new IllegalStateException("File seems not to be a 'desktop' file");
        }
    }

    private void assertLinesNotEmpty(List<?> lines) {
        if (lines.isEmpty()) {
            throw new IllegalStateException("inputStream is empty");
        }
    }

    private String getHandlerPlusScheme(String scheme) {
        return "x-scheme-handler/" + scheme + ";";
    }
}

