/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.diagram.parametric.dnd;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.ExpansionElementDropStrategy;
import org.eclipse.papyrus.sysml14.diagram.parametric.command.ConstraintBlockParameterCreationCommand;
import org.eclipse.papyrus.sysml14.diagram.parametric.dnd.IParametricDropStrategy;

public class ConstraintBlockDropStrategy
extends ExpansionElementDropStrategy
implements IParametricDropStrategy {
    private static final int LOWEST_PRIORITY = -1000;
    private static final String INTERNAL_STRUCTURE_ID = "Class_StructureCompartment";

    public String getCategoryID() {
        return "org.eclipse.papyrus.sysml14.diagram.parametric";
    }

    public String getCategoryLabel() {
        return "Parameter drag and drop";
    }

    public String getID() {
        return "org.eclipse.papyrus.sysml14.diagram.parametric.dnd.ConstraintBlockDropStrategy";
    }

    public String getLabel() {
        return "Constraint Block drag and drop inside parametric diagram";
    }

    public String getDescription() {
        return "This strategy is is a specialization in order to be able to drop a Constraint Block inside Parametric diagram.";
    }

    public int getPriority() {
        return -1000;
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if ("move children".equals(request.getType())) {
            return null;
        }
        CompositeCommand cc = new CompositeCommand(this.getLabel());
        if (targetEditPart instanceof GraphicalEditPart) {
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)targetEditPart;
            List sourceElements = this.getSourceEObjects(request);
            if (sourceElements.isEmpty()) {
                return null;
            }
            ISpecializationType constraintPropertyElementType = (ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.SysML14.ConstraintBlock");
            if (INTERNAL_STRUCTURE_ID.equals(graphicalEditPart.getNotationView().getType())) {
                EObject targetElement = this.getTargetSemanticElement(targetEditPart);
                for (EObject sourceElement : sourceElements) {
                    if (!constraintPropertyElementType.getMatcher().matches(sourceElement)) continue;
                    Point dropedPoint = null;
                    if (request instanceof DropObjectsRequest) {
                        dropedPoint = ((DropObjectsRequest)request).getLocation();
                    }
                    cc.add((IUndoableOperation)new ConstraintBlockParameterCreationCommand("Create the corresponding constraint block parameter.", graphicalEditPart, targetElement, sourceElement, dropedPoint));
                }
            }
        }
        return cc.canExecute() ? new ICommandProxy(cc.reduce()) : null;
    }
}

