/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CopyAction;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class CleanupcopyAction
extends ProvisioningAction {
    public static final String ACTION_CLEANUPCOPY = "cleanupcopy";

    public IStatus execute(Map<String, Object> parameters) {
        return CleanupcopyAction.cleanupcopy(parameters, true);
    }

    public IStatus undo(Map<String, Object> parameters) {
        return CopyAction.copy(parameters, false);
    }

    public static IStatus cleanupcopy(Map<String, Object> parameters, boolean restoreable) {
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_CLEANUPCOPY));
        }
        String target = (String)parameters.get("target");
        if (target == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_CLEANUPCOPY));
        }
        IBackupStore backupStore = (IBackupStore)parameters.get("backup");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        IProfile profile = (IProfile)parameters.get("profile");
        String copied = profile.getInstallableUnitProperty(iu, "copied|" + source + "|" + target);
        if (copied == null) {
            return Status.OK_STATUS;
        }
        StringTokenizer tokenizer = new StringTokenizer(copied, "|");
        ArrayList<File> directories = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            String fileName = tokenizer.nextToken();
            File file = new File(fileName);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                directories.add(0, file);
                continue;
            }
            if (restoreable) {
                try {
                    backupStore.backup(file);
                    continue;
                }
                catch (IOException iOException) {
                    return Util.createError(NLS.bind((String)Messages.backup_file_failed, (Object)file));
                }
            }
            file.delete();
        }
        for (File directory : directories) {
            File[] children = directory.listFiles();
            if (children == null) {
                return Util.createError(NLS.bind((String)Messages.Error_list_children_0, (Object)directory));
            }
            if (children.length != 0) continue;
            if (restoreable) {
                try {
                    backupStore.backup(directory);
                    continue;
                }
                catch (IOException iOException) {
                    return Util.createError(NLS.bind((String)Messages.backup_file_failed, (Object)directory));
                }
            }
            directory.delete();
        }
        return Status.OK_STATUS;
    }
}

