/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.xtext.sheet;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractModelerPropertySection;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.properties.xtext.UndoRedoStack;
import org.eclipse.papyrus.uml.properties.xtext.sheet.ModelListener;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.StyledTextXtextAdapter;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AdvancedEditingPropertySection
extends AbstractModelerPropertySection
implements ContextElementAdapter.IContextElementProvider {
    private FormToolkit toolkit;
    private Form form;
    private StyledText textControl;
    private DefaultXtextDirectEditorConfiguration configuration;
    private StyledTextXtextAdapter xtextAdapter;
    private final ContextElementAdapter contextElementAdapter = new ContextElementAdapter((ContextElementAdapter.IContextElementProvider)this);
    UndoRedoStack<ExtendedModifyEvent> undoRedoStack = new UndoRedoStack();
    protected boolean isUndo;
    protected boolean isRedo;
    protected EObject currentEObj;

    public AdvancedEditingPropertySection() {
        ModelListener.currentEditor = this;
    }

    public void refresh() {
        this.updateXtextAdapters((Control)this.textControl);
        IParser parser = this.getParser();
        if (parser != null) {
            String printString = parser.getEditString(null, 0);
            this.textControl.setText(printString);
        }
        if (this.textControl != null) {
            this.textControl.setEnabled(!this.isReadOnly());
        }
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.xtextAdapter != null) {
            this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().remove((Object)this.contextElementAdapter);
        }
    }

    public void dispose() {
        super.dispose();
        ModelListener.currentEditor = null;
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    public final void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.setBorderStyle(2048);
        super.createControls(parent, aTabbedPropertySheetPage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.form = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.form);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.form);
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        this.createTextControl(this.form.getBody());
    }

    protected void createTextControl(Composite parent) {
        this.textControl = new StyledText(parent, 2626);
        this.textControl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                IParser parser = AdvancedEditingPropertySection.this.getParser();
                if (AdvancedEditingPropertySection.this.xtextAdapter.getCompletionProposalAdapter().delayedIsPopupOpen()) {
                    return;
                }
                if (parser != null && !parser.getEditString(null, 0).equals(AdvancedEditingPropertySection.this.textControl.getText())) {
                    ICommand command = parser.getParseCommand((IAdaptable)new EObjectAdapter(AdvancedEditingPropertySection.this.getEObject()), AdvancedEditingPropertySection.this.textControl.getText(), 0);
                    AdvancedEditingPropertySection.this.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(command));
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.textControl.setAlwaysShowScrollBars(false);
        GridDataFactory.fillDefaults().grab(true, true).hint(parent.getSize()).applyTo((Control)this.textControl);
        this.textControl.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                if (AdvancedEditingPropertySection.this.isUndo) {
                    AdvancedEditingPropertySection.this.undoRedoStack.pushRedo(event);
                } else {
                    AdvancedEditingPropertySection.this.undoRedoStack.pushUndo(event);
                    if (!AdvancedEditingPropertySection.this.isRedo) {
                        AdvancedEditingPropertySection.this.undoRedoStack.clearRedo();
                    }
                }
            }
        });
        this.textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean isAlt;
                boolean isCtrl = (e.stateMask & 0x40000) > 0;
                boolean bl = isAlt = (e.stateMask & 0x10000) > 0;
                if (isCtrl && !isAlt) {
                    boolean isShift;
                    boolean bl2 = isShift = (e.stateMask & 0x20000) > 0;
                    if (e.keyCode == 122) {
                        if (isShift) {
                            AdvancedEditingPropertySection.this.redo();
                        } else {
                            AdvancedEditingPropertySection.this.undo();
                        }
                    }
                }
            }
        });
    }

    protected void undo() {
        if (this.undoRedoStack.hasUndo()) {
            this.isUndo = true;
            this.revertEvent(this.undoRedoStack.popUndo());
            this.isUndo = false;
        }
    }

    protected void redo() {
        if (this.undoRedoStack.hasRedo()) {
            this.isRedo = true;
            this.revertEvent(this.undoRedoStack.popRedo());
            this.isRedo = false;
        }
    }

    private void revertEvent(ExtendedModifyEvent event) {
        this.textControl.replaceTextRange(event.start, event.length, event.replacedText);
        this.textControl.setSelectionRange(event.start, event.replacedText.length());
    }

    protected DefaultXtextDirectEditorConfiguration getConfigurationFromSelection() {
        IDirectEditorConfiguration configuration;
        String semanticClassName;
        String key;
        IPreferenceStore store;
        String languagePreferred;
        EObject semanticElement = this.getSemanticObjectFromSelection();
        if (semanticElement != null && (languagePreferred = (store = Activator.getDefault().getPreferenceStore()).getString(key = "papyrus.directeditor." + (semanticClassName = semanticElement.eClass().getInstanceClassName()))) != null && !languagePreferred.equals("") && (configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (EObject)semanticElement)) instanceof DefaultXtextDirectEditorConfiguration) {
            DefaultXtextDirectEditorConfiguration xtextConfiguration = (DefaultXtextDirectEditorConfiguration)configuration;
            xtextConfiguration.preEditAction((Object)semanticElement);
            return xtextConfiguration;
        }
        return null;
    }

    protected EObject getSemanticObjectFromSelection() {
        Object selection = this.getPrimarySelection();
        if (selection instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)selection).resolveSemanticElement();
        }
        if (selection instanceof IAdaptable) {
            return (EObject)((IAdaptable)selection).getAdapter(EObject.class);
        }
        return null;
    }

    protected IParser getParser() {
        EObject semanticElement = this.getSemanticObjectFromSelection();
        if (this.configuration != null && semanticElement != null) {
            return this.configuration.createParser(semanticElement);
        }
        return null;
    }

    protected void updateXtextAdapters(Control styledText) {
        Object oldObjectToEdit = this.configuration != null ? this.configuration.getObjectToEdit() : null;
        DefaultXtextDirectEditorConfiguration newConfiguration = this.getConfigurationFromSelection();
        if (newConfiguration != null && newConfiguration != this.configuration) {
            if (this.xtextAdapter != null) {
                this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().remove((Object)this.contextElementAdapter);
            }
            this.configuration = newConfiguration;
            this.xtextAdapter = new StyledTextXtextAdapter(this.configuration.getInjector());
            EObject semanticElement = this.getSemanticObjectFromSelection();
            if (semanticElement != null) {
                newConfiguration.preEditAction((Object)semanticElement);
            }
            this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().add((Object)this.contextElementAdapter);
            this.xtextAdapter.adapt((StyledText)styledText);
        }
        if (this.configuration.getObjectToEdit() != oldObjectToEdit) {
            Object semanticObject;
            ContextElementAdapter.IContextElementProvider provider = this.configuration.getContextProvider();
            if (provider instanceof ContextElementAdapter.IContextElementProviderWithInit && this.xtextAdapter != null) {
                ((ContextElementAdapter.IContextElementProviderWithInit)provider).initResource(this.xtextAdapter.getFakeResourceContext().getFakeResource());
            }
            if ((semanticObject = this.configuration.getObjectToEdit()) instanceof EObject) {
                this.currentEObj = (EObject)semanticObject;
            }
        }
    }

    public EObject getContextObject() {
        return this.getEObject();
    }

    protected boolean isReadOnly() {
        EObject context = this.getContextObject();
        return context == null || EMFHelper.isReadOnly((EObject)context) || super.isReadOnly();
    }
}

