/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml.executors;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml.Activator;
import org.eclipse.uml2.uml.Activity;

public class BTMLToBehaviortreeSchemaTransformExecutor {
    public static void run(Activity tr) throws ExecutionException {
        URI resBasePathName = tr.getModel().eResource().getURI();
        URI transformationURI = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml/transforms/BTMLToBehaviortreeSchema.qvto");
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        BasicEList semanticObjects = new BasicEList();
        semanticObjects.add((Object)tr);
        ResourceSet resourceSet = tr.eResource().getResourceSet();
        Resource notationResource = resourceSet.getResource(resBasePathName.trimFileExtension().appendFileExtension("notation"), false);
        EList notationObjects = notationResource.getContents();
        BasicModelExtent input1 = new BasicModelExtent((List)semanticObjects);
        BasicModelExtent input2 = new BasicModelExtent((List)notationObjects);
        BasicModelExtent output = new BasicModelExtent();
        OutputStreamWriter outStream = new OutputStreamWriter(System.out);
        WriterLog log = new WriterLog((Writer)outStream);
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setLog((Log)log);
        ExecutionDiagnostic result = executor.execute((ExecutionContext)context, new ModelExtent[]{input1, input2, output});
        if (result.getSeverity() == 0) {
            List outObjects = output.getContents();
            ResourceSetImpl resourceSet2 = new ResourceSetImpl();
            Resource outResource = resourceSet2.createResource(resBasePathName.trimSegments(1).appendSegment(tr.getName()).appendFileExtension("behaviortreeschema"));
            outResource.getContents().addAll((Collection)outObjects);
            try {
                outResource.save(Collections.emptyMap());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
            Activator.getDefault().getLog().log(status);
            throw new ExecutionException(status.getMessage());
        }
    }
}

