/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.vsl.ui.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.ui.util.DisplayUtils;
import org.eclipse.papyrus.marte.vsl.extensions.VSLContextUtil;
import org.eclipse.papyrus.marte.vsl.extensions.VSLTypeInferenceUtil;
import org.eclipse.papyrus.marte.vsl.ui.contentassist.AbstractVSLProposalProvider;
import org.eclipse.papyrus.marte.vsl.vSL.DataTypeName;
import org.eclipse.papyrus.marte.vsl.vSL.DurationObsName;
import org.eclipse.papyrus.marte.vsl.vSL.InstantObsName;
import org.eclipse.papyrus.marte.vsl.vSL.ListOfValueNamePairs;
import org.eclipse.papyrus.marte.vsl.vSL.NameOrChoiceOrBehaviorCall;
import org.eclipse.papyrus.marte.vsl.vSL.OperationCallExpression;
import org.eclipse.papyrus.marte.vsl.vSL.PrimaryExpression;
import org.eclipse.papyrus.marte.vsl.vSL.PropertyCallExpression;
import org.eclipse.papyrus.marte.vsl.vSL.QualifiedName;
import org.eclipse.papyrus.marte.vsl.vSL.ValueNamePair;
import org.eclipse.papyrus.marte.vsl.vSL.ValueSpecification;
import org.eclipse.papyrus.marte.vsl.validation.VSLJavaValidator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class CopyOfVSLProposalProvider
extends AbstractVSLProposalProvider {
    private ILabelProvider labelProvider = DisplayUtils.getLabelProvider();

    protected ICompletionProposal createCompletionProposal(NamedElement namedElement, String completionString, String displayString, ContentAssistContext context) {
        String additionalProposalInfo = namedElement.getQualifiedName() + "\n" + '(' + namedElement.eClass().getName() + ')';
        CompletionProposal completionProposal = new CompletionProposal(completionString, context.getOffset(), context.getSelectedText().length(), completionString.length(), this.labelProvider.getImage((Object)namedElement), " " + displayString, null, additionalProposalInfo);
        return completionProposal;
    }

    protected List<NamedElement> sortByKindAndName(List<NamedElement> list) {
        List<NamedElement> group;
        ArrayList<NamedElement> sortedList = new ArrayList<NamedElement>();
        HashMap<EClass, List<NamedElement>> namedElementGroups = new HashMap<EClass, List<NamedElement>>();
        for (NamedElement n : list) {
            if (!namedElementGroups.containsKey(n.eClass())) {
                group = new ArrayList<NamedElement>();
                group.add(n);
                namedElementGroups.put(n.eClass(), group);
                continue;
            }
            group = (List)namedElementGroups.get(n.eClass());
            boolean inserted = false;
            int i = 0;
            while (!inserted && i < group.size()) {
                if (((NamedElement)group.get(i)).getName().compareTo(n.getName()) > 0) {
                    group.add(i, n);
                    inserted = true;
                }
                ++i;
            }
            if (!inserted) {
                group.add(n);
            }
            namedElementGroups.put(n.eClass(), group);
        }
        for (EClass c : namedElementGroups.keySet()) {
            group = (List)namedElementGroups.get(c);
            sortedList.addAll(group);
        }
        return sortedList;
    }

    @Override
    public void completeQualifiedName_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        QualifiedName rule = model instanceof QualifiedName ? (QualifiedName)model : null;
        List<NamedElement> visibleNamespaces = this.getVisibleNamespaces(rule);
        visibleNamespaces = this.sortByKindAndName(visibleNamespaces);
        for (EObject eObject : visibleNamespaces) {
            NamedElement namespace = (NamedElement)eObject;
            if (!namespace.getName().startsWith(context.getPrefix())) continue;
            String completionString = String.valueOf(namespace.getName().substring(context.getPrefix().length())) + "::";
            String displayString = namespace.getName();
            ICompletionProposal completionProposal = this.createCompletionProposal(namespace, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    private List<NamedElement> getVisibleNamespaces(QualifiedName ctx) {
        ArrayList<NamedElement> allVisibleNamespaces = new ArrayList<NamedElement>();
        if (ctx != null) {
            Namespace nameSpace = ctx.getPath();
            for (NamedElement elem : nameSpace.getOwnedMembers()) {
                if (!(elem instanceof Classifier) && !(elem instanceof Package)) continue;
                allVisibleNamespaces.add(elem);
            }
        } else {
            allVisibleNamespaces.add((NamedElement)VSLJavaValidator.getModel());
        }
        return allVisibleNamespaces;
    }

    @Override
    public void completeNameOrChoiceOrBehaviorCall_Id(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        NameOrChoiceOrBehaviorCall rule = model instanceof NameOrChoiceOrBehaviorCall ? (NameOrChoiceOrBehaviorCall)model : null;
        List<NamedElement> visibleNames = this.getVisibleNames(rule, VSLContextUtil.getExpectedType((EObject)model));
        visibleNames = this.sortByKindAndName(visibleNames);
        for (EObject eObject : visibleNames) {
            NamedElement namedElement = (NamedElement)eObject;
            if (!namedElement.getName().startsWith(context.getPrefix())) continue;
            String completionString = namedElement.getName().substring(context.getPrefix().length());
            String displayString = namedElement.getName();
            if (namedElement instanceof TypedElement) {
                TypedElement typedElement = (TypedElement)namedElement;
                displayString = String.valueOf(displayString) + (typedElement.getType() != null ? " : " + typedElement.getType().getName() : "");
            }
            ICompletionProposal completionProposal = this.createCompletionProposal(namedElement, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    private List<NamedElement> getVisibleNames(NameOrChoiceOrBehaviorCall ctx, Type expectedType) {
        ArrayList<NamedElement> allVisibleNames = new ArrayList<NamedElement>();
        if (ctx != null) {
            QualifiedName qualifiedName = ctx.getPath();
            if (qualifiedName != null) {
                while (qualifiedName.getRemaining() != null) {
                    qualifiedName = qualifiedName.getRemaining();
                }
            }
            if (qualifiedName == null || qualifiedName.getPath() == null) {
                return allVisibleNames;
            }
            for (NamedElement elem : qualifiedName.getPath().getOwnedMembers()) {
                if (!(elem instanceof Property) && !(elem instanceof EnumerationLiteral)) continue;
                allVisibleNames.add(elem);
            }
        } else {
            ArrayList<Element> contextHierarchy = new ArrayList<Element>();
            contextHierarchy.add(VSLJavaValidator.getContextElement());
            Element tmpContext = VSLJavaValidator.getContextElement().getOwner();
            while (tmpContext != null) {
                contextHierarchy.add(0, tmpContext);
                tmpContext = tmpContext.getOwner();
            }
            for (Element currentContext : contextHierarchy) {
                for (Element elem : currentContext.getOwnedElements()) {
                    if (!(elem instanceof Property) && !(elem instanceof EnumerationLiteral)) continue;
                    allVisibleNames.add((NamedElement)elem);
                }
            }
            if (expectedType instanceof Enumeration) {
                allVisibleNames.addAll((Collection<NamedElement>)((Enumeration)expectedType).getOwnedLiterals());
            }
        }
        return allVisibleNames;
    }

    @Override
    public void completeInstantObsName_InstantId(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        InstantObsName rule = model instanceof InstantObsName ? (InstantObsName)model : null;
        List<NamedElement> visibleNames = this.getVisibleInstantObsNames(rule);
        visibleNames = this.sortByKindAndName(visibleNames);
        for (EObject eObject : visibleNames) {
            NamedElement namedElement = (NamedElement)eObject;
            if (!namedElement.getName().startsWith(context.getPrefix())) continue;
            String completionString = namedElement.getName().substring(context.getPrefix().length());
            String displayString = namedElement.getName();
            ICompletionProposal completionProposal = this.createCompletionProposal(namedElement, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    private List<NamedElement> getVisibleInstantObsNames(InstantObsName ctx) {
        ArrayList<NamedElement> allVisibleNames = new ArrayList<NamedElement>();
        if (ctx != null) {
            QualifiedName qualifiedName = ctx.getPath();
            if (qualifiedName != null) {
                while (qualifiedName.getRemaining() != null) {
                    qualifiedName = qualifiedName.getRemaining();
                }
                if (qualifiedName.getPath() == null) {
                    return allVisibleNames;
                }
                for (NamedElement elem : qualifiedName.getPath().getOwnedMembers()) {
                    if (!(elem instanceof TimeObservation)) continue;
                    allVisibleNames.add(elem);
                }
            } else {
                ArrayList<Element> contextHierarchy = new ArrayList<Element>();
                contextHierarchy.add(ctx.getContextElement());
                Element tmpContext = ctx.getContextElement().getOwner();
                while (tmpContext != null) {
                    contextHierarchy.add(0, tmpContext);
                    tmpContext = tmpContext.getOwner();
                }
                for (Element currentContext : contextHierarchy) {
                    for (Element elem : currentContext.getOwnedElements()) {
                        if (!(elem instanceof TimeObservation)) continue;
                        allVisibleNames.add((NamedElement)elem);
                    }
                }
            }
        } else {
            ArrayList<Element> contextHierarchy = new ArrayList<Element>();
            contextHierarchy.add(VSLJavaValidator.getContextElement());
            Element tmpContext = VSLJavaValidator.getContextElement().getOwner();
            while (tmpContext != null) {
                contextHierarchy.add(0, tmpContext);
                tmpContext = tmpContext.getOwner();
            }
            for (Element currentContext : contextHierarchy) {
                for (Element elem : currentContext.getOwnedElements()) {
                    if (!(elem instanceof TimeObservation)) continue;
                    allVisibleNames.add((NamedElement)elem);
                }
            }
        }
        return allVisibleNames;
    }

    @Override
    public void completeDurationObsName_DurationId(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        DurationObsName rule = model instanceof DurationObsName ? (DurationObsName)model : null;
        List<NamedElement> visibleNames = this.getVisibleDurationObsNames(rule);
        visibleNames = this.sortByKindAndName(visibleNames);
        for (EObject eObject : visibleNames) {
            NamedElement namedElement = (NamedElement)eObject;
            if (!namedElement.getName().startsWith(context.getPrefix())) continue;
            String completionString = namedElement.getName().substring(context.getPrefix().length());
            String displayString = namedElement.getName();
            ICompletionProposal completionProposal = this.createCompletionProposal(namedElement, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    private List<NamedElement> getVisibleDurationObsNames(DurationObsName ctx) {
        ArrayList<NamedElement> allVisibleNames = new ArrayList<NamedElement>();
        if (ctx != null) {
            QualifiedName qualifiedName = ctx.getPath();
            if (qualifiedName != null) {
                while (qualifiedName.getRemaining() != null) {
                    qualifiedName = qualifiedName.getRemaining();
                }
                if (qualifiedName.getPath() == null) {
                    return allVisibleNames;
                }
                for (NamedElement elem : qualifiedName.getPath().getOwnedMembers()) {
                    if (!(elem instanceof DurationObservation)) continue;
                    allVisibleNames.add(elem);
                }
            } else {
                ArrayList<Element> contextHierarchy = new ArrayList<Element>();
                contextHierarchy.add(ctx.getContextElement());
                Element tmpContext = ctx.getContextElement().getOwner();
                while (tmpContext != null) {
                    contextHierarchy.add(0, tmpContext);
                    tmpContext = tmpContext.getOwner();
                }
                for (Element currentContext : contextHierarchy) {
                    for (Element elem : currentContext.getOwnedElements()) {
                        if (!(elem instanceof DurationObservation)) continue;
                        allVisibleNames.add((NamedElement)elem);
                    }
                }
            }
        } else {
            ArrayList<Element> contextHierarchy = new ArrayList<Element>();
            contextHierarchy.add(VSLJavaValidator.getContextElement());
            Element tmpContext = VSLJavaValidator.getContextElement().getOwner();
            while (tmpContext != null) {
                contextHierarchy.add(0, tmpContext);
                tmpContext = tmpContext.getOwner();
            }
            for (Element currentContext : contextHierarchy) {
                for (Element elem : currentContext.getOwnedElements()) {
                    if (!(elem instanceof DurationObservation)) continue;
                    allVisibleNames.add((NamedElement)elem);
                }
            }
        }
        return allVisibleNames;
    }

    @Override
    public void completeDataTypeName_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        DataTypeName rule = model instanceof DataTypeName ? (DataTypeName)model : null;
        List<NamedElement> visibleNamespaces = this.getVisibleDataTypes(rule);
        visibleNamespaces = this.sortByKindAndName(visibleNamespaces);
        for (EObject eObject : visibleNamespaces) {
            NamedElement namespace = (NamedElement)eObject;
            if (!namespace.getName().startsWith(context.getPrefix())) continue;
            String completionString = namespace.getName().substring(context.getPrefix().length());
            String displayString = namespace.getName();
            ICompletionProposal completionProposal = this.createCompletionProposal(namespace, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    private List<NamedElement> getVisibleDataTypes(DataTypeName ctx) {
        ArrayList<NamedElement> allVisibleNames = new ArrayList<NamedElement>();
        if (ctx != null) {
            QualifiedName qualifiedName = ctx.getPath();
            if (qualifiedName != null) {
                while (qualifiedName.getRemaining() != null) {
                    qualifiedName = qualifiedName.getRemaining();
                }
                if (qualifiedName.getPath() == null) {
                    return allVisibleNames;
                }
                for (NamedElement elem : qualifiedName.getPath().getOwnedMembers()) {
                    if (!(elem instanceof DataType)) continue;
                    allVisibleNames.add(elem);
                }
            } else {
                ArrayList<Element> contextHierarchy = new ArrayList<Element>();
                contextHierarchy.add(ctx.getContextElement());
                Element tmpContext = ctx.getContextElement().getOwner();
                while (tmpContext != null) {
                    contextHierarchy.add(0, tmpContext);
                    tmpContext = tmpContext.getOwner();
                }
                for (Element currentContext : contextHierarchy) {
                    for (Element elem : currentContext.getOwnedElements()) {
                        if (!(elem instanceof DataType)) continue;
                        allVisibleNames.add((NamedElement)elem);
                    }
                }
            }
        } else {
            ArrayList<Element> contextHierarchy = new ArrayList<Element>();
            contextHierarchy.add(VSLJavaValidator.getContextElement());
            Element tmpContext = VSLJavaValidator.getContextElement().getOwner();
            while (tmpContext != null) {
                contextHierarchy.add(0, tmpContext);
                tmpContext = tmpContext.getOwner();
            }
            for (Element currentContext : contextHierarchy) {
                for (Element elem : currentContext.getOwnedElements()) {
                    if (!(elem instanceof DataType)) continue;
                    allVisibleNames.add((NamedElement)elem);
                }
            }
        }
        return allVisibleNames;
    }

    @Override
    public void completePropertyCallExpression_Property(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List<NamedElement> visibleProperties = this.getVisibleProperties(model);
        visibleProperties = this.sortByKindAndName(visibleProperties);
        for (EObject eObject : visibleProperties) {
            NamedElement namedElement = (NamedElement)eObject;
            if (!namedElement.getName().startsWith(context.getPrefix())) continue;
            String completionString = namedElement.getName().substring(context.getPrefix().length());
            String displayString = namedElement.getName();
            if (namedElement instanceof TypedElement) {
                TypedElement typedElement = (TypedElement)namedElement;
                displayString = String.valueOf(displayString) + (typedElement.getType() != null ? " : " + typedElement.getType().getName() : "");
            }
            ICompletionProposal completionProposal = this.createCompletionProposal(namedElement, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    private List<NamedElement> getVisibleProperties(EObject ctx) {
        ArrayList<NamedElement> allVisibleProperties = new ArrayList<NamedElement>();
        if (ctx instanceof PrimaryExpression) {
            ValueSpecification contextValueSpecification = ((PrimaryExpression)ctx).getPrefix();
            Type contextType = new VSLTypeInferenceUtil(null).typeOfValueSpecification(contextValueSpecification);
            if (contextType != null) {
                allVisibleProperties.addAll((Collection<NamedElement>)((Classifier)contextType).getAllAttributes());
            }
        } else if (ctx instanceof PropertyCallExpression) {
            Type contextType;
            PropertyCallExpression parent = (PropertyCallExpression)ctx;
            Type type = contextType = parent.getProperty() != null ? parent.getProperty().getType() : null;
            if (contextType != null) {
                allVisibleProperties.addAll((Collection<NamedElement>)((Classifier)contextType).getAllAttributes());
            }
        } else if (ctx instanceof OperationCallExpression) {
            Type contextType;
            OperationCallExpression parent = (OperationCallExpression)ctx;
            Type type = contextType = parent.getOperation() != null ? parent.getOperation().getType() : null;
            if (contextType != null) {
                allVisibleProperties.addAll((Collection<NamedElement>)((Classifier)contextType).getAllAttributes());
            }
        }
        return allVisibleProperties;
    }

    @Override
    public void completeOperationCallExpression_Operation(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List<NamedElement> visibleOperations = this.getVisibleOperations(model);
        visibleOperations = this.sortByKindAndName(visibleOperations);
        for (EObject eObject : visibleOperations) {
            NamedElement namedElement = (NamedElement)eObject;
            if (!namedElement.getName().startsWith(context.getPrefix())) continue;
            Operation operation = (Operation)namedElement;
            String completionString = String.valueOf(namedElement.getName().substring(context.getPrefix().length())) + "()";
            String displayString = String.valueOf(namedElement.getName()) + "()";
            displayString = String.valueOf(displayString) + (operation.getType() != null ? " : " + operation.getType().getName() : "");
            ICompletionProposal completionProposal = this.createCompletionProposal(namedElement, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    private List<NamedElement> getVisibleOperations(EObject ctx) {
        ArrayList<NamedElement> allVisibleOperations = new ArrayList<NamedElement>();
        if (ctx instanceof PrimaryExpression) {
            ValueSpecification contextValueSpecification = ((PrimaryExpression)ctx).getPrefix();
            Type contextType = new VSLTypeInferenceUtil(null).typeOfValueSpecification(contextValueSpecification);
            if (contextType != null) {
                allVisibleOperations.addAll((Collection<NamedElement>)((Classifier)contextType).getAllOperations());
            }
        } else if (ctx instanceof PropertyCallExpression) {
            Type contextType;
            PropertyCallExpression parent = (PropertyCallExpression)ctx;
            Type type = contextType = parent.getProperty() != null ? parent.getProperty().getType() : null;
            if (contextType != null) {
                allVisibleOperations.addAll((Collection<NamedElement>)((Classifier)contextType).getAllOperations());
            }
        } else if (ctx instanceof OperationCallExpression) {
            Type contextType;
            OperationCallExpression parent = (OperationCallExpression)ctx;
            Type type = contextType = parent.getOperation() != null ? parent.getOperation().getType() : null;
            if (contextType != null) {
                allVisibleOperations.addAll((Collection<NamedElement>)((Classifier)contextType).getAllOperations());
            }
        }
        return allVisibleOperations;
    }

    @Override
    public void completeValueNamePair_Property(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Type expectedType = VSLContextUtil.getExpectedType((EObject)model);
        List<NamedElement> filteredVisibleProperties = this.getVisiblePropertiesForValueNamePair(model, expectedType);
        EObject tmpContext = model;
        while (tmpContext != null && !(tmpContext instanceof ListOfValueNamePairs)) {
            tmpContext = tmpContext.eContainer();
        }
        if (tmpContext != null) {
            for (ValueNamePair valueNamePair : ((ListOfValueNamePairs)tmpContext).getValueNamePairs()) {
                filteredVisibleProperties.remove(valueNamePair.getProperty());
            }
        }
        filteredVisibleProperties = this.sortByKindAndName(filteredVisibleProperties);
        for (EObject eObject : filteredVisibleProperties) {
            NamedElement namespace = (NamedElement)eObject;
            if (!namespace.getName().startsWith(context.getPrefix())) continue;
            String completionString = String.valueOf(namespace.getName().substring(context.getPrefix().length())) + " = ";
            String displayString = String.valueOf(namespace.getName()) + " = ";
            ICompletionProposal completionProposal = this.createCompletionProposal(namespace, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    private List<NamedElement> getVisiblePropertiesForValueNamePair(EObject rule, Type expectedType) {
        ArrayList<NamedElement> visibleProperties = new ArrayList<NamedElement>();
        if (expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType") != null || expectedType.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType") != null) {
            visibleProperties.addAll((Collection<NamedElement>)((Classifier)expectedType).getAllAttributes());
        }
        return visibleProperties;
    }
}

