/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.handler;

import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.papyrus.designer.languages.common.codegen.ui.ChooseGenerator;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.Activator;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.TextEditorConstants;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.editor.SyncCDTEditor;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.SyncCDTtoModel;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.SyncModelToCDT;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.CheckedOperationHistory;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class SyncCDTEditorHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Class || this.selectedEObject instanceof Operation || this.selectedEObject instanceof Transition) {
            URI uri = this.selectedEObject.eResource().getURI();
            return uri.segmentCount() >= 2;
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            final ServicesRegistry serviceRegistry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
            TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
            AbstractEMFOperation command = new AbstractEMFOperation(domain, "Create CDT editor"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    try {
                        SyncCDTEditorHandler.this.doExecute(serviceRegistry);
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    catch (NotFoundException e) {
                        Activator.log.error((Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            CheckedOperationHistory.getInstance().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.log.error("Can't create a CDT editor", (Throwable)e);
        }
        catch (ServiceException e) {
            Activator.log.error("Service exception during creation of CDT editor", (Throwable)e);
        }
        return null;
    }

    public void doExecute(final ServicesRegistry serviceRegistry) throws ServiceException, NotFoundException {
        IFile srcFile;
        Transition transition;
        final Classifier classifierToEdit = this.getClassifierToEdit();
        final ILangCodegen codegen = ChooseGenerator.choose((Pattern)TextEditorConstants.CPP, (PackageableElement)classifierToEdit);
        if (codegen == null) {
            return;
        }
        if (this.selectedEObject instanceof Transition && (transition = (Transition)this.selectedEObject).getEffect() == null) {
            transition.createEffect("effectOf" + transition.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
        }
        if ((srcFile = SyncModelToCDT.syncModelToCDT(classifierToEdit, LanguageCodegen.getID((ILangCodegen)codegen))) == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    FileEditorInput input = new FileEditorInput(srcFile);
                    IEditorPart editorPart = page.openEditor((IEditorInput)input, "org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.editor.SyncCDTEditor");
                    if (editorPart instanceof SyncCDTEditor) {
                        URI uri = SyncCDTEditorHandler.this.selectedEObject.eResource().getURI();
                        SyncCDTtoModel syncCpp = new SyncCDTtoModel((IEditorInput)input, classifierToEdit, URI.decode((String)uri.segment(1)), LanguageCodegen.getID((ILangCodegen)codegen));
                        ((SyncCDTEditor)editorPart).setEditorData(serviceRegistry, syncCpp);
                    }
                }
                catch (PartInitException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        });
    }

    protected Classifier getClassifierToEdit() {
        if (this.selectedEObject instanceof Operation) {
            return (Classifier)((Operation)this.selectedEObject).getFeaturingClassifiers().get(0);
        }
        if (this.selectedEObject instanceof Transition) {
            return ((Transition)this.selectedEObject).getContainer().getStateMachine().getContext();
        }
        if (this.selectedEObject instanceof Behavior) {
            Behavior owner = (Behavior)this.selectedEObject;
            while (owner != null) {
                if (!((owner = owner.getOwner()) instanceof Classifier) || owner instanceof Behavior) continue;
                return (Classifier)owner;
            }
            return null;
        }
        if (this.selectedEObject instanceof Classifier) {
            return (Classifier)this.selectedEObject;
        }
        return null;
    }
}

