/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.handler;

import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.common.codegen.ui.ChooseGenerator;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.Activator;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.TextEditorConstants;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.handler.SyncCDTEditorHandler;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.modelresource.TextEditorModelSharedResource;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelManager;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashPanel;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.languages.designer.common.texteditor.model.TextEditorModel;
import org.eclipse.papyrus.languages.designer.common.texteditor.model.TextEditorModelFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class PapyrusCDTEditorHandler
extends SyncCDTEditorHandler {
    @Override
    public void doExecute(final ServicesRegistry serviceRegistry) throws ServiceException, NotFoundException {
        Transition transition;
        final IPageManager pageMngr = (IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)serviceRegistry);
        Classifier classifierToEdit = this.getClassifierToEdit();
        TextEditorModel editorModel = this.getEditorModel(serviceRegistry, classifierToEdit);
        if (editorModel == null && (editorModel = this.createEditorModel(serviceRegistry, classifierToEdit)) == null) {
            return;
        }
        ILangCodegen codegen = LanguageCodegen.getGenerator((Pattern)TextEditorConstants.CPP, (String)editorModel.getGeneratorID());
        if (codegen.getTargetProject((PackageableElement)classifierToEdit, true) == null) {
            return;
        }
        if (this.selectedEObject instanceof Transition && (transition = (Transition)this.selectedEObject).getEffect() == null) {
            transition.createEffect("effectOf" + transition.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
        }
        editorModel.setSelectedObject(this.selectedEObject);
        final TextEditorModel editorModelFinal = editorModel;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (pageMngr.isOpen((Object)editorModelFinal)) {
                    pageMngr.selectPage((Object)editorModelFinal);
                } else {
                    pageMngr.openPage((Object)editorModelFinal);
                }
                try {
                    DiSashModelManager modelMngr = (DiSashModelManager)ServiceUtils.getInstance().getService(DiSashModelManager.class, (Object)serviceRegistry);
                    ISashWindowsContentProvider sashContentProvider = modelMngr.getISashWindowsContentProvider();
                    Object rootModel = sashContentProvider.getRootModel();
                    if (rootModel instanceof TabFolder) {
                        ISashWindowsContainer sashContainer = (ISashWindowsContainer)ServiceUtils.getInstance().getService(ISashWindowsContainer.class, (Object)serviceRegistry);
                        int index = PapyrusCDTEditorHandler.lookupIndex((TabFolder)rootModel, editorModelFinal);
                        if (index != -1) {
                            sashContentProvider.createFolder(sashContainer.getSelectedTabFolderModel(), index, sashContainer.getSelectedTabFolderModel(), 131072);
                        }
                    } else {
                        boolean cfr_ignored_0 = rootModel instanceof SashPanel;
                    }
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        });
    }

    protected TextEditorModel createEditorModel(ServicesRegistry serviceRegistry, Classifier classifierToEdit) throws ServiceException, NotFoundException {
        TextEditorModel editorModel = TextEditorModelFactory.eINSTANCE.createTextEditorModel();
        editorModel.setEditedObject((EObject)classifierToEdit);
        editorModel.setType("CDTEditorInPapyrus");
        editorModel.setName("CDT " + classifierToEdit.getName());
        ILangCodegen codegen = ChooseGenerator.choose((Pattern)TextEditorConstants.CPP, (PackageableElement)classifierToEdit);
        if (codegen == null) {
            return null;
        }
        editorModel.setGeneratorID(LanguageCodegen.getID((ILangCodegen)codegen));
        TextEditorModelSharedResource model = (TextEditorModelSharedResource)ServiceUtils.getInstance().getModelSet((Object)serviceRegistry).getModelChecked("org.eclipse.papyrus.exteditor.cdt.CDTEditorModelSharedResource");
        model.addTextEditorModel(editorModel);
        return editorModel;
    }

    protected TextEditorModel getEditorModel(ServicesRegistry serviceRegistry, Classifier classifierToEdit) throws ServiceException, NotFoundException {
        TextEditorModelSharedResource model = (TextEditorModelSharedResource)ServiceUtils.getInstance().getModelSet((Object)serviceRegistry).getModelChecked("org.eclipse.papyrus.exteditor.cdt.CDTEditorModelSharedResource");
        return model.getTextEditorModel((EObject)classifierToEdit);
    }

    public static int lookupIndex(TabFolder folder, Object model) {
        int index = 0;
        for (PageRef pr : folder.getChildren()) {
            if (pr.getPageIdentifier() == model) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

