/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.editor;

import org.eclipse.cdt.codan.internal.ui.cxx.CodanCReconciler;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.Activator;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.editor.SyncCDTEditor;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.ObtainICElement;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.RevealCurrentOperation;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.SyncCDTtoModel;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.SyncModelToCDT;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.languages.designer.common.texteditor.model.TextEditorModel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class PapyrusCDTEditor
extends SyncCDTEditor {
    protected final TextEditorModel papyrusTextInstance;
    protected FocusListener barFocusListener;
    public static final String EDITOR_DEFAULT_NAME = "CDT Editor";
    public static final String EDITOR_TYPE = "CDTEditorInPapyrus";
    protected RevealCurrentOperation reveal;
    protected Adapter gotoListener = null;
    protected IAction gmfUndo;
    protected IAction gmfRedo;
    protected IAction textUndo;
    protected IAction textRedo;
    protected ISaveAndDirtyService saveAndDirtyService;
    protected IFile srcFile;
    protected ISelectionProvider sp;
    protected IEditorInput m_input;
    boolean oldDirty;

    public PapyrusCDTEditor(TextEditorModel papyrusTextInstance) {
        this.papyrusTextInstance = papyrusTextInstance;
    }

    public void createPartControl(Composite parent) {
        IActionBars actionBars = this.getEditorSite().getActionBars();
        if (actionBars != null && this.gmfUndo == null) {
            this.gmfUndo = actionBars.getGlobalActionHandler(ITextEditorActionConstants.UNDO);
            this.gmfRedo = actionBars.getGlobalActionHandler(ITextEditorActionConstants.REDO);
        }
        super.createPartControl(parent);
        if (actionBars != null) {
            this.textUndo = actionBars.getGlobalActionHandler(ITextEditorActionConstants.UNDO);
            this.textRedo = actionBars.getGlobalActionHandler(ITextEditorActionConstants.REDO);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.gmfUndo);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.gmfRedo);
            actionBars.updateActionBars();
        }
        this.gotoListener = new Adapter(){

            public void notifyChanged(Notification notification) {
                Object newValue;
                if (notification.getEventType() == 1 && (newValue = notification.getNewValue()) instanceof NamedElement) {
                    PapyrusCDTEditor.this.gotoElement((NamedElement)newValue);
                }
            }

            public Notifier getTarget() {
                return null;
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }
        };
        this.papyrusTextInstance.eAdapters().add((Object)this.gotoListener);
        if (this.papyrusTextInstance.getSelectedObject() instanceof NamedElement) {
            this.gotoElement((NamedElement)this.papyrusTextInstance.getSelectedObject());
        }
    }

    @Override
    public ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer viewer = super.createSourceViewer(parent, ruler, styles);
        this.barFocusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                IActionBars actionBars = PapyrusCDTEditor.this.getEditorSite().getActionBars();
                if (actionBars != null && PapyrusCDTEditor.this.gmfUndo != null && PapyrusCDTEditor.this.gmfRedo != null) {
                    actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, PapyrusCDTEditor.this.gmfUndo);
                    actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, PapyrusCDTEditor.this.gmfRedo);
                    actionBars.updateActionBars();
                }
            }

            public void focusGained(FocusEvent e) {
                IActionBars actionBars = PapyrusCDTEditor.this.getEditorSite().getActionBars();
                if (actionBars != null && PapyrusCDTEditor.this.textUndo != null && PapyrusCDTEditor.this.textRedo != null) {
                    actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, PapyrusCDTEditor.this.textUndo);
                    actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, PapyrusCDTEditor.this.textRedo);
                    actionBars.updateActionBars();
                }
            }
        };
        viewer.getTextWidget().addFocusListener(this.barFocusListener);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IEditorPart ep = PapyrusCDTEditor.this.getEditorSite().getPage().getActiveEditor();
                ISelection selection = PapyrusCDTEditor.this.getSelectionProvider().getSelection();
                if (ep instanceof IGotoMarker && selection instanceof ITextSelection) {
                    if (((ITextSelection)selection).getLength() > 0) {
                        return;
                    }
                    try {
                        Element element = PapyrusCDTEditor.this.reveal.obtainSelectedElement((ITextSelection)selection);
                        String modelURI = EcoreUtil.getURI((EObject)element).toString();
                        IMarker marker = PapyrusCDTEditor.this.srcFile.createMarker("org.eclipse.emf.ecore.diagnostic");
                        marker.setAttribute("severity", 0);
                        marker.setAttribute("uri", (Object)modelURI);
                        IWorkbenchPage wbpage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IWorkbenchPart activePart = wbpage.getActivePart();
                        ((IGotoMarker)ep).gotoMarker(marker);
                        wbpage.activate(activePart);
                        marker.delete();
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        return viewer;
    }

    @Override
    public void gotoElement(NamedElement element) {
        ICElement ice = CDTUITools.getEditorInputCElement((IEditorInput)this.m_input);
        if (ice instanceof ITranslationUnit) {
            ITranslationUnit itu = (ITranslationUnit)ice;
            ICElement icElement = ObtainICElement.getICElement(this.syncCpp.getCodeGen(), (IParent)itu, element);
            if (icElement instanceof ISourceReference) {
                try {
                    ISourceRange range = ((ISourceReference)icElement).getSourceRange();
                    ISourceViewer viewer = this.getSourceViewer();
                    viewer.revealRange(range.getStartPos(), 1);
                    viewer.setSelectedRange(range.getStartPos(), range.getLength());
                    return;
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    public boolean isDirty() {
        boolean isDirty = super.isDirty();
        if (isDirty != this.oldDirty) {
            this.oldDirty = isDirty;
        }
        return isDirty;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        URI uri = this.papyrusTextInstance.eResource().getURI();
        Classifier classifier = (Classifier)this.papyrusTextInstance.getEditedObject();
        String generatorID = this.papyrusTextInstance.getGeneratorID();
        this.srcFile = SyncModelToCDT.syncModelToCDT(classifier, generatorID);
        if (this.srcFile == null || !this.srcFile.exists()) {
            throw new PartInitException("Code generation before editing failed. Please check error log");
        }
        FileEditorInput newInput = new FileEditorInput(this.srcFile);
        super.doSetInput((IEditorInput)newInput);
        this.syncCpp = new SyncCDTtoModel((IEditorInput)newInput, classifier, uri.segment(1), generatorID);
        this.m_input = newInput;
        this.reveal = new RevealCurrentOperation((IEditorInput)newInput, classifier, uri.segment(1));
        this.addReconcileListener((ICReconcilingListener)new CodanCReconciler());
    }

    @Override
    public void dispose() {
        this.saveAndDirtyService.removeIsaveablePart((ISaveablePart)this);
        if (this.gotoListener != null) {
            this.papyrusTextInstance.eAdapters().remove((Object)this.gotoListener);
        }
        StyledText st = this.getSourceViewer().getTextWidget();
        st.removeFocusListener(this.barFocusListener);
        super.dispose();
        st.dispose();
    }
}

