/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.dashboard.ui.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ModelExtensionFilter
extends ViewerFilter {
    private List<String> fTargetExtension = new ArrayList<String>();

    public ModelExtensionFilter(String targetExtension) {
        this.fTargetExtension.add(targetExtension);
    }

    public ModelExtensionFilter(List<String> targetExtension) {
        this.fTargetExtension.addAll(targetExtension);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            for (String extension : this.fTargetExtension) {
                if (!((IFile)element).getName().toLowerCase().contains("." + extension)) continue;
                return true;
            }
            return false;
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return false;
        }
        if (element instanceof IContainer) {
            try {
                IResource[] resources;
                IResource[] iResourceArray = resources = ((IContainer)element).members();
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (this.select(viewer, parent, resource)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }
}

