/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.esf.core.common.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class ProjectFinder {
    private IProject mProject = null;

    public ProjectFinder(IProject pProject) {
        this.mProject = pProject;
    }

    public IFile findFirstFile(String pExtension) throws CoreException {
        IFile vResult = null;
        if (this.mProject != null && this.mProject.isAccessible()) {
            FileVisitorFinder vFinder = new FileVisitorFinder(pExtension);
            this.mProject.accept((IResourceVisitor)vFinder);
            vResult = vFinder.getFile();
        }
        return vResult;
    }

    public List<IFile> findAllFiles(String[] pExtensions) throws CoreException {
        ArrayList<IFile> vResultList = new ArrayList<IFile>();
        if (this.mProject != null && this.mProject.isAccessible()) {
            AllFileVisitor vVisitor = new AllFileVisitor(pExtensions);
            this.mProject.accept((IResourceVisitor)vVisitor);
            vResultList.addAll(vVisitor.getFiles());
        }
        return vResultList;
    }

    private class AllFileVisitor
    implements IResourceVisitor {
        private List<IFile> mSAFilesList = new ArrayList<IFile>();
        private List<String> mExtensionFilesList = null;

        AllFileVisitor(String[] pFileExtensions) {
            this.mExtensionFilesList = Arrays.asList(pFileExtensions);
        }

        public boolean visit(IResource pResource) throws CoreException {
            if (pResource instanceof IFile && (this.mExtensionFilesList.contains(pResource.getFileExtension()) || this.mExtensionFilesList.isEmpty())) {
                this.mSAFilesList.add((IFile)pResource);
            }
            return true;
        }

        public List<IFile> getFiles() {
            return this.mSAFilesList;
        }
    }

    private class FileVisitorFinder
    implements IResourceVisitor {
        private String mExtensionFilter = null;
        private IFile mFirstFile = null;

        FileVisitorFinder(String pExtension) {
            this.mExtensionFilter = pExtension;
        }

        public boolean visit(IResource pResource) throws CoreException {
            boolean vContinue;
            boolean bl = vContinue = this.mFirstFile == null;
            if (pResource.getType() == 1 && vContinue && pResource.getName().endsWith(this.mExtensionFilter)) {
                this.mFirstFile = (IFile)pResource;
                vContinue = false;
            }
            return vContinue;
        }

        public IFile getFile() {
            return this.mFirstFile;
        }
    }
}

