/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.esf.core.common.process;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.polarsys.esf.core.common.CommonActivator;

public class ProcessLauncher {
    private static final String PROCESS_INTERRUPTED = CommonActivator.getMessages().getString("ProcessLauncher.errorprocessinterrupted");
    private static final String ERROR_WHILE_READING_THE_DATA_IN_THE_STREAM = CommonActivator.getMessages().getString("ProcessLauncher.error.datastream");
    private static final String PROCESS_LAUNCHED_WITHOUT_TIMEOUT_INTERRUPTED = CommonActivator.getMessages().getString("ProcessLauncher.error.notimeout.interrupted");
    private static final String PROCESS_LAUNCHED_WITH_TIMEOUT_INTERRUPTED = CommonActivator.getMessages().getString("ProcessLauncher.error.timeout.interrupted");
    private static final String PROCESS_NOT_FINISHED_AFTER_THE_TIMEOUT = CommonActivator.getMessages().getString("ProcessLauncher.error.timeout");
    private OutputStream mOutputStream = null;
    private OutputStream mErrorStream = null;
    private InputStream mInputStream = null;
    private Process mExtAppProcess = null;
    private long mTimeout = 0L;
    private boolean mIsFinished = false;

    public ProcessLauncher() {
        this(null, null, null, 0L);
    }

    public ProcessLauncher(OutputStream pOutputStream, OutputStream pErrorStream) {
        this(pOutputStream, pErrorStream, null, 0L);
    }

    public ProcessLauncher(OutputStream pOutputStream, OutputStream pErrorStream, InputStream pInputStream) {
        this(pOutputStream, pErrorStream, pInputStream, 0L);
    }

    public ProcessLauncher(OutputStream pOutputStream, OutputStream pErrorStream, long pTimeout) {
        this(pOutputStream, pErrorStream, null, pTimeout);
    }

    public ProcessLauncher(OutputStream pOutputStream, OutputStream pErrorStream, InputStream pInputStream, long pTimeout) {
        this.mOutputStream = pOutputStream;
        this.mErrorStream = pErrorStream;
        this.mInputStream = pInputStream;
        this.mTimeout = pTimeout < 0L ? 0L : pTimeout;
    }

    public final int exec(String pCommandLine) throws IOException {
        this.mExtAppProcess = Runtime.getRuntime().exec(pCommandLine);
        return this.execute();
    }

    public final int exec(String[] pCommandLine) throws IOException {
        this.mExtAppProcess = Runtime.getRuntime().exec(pCommandLine);
        return this.execute();
    }

    public final int exec(String[] pCommandLine, String[] pEnvVarsArray) throws IOException {
        this.mExtAppProcess = Runtime.getRuntime().exec(pCommandLine, pEnvVarsArray);
        return this.execute();
    }

    public final int exec(String[] pCommandLine, String[] pEnvVarsArray, File pWorkingDirectory) throws IOException {
        this.mExtAppProcess = Runtime.getRuntime().exec(pCommandLine, pEnvVarsArray, pWorkingDirectory);
        return this.execute();
    }

    public final int exec(String pCommandLine, String[] pEnvVarsArray) throws IOException {
        this.mExtAppProcess = Runtime.getRuntime().exec(pCommandLine, pEnvVarsArray);
        return this.execute();
    }

    public final int exec(String pCommandLine, String[] pEnvVarsArray, File pWorkingDirectory) throws IOException {
        this.mExtAppProcess = Runtime.getRuntime().exec(pCommandLine, pEnvVarsArray, pWorkingDirectory);
        return this.execute();
    }

    private int execute() throws IOException {
        int vStatus = -1;
        if (this.mErrorStream == null) {
            this.mExtAppProcess.getErrorStream().close();
        } else {
            this.createStreamThread(this.mExtAppProcess.getErrorStream(), this.mErrorStream);
        }
        if (this.mOutputStream == null) {
            this.mExtAppProcess.getInputStream().close();
        } else {
            this.createStreamThread(this.mExtAppProcess.getInputStream(), this.mOutputStream);
        }
        if (this.mInputStream != null) {
            this.createStreamThread(this.mInputStream, this.mExtAppProcess.getOutputStream());
        }
        if (this.mTimeout > 0L) {
            Thread vProcessThread = this.createProcessThread(this.mExtAppProcess);
            vProcessThread.start();
            try {
                vProcessThread.join(this.mTimeout);
                try {
                    vStatus = this.mExtAppProcess.exitValue();
                }
                catch (IllegalThreadStateException pException) {
                    CommonActivator.logError(PROCESS_NOT_FINISHED_AFTER_THE_TIMEOUT, pException);
                    this.mExtAppProcess.destroy();
                    vStatus = this.mExtAppProcess.exitValue();
                }
            }
            catch (InterruptedException pException) {
                CommonActivator.logError(PROCESS_LAUNCHED_WITH_TIMEOUT_INTERRUPTED, pException);
            }
        } else {
            try {
                vStatus = this.mExtAppProcess.waitFor();
            }
            catch (InterruptedException pException) {
                CommonActivator.logError(PROCESS_LAUNCHED_WITHOUT_TIMEOUT_INTERRUPTED, pException);
            }
        }
        this.mIsFinished = true;
        return vStatus;
    }

    private void createStreamThread(final InputStream pInputStream, final OutputStream pOutputStream) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedInputStream vBuffInputStream = new BufferedInputStream(pInputStream);
                BufferedOutputStream vBuffOutputStream = null;
                if (pOutputStream != null) {
                    vBuffOutputStream = new BufferedOutputStream(pOutputStream);
                }
                byte[] vDataArray = new byte[2048];
                try {
                    int vNbBytesRead = vBuffInputStream.read(vDataArray);
                    while (!ProcessLauncher.this.mIsFinished && vNbBytesRead > 0) {
                        if (vBuffOutputStream != null) {
                            vBuffOutputStream.write(vDataArray, 0, vNbBytesRead);
                            vBuffOutputStream.flush();
                        }
                        vNbBytesRead = vBuffInputStream.read(vDataArray);
                    }
                }
                catch (IOException pException) {
                    CommonActivator.logError(ERROR_WHILE_READING_THE_DATA_IN_THE_STREAM, pException);
                }
            }
        }).start();
    }

    private Thread createProcessThread(final Process pProcess) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    pProcess.waitFor();
                }
                catch (InterruptedException pException) {
                    CommonActivator.logError(PROCESS_INTERRUPTED, pException);
                }
            }
        };
    }

    public final OutputStream getErrorStream() {
        return this.mErrorStream;
    }

    public final InputStream getInputStream() {
        return this.mInputStream;
    }

    public final OutputStream getOutputStream() {
        return this.mOutputStream;
    }

    public final long getTimeout() {
        return this.mTimeout;
    }

    public final void setErrorStream(OutputStream pErrorStream) {
        this.mErrorStream = pErrorStream;
    }

    public final void setInputStream(InputStream pInputStream) {
        this.mInputStream = pInputStream;
    }

    public final void setOutputStream(OutputStream pOutputStream) {
        this.mOutputStream = pOutputStream;
    }

    public final void setTimeout(long pTimeout) {
        this.mTimeout = pTimeout;
    }
}

