/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.esf.core.common.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public final class FileTools {
    public static final String DEFAULT_FILE_NAME = "Default_name";
    public static final int BUFFER_SIZE = 2048;
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final String ALL_NOTCHARNUMBER = "\\W+";
    private static final String UNDERSCORE = "_";

    private FileTools() {
    }

    public static boolean isValidName(String pFileName) {
        boolean vResult = false;
        if (pFileName != null) {
            vResult = Path.ROOT.isValidPath(pFileName);
        }
        return vResult;
    }

    public static String getCorrectName(String pCandidateName) {
        String vFilteredName = DEFAULT_FILE_NAME;
        if (pCandidateName != null && !pCandidateName.isEmpty()) {
            vFilteredName = pCandidateName.replaceAll(ALL_NOTCHARNUMBER, UNDERSCORE);
        }
        return vFilteredName;
    }

    public static void copyFile(URI pSourceURI, URI pTargetURI) throws IOException {
        ExtensibleURIConverterImpl vURIConverter = new ExtensibleURIConverterImpl();
        FileTools.deleteFile(pTargetURI);
        InputStream vSourceStream = vURIConverter.createInputStream(pSourceURI);
        OutputStream vTargetStream = vURIConverter.createOutputStream(pTargetURI);
        IOUtils.copy((InputStream)vSourceStream, (OutputStream)vTargetStream);
        vTargetStream.flush();
        vTargetStream.close();
        vSourceStream.close();
    }

    public static void zipFiles(List<URI> pURIsList, URI pTargetURI) throws IOException {
        if (pURIsList != null && pTargetURI != null) {
            FileTools.deleteFile(pTargetURI);
            ExtensibleURIConverterImpl vURIConverter = new ExtensibleURIConverterImpl();
            OutputStream vOutStream = vURIConverter.createOutputStream(pTargetURI);
            ZipOutputStream vZipOut = new ZipOutputStream(vOutStream);
            vZipOut.setLevel(9);
            byte[] vDataArray = new byte[2048];
            for (URI vURI : pURIsList) {
                InputStream vEntryStream = vURIConverter.createInputStream(vURI);
                ZipEntry vEntry = new ZipEntry(URI.decode((String)vURI.lastSegment()));
                vZipOut.putNextEntry(vEntry);
                int vCount = vEntryStream.read(vDataArray, 0, 2048);
                while (vCount != -1) {
                    vZipOut.write(vDataArray, 0, vCount);
                    vCount = vEntryStream.read(vDataArray, 0, 2048);
                }
                vZipOut.flush();
                vZipOut.closeEntry();
                vEntryStream.close();
            }
            vZipOut.close();
            vOutStream.close();
        }
    }

    public static void unzip(URI pArchiveURI, URI pTargetDirectoryURI) throws IOException {
        if (pArchiveURI != null && pTargetDirectoryURI != null) {
            ExtensibleURIConverterImpl vURIConverter = new ExtensibleURIConverterImpl();
            InputStream vInputStream = vURIConverter.createInputStream(pArchiveURI);
            ZipInputStream vZipInputStream = new ZipInputStream(vInputStream);
            ZipEntry vZipEntry = vZipInputStream.getNextEntry();
            while (vZipEntry != null) {
                URI vTargetEntryURI = pTargetDirectoryURI.appendSegment(vZipEntry.getName());
                FileTools.deleteFile(vTargetEntryURI);
                OutputStream vTargetStream = vURIConverter.createOutputStream(vTargetEntryURI);
                byte[] vDataArray = new byte[2048];
                int vCount = vZipInputStream.read(vDataArray, 0, 2048);
                while (vCount != -1) {
                    vTargetStream.write(vDataArray, 0, vCount);
                    vCount = vZipInputStream.read(vDataArray, 0, 2048);
                }
                vZipEntry = vZipInputStream.getNextEntry();
                vTargetStream.flush();
                vTargetStream.close();
            }
            vZipInputStream.close();
            vInputStream.close();
        }
    }

    private static void deleteFile(URI pFileURI) throws IOException {
        File vTargetFile = new File(CommonPlugin.resolve((URI)pFileURI).toFileString());
        if (vTargetFile.exists()) {
            FileUtils.forceDelete((File)vTargetFile);
        }
    }

    public static File createTempDir() {
        File vBaseDir = new File(System.getProperty("java.io.tmpdir"));
        String vBaseName = String.valueOf(System.currentTimeMillis()) + "-";
        int vCounter = 0;
        while (vCounter < 10000) {
            File vTempDir = new File(vBaseDir, String.valueOf(vBaseName) + vCounter);
            if (vTempDir.mkdir()) {
                return vTempDir;
            }
            ++vCounter;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + vBaseName + "0 to " + vBaseName + 9999 + ')');
    }

    public static String getExtensionFile(File pFile) {
        String vExt = null;
        if (pFile != null) {
            vExt = "";
            String vFileName = pFile.getName();
            int vIndex = vFileName.lastIndexOf(46);
            if (vIndex > 0 && vIndex < vFileName.length() - 1) {
                vExt = vFileName.substring(vIndex + 1).toLowerCase();
            }
        }
        return vExt;
    }

    public static File loadFile(String pFileURIAsString) {
        File vResultFile = null;
        if (StringUtils.isNotEmpty((CharSequence)pFileURIAsString)) {
            URI vFileURI = URI.createURI((String)pFileURIAsString);
            vResultFile = FileTools.loadFile(vFileURI);
        }
        return vResultFile;
    }

    public static File loadFile(URI pFileURI) {
        File vResultFile = null;
        if (pFileURI != null) {
            String vFilePath;
            URI vLocalURI = pFileURI;
            if (vLocalURI.isPlatform()) {
                vLocalURI = CommonPlugin.asLocalURI((URI)vLocalURI);
            }
            if ((vFilePath = vLocalURI.toFileString()) != null) {
                vResultFile = new File(vFilePath);
            }
        }
        return vResultFile;
    }

    public static IProject getProject(URI pFileURI) {
        IProject vCurrentProject = null;
        if (pFileURI != null) {
            IWorkspaceRoot vWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile vFile = vWorkspaceRoot.getFileForLocation((IPath)new Path(pFileURI.toFileString()));
            vCurrentProject = vFile.getProject();
        }
        return vCurrentProject;
    }
}

