/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.esf.core.common.adapter;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.esf.core.common.CommonActivator;
import org.polarsys.esf.core.common.listener.IProblemIndicationListener;

public class ProblemIndicationAdapter
extends EContentAdapter {
    private Map<Resource, Diagnostic> mResourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    private Set<IProblemIndicationListener> mListenersSet = new HashSet<IProblemIndicationListener>();

    public void notifyChanged(Notification pNotification) {
        if (pNotification.getNotifier() instanceof Resource) {
            switch (pNotification.getFeatureID(Resource.class)) {
                case 4: 
                case 6: 
                case 7: {
                    Resource vResource = (Resource)pNotification.getNotifier();
                    Diagnostic vDiagnostic = this.analyzeResourceProblems(vResource, null);
                    if (vDiagnostic.getSeverity() != 0) {
                        this.mResourceToDiagnosticMap.put(vResource, vDiagnostic);
                    } else {
                        this.mResourceToDiagnosticMap.remove(vResource);
                    }
                    this.fireProblemIndication();
                    break;
                }
            }
        } else {
            super.notifyChanged(pNotification);
        }
    }

    protected void setTarget(Resource pTargetResource) {
        this.basicSetTarget((Notifier)pTargetResource);
    }

    protected void unsetTarget(Resource pTargetResource) {
        this.basicUnsetTarget((Notifier)pTargetResource);
        this.mResourceToDiagnosticMap.remove(pTargetResource);
        this.fireProblemIndication();
    }

    private Diagnostic analyzeResourceProblems(Resource pResource, Exception pException) {
        Diagnostic vDiagnostic = Diagnostic.OK_INSTANCE;
        if (pResource == null) {
            vDiagnostic = new BasicDiagnostic(4, CommonActivator.getPlugin().getSymbolicName(), 0, CommonActivator.getMessages().getString("ProblemIndicationAdapter.diagnostics.error.null"), new Object[]{pException});
        } else if (!pResource.getErrors().isEmpty() || !pResource.getWarnings().isEmpty()) {
            Object[] vDataArray = null;
            vDataArray = pException == null ? new Object[]{pException} : new Object[]{pResource};
            vDiagnostic = new BasicDiagnostic(4, CommonActivator.getPlugin().getSymbolicName(), 0, CommonActivator.getMessages().getString("ProblemIndicationAdapter.diagnostics.error.creation", new Object[]{pResource.getURI()}), vDataArray);
            ((BasicDiagnostic)vDiagnostic).merge(EcoreUtil.computeDiagnostic((Resource)pResource, (boolean)true));
        } else if (pException != null) {
            vDiagnostic = new BasicDiagnostic(4, CommonActivator.getPlugin().getSymbolicName(), 0, CommonActivator.getMessages().getString("ProblemIndicationAdapter.diagnostics.error.exception", new Object[]{pResource.getURI()}), new Object[]{pException});
        }
        return vDiagnostic;
    }

    public void analyzeResource(Resource pResource, Exception pException) {
        Diagnostic vDiagnostic;
        boolean vDiagnosticsChanged = false;
        if (!this.mResourceToDiagnosticMap.containsKey(pResource) && (vDiagnostic = this.analyzeResourceProblems(pResource, pException)).getSeverity() != 0) {
            this.mResourceToDiagnosticMap.put(pResource, vDiagnostic);
            vDiagnosticsChanged = true;
        }
        if (vDiagnosticsChanged) {
            this.fireProblemIndication();
        }
    }

    public Diagnostic getDiagnostic() {
        BasicDiagnostic vRootDiagnostic = new BasicDiagnostic(0, CommonActivator.getPlugin().getSymbolicName(), 0, null, null);
        for (Diagnostic vChildDiagnostic : this.mResourceToDiagnosticMap.values()) {
            if (vChildDiagnostic.getSeverity() == 0) continue;
            vRootDiagnostic.add(vChildDiagnostic);
        }
        return vRootDiagnostic;
    }

    public void addProblemIndicationListener(IProblemIndicationListener pListener) {
        this.mListenersSet.add(pListener);
    }

    public void removeProblemIndicationListener(IProblemIndicationListener pListener) {
        this.mListenersSet.remove(pListener);
    }

    private void fireProblemIndication() {
        Diagnostic vDiagnostic = this.getDiagnostic();
        for (IProblemIndicationListener vListener : this.mListenersSet) {
            vListener.updateProblemIndication(vDiagnostic);
        }
    }
}

